/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data.component;

import com.iafenvoy.iceandfire.data.component.NeedUpdateData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;

public class MiscData
extends NeedUpdateData {
    public int loveTicks;
    public int lungeTicks;
    public boolean hasDismounted;
    public List<LivingEntity> targetedByScepter;
    private List<Integer> targetedByScepterIds;
    private boolean isInitialized;

    public void tickMisc(LivingEntity entity) {
        if (!this.isInitialized) {
            this.initialize(entity.level());
        }
        if (this.loveTicks > 0) {
            --this.loveTicks;
            if (this.loveTicks == 0) {
                this.triggerUpdate();
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.getNavigation().recomputePath();
                }
                return;
            }
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.setLastHurtByPlayer(null);
                mob.setLastHurtByMob(null);
                mob.setTarget(null);
                mob.setAggressive(false);
                mob.getNavigation().stop();
            }
            this.createLoveParticles(entity);
        }
    }

    public List<LivingEntity> getTargetedByScepter() {
        return Objects.requireNonNullElse(this.targetedByScepter, Collections.emptyList());
    }

    public void addScepterTarget(LivingEntity target) {
        if (this.targetedByScepter == null) {
            this.targetedByScepter = new ArrayList<LivingEntity>();
        } else if (this.targetedByScepter.contains(target)) {
            return;
        }
        this.targetedByScepter.add(target);
        this.triggerUpdate();
    }

    public void removeScepterTarget(LivingEntity target) {
        if (this.targetedByScepter == null) {
            return;
        }
        this.targetedByScepter.remove(target);
        this.triggerUpdate();
    }

    public void checkScepterTarget() {
        if (this.targetedByScepter == null) {
            return;
        }
        this.targetedByScepter.removeIf(living -> living.isRemoved() || living.getEffect(MobEffects.WITHER) == null || living.getEffect(MobEffects.WITHER).getDuration() <= 0);
    }

    public void setLoveTicks(int loveTicks) {
        this.loveTicks = loveTicks;
        this.triggerUpdate();
    }

    public void setLungeTicks(int lungeTicks) {
        this.lungeTicks = lungeTicks;
        this.triggerUpdate();
    }

    public void setDismounted(boolean hasDismounted) {
        this.hasDismounted = hasDismounted;
        this.triggerUpdate();
    }

    public void serialize(CompoundTag tag) {
        CompoundTag miscData = new CompoundTag();
        miscData.putInt("loveTicks", this.loveTicks);
        miscData.putInt("lungeTicks", this.lungeTicks);
        miscData.putBoolean("hasDismounted", this.hasDismounted);
        if (this.targetedByScepter != null) {
            int[] ids = new int[this.targetedByScepter.size()];
            for (int i = 0; i < this.targetedByScepter.size(); ++i) {
                ids[i] = this.targetedByScepter.get(i).getId();
            }
            tag.putIntArray("targetedByScepterIds", ids);
        }
        tag.put("miscData", (Tag)miscData);
    }

    public void deserialize(CompoundTag tag) {
        CompoundTag miscData = tag.getCompound("miscData");
        this.loveTicks = miscData.getInt("loveTicks");
        this.lungeTicks = miscData.getInt("lungeTicks");
        this.hasDismounted = miscData.getBoolean("hasDismounted");
        int[] loadedChainedToIds = miscData.getIntArray("targetedByScepterIds");
        this.isInitialized = false;
        if (loadedChainedToIds.length > 0) {
            this.targetedByScepterIds = new ArrayList<Integer>();
            for (int loadedChainedToId : loadedChainedToIds) {
                this.targetedByScepterIds.add(loadedChainedToId);
            }
        }
    }

    private void createLoveParticles(LivingEntity entity) {
        if (entity.getRandom().nextInt(7) == 0) {
            for (int i = 0; i < 5; ++i) {
                entity.level().addParticle((ParticleOptions)ParticleTypes.HEART, entity.getX() + (entity.getRandom().nextDouble() - 0.5) * 3.0, entity.getY() + (entity.getRandom().nextDouble() - 0.5) * 3.0, entity.getZ() + (entity.getRandom().nextDouble() - 0.5) * 3.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void initialize(Level level) {
        ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
        if (this.targetedByScepterIds != null) {
            for (int id : this.targetedByScepterIds) {
                Entity entity;
                if (id == -1 || !((entity = level.getEntity(id)) instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                entities.add(livingEntity);
            }
        }
        this.targetedByScepter = !entities.isEmpty() ? entities : null;
        this.targetedByScepterIds = null;
        this.isInitialized = true;
    }
}

