/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityGorgon;
import com.iafenvoy.iceandfire.entity.ai.CockatriceAIAggroLook;
import com.iafenvoy.iceandfire.entity.ai.CockatriceAIFollowOwner;
import com.iafenvoy.iceandfire.entity.ai.CockatriceAIStareAttack;
import com.iafenvoy.iceandfire.entity.ai.CockatriceAITarget;
import com.iafenvoy.iceandfire.entity.ai.CockatriceAITargetItems;
import com.iafenvoy.iceandfire.entity.ai.CockatriceAIWander;
import com.iafenvoy.iceandfire.entity.ai.EntityAIAttackMeleeNoCooldown;
import com.iafenvoy.iceandfire.entity.ai.IAFLookHelper;
import com.iafenvoy.iceandfire.entity.util.HomePosition;
import com.iafenvoy.iceandfire.entity.util.IBlacklistedFromStatues;
import com.iafenvoy.iceandfire.entity.util.IHasCustomizableAttributes;
import com.iafenvoy.iceandfire.entity.util.IVillagerFear;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.registry.tag.IafEntityTags;
import com.iafenvoy.iceandfire.registry.tag.IafItemTags;
import com.iafenvoy.iceandfire.world.GenerationConstants;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityCockatrice
extends TamableAnimal
implements IAnimatedEntity,
IBlacklistedFromStatues,
IVillagerFear,
IHasCustomizableAttributes {
    public static final Animation ANIMATION_JUMPAT = Animation.create((int)30);
    public static final Animation ANIMATION_WATTLESHAKE = Animation.create((int)20);
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_SPEAK = Animation.create((int)10);
    public static final Animation ANIMATION_EAT = Animation.create((int)20);
    public static final float VIEW_RADIUS = 0.6f;
    private static final EntityDataAccessor<Boolean> HEN = SynchedEntityData.defineId(EntityCockatrice.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> STARING = SynchedEntityData.defineId(EntityCockatrice.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> TARGET_ENTITY = SynchedEntityData.defineId(EntityCockatrice.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TAMING_PLAYER = SynchedEntityData.defineId(EntityCockatrice.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TAMING_LEVEL = SynchedEntityData.defineId(EntityCockatrice.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.defineId(EntityCockatrice.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final CockatriceAIStareAttack aiStare;
    private final MeleeAttackGoal aiMelee;
    public float sitProgress;
    public float stareProgress;
    public int ticksStaring = 0;
    public HomePosition homePos;
    public boolean hasHomePosition = false;
    private int animationTick;
    private Animation currentAnimation;
    private boolean isSitting;
    private boolean isStaring;
    private boolean isMeleeMode = false;
    private LivingEntity targetedEntity;
    private int clientSideAttackTime;

    public EntityCockatrice(EntityType<EntityCockatrice> type, Level worldIn) {
        super(type, worldIn);
        this.lookControl = new IAFLookHelper((Mob)this);
        this.aiStare = new CockatriceAIStareAttack(this, 1.0, 0, 15.0f);
        this.aiMelee = new EntityAIAttackMeleeNoCooldown((PathfinderMob)this, 1.5, false);
    }

    public static boolean canCockatriceSpawn(EntityType<? extends Mob> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return GenerationConstants.isFarEnoughFromSpawn(pos) && EntityCockatrice.checkMobSpawnRules(type, (LevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)pos, (RandomSource)random);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, ((Double)IafCommonConfig.INSTANCE.cockatrice.maxHealth.getValue()).doubleValue()).add(Attributes.MOVEMENT_SPEED, 0.4).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.FOLLOW_RANGE, 64.0).add(Attributes.ARMOR, 2.0);
    }

    @Override
    public void setConfigurableAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)IafCommonConfig.INSTANCE.cockatrice.maxHealth.getValue()).doubleValue());
    }

    public int getBaseExperienceReward() {
        return 10;
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new CockatriceAIFollowOwner(this, 1.0, 7.0f, 2.0f));
        this.goalSelector.addGoal(3, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 14.0f, 1.0, 1.0, (Predicate)((com.google.common.base.Predicate)entity -> {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return !player.isCreative() && !entity.isSpectator();
            }
            return entity.getType().is(IafEntityTags.SCARES_COCKATRICES) && !entity.getType().is(IafEntityTags.CHICKENS);
        })));
        this.goalSelector.addGoal(4, (Goal)new CockatriceAIWander(this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new CockatriceAIAggroLook(this));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, new CockatriceAITargetItems(this, false));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(5, new CockatriceAITarget<LivingEntity>(this, LivingEntity.class, true, entity -> {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return !player.isCreative() && !entity.isSpectator();
            }
            return entity instanceof Enemy && this.isTame() && !(entity instanceof Creeper) && !(entity instanceof ZombifiedPiglin) && !(entity instanceof EnderMan) || entity.getType().is(IafEntityTags.COCKATRICE_TARGETS) && !entity.getType().is(IafEntityTags.CHICKENS);
        }));
    }

    public boolean hasRestriction() {
        return this.hasHomePosition && this.getCommand() == 3 && this.getHomeDimensionName().equals(DragonUtils.getDimensionName(this.level())) || super.hasRestriction();
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    public BlockPos getRestrictCenter() {
        return this.hasHomePosition && this.getCommand() == 3 && this.homePos != null ? this.homePos.getPosition() : super.getRestrictCenter();
    }

    public float getRestrictRadius() {
        return 30.0f;
    }

    public String getHomeDimensionName() {
        return this.homePos == null ? "" : this.homePos.getDimension();
    }

    public boolean isAlliedTo(Entity entityIn) {
        if (entityIn.getType().is(IafEntityTags.CHICKENS)) {
            return true;
        }
        if (this.isTame()) {
            LivingEntity livingentity = this.getOwner();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                TamableAnimal tameable = (TamableAnimal)entityIn;
                return tameable.isOwnedBy(livingentity);
            }
            if (livingentity != null) {
                return livingentity.isAlliedTo(entityIn);
            }
        }
        return super.isAlliedTo(entityIn);
    }

    public boolean hurt(DamageSource source, float damage) {
        Entity entity;
        if (source.getEntity() != null && (entity = source.getEntity()).getType().is(IafEntityTags.SCARES_COCKATRICES)) {
            damage *= 5.0f;
        }
        if (source == this.level().damageSources().inWall()) {
            return false;
        }
        return super.hurt(source, damage);
    }

    private boolean canUseStareOn(Entity entity) {
        IBlacklistedFromStatues statues;
        return (!(entity instanceof IBlacklistedFromStatues) || (statues = (IBlacklistedFromStatues)entity).canBeTurnedToStone()) && !entity.getType().is(IafEntityTags.COCKATRICE_TARGETS);
    }

    private void switchAI(boolean melee) {
        if (melee) {
            this.goalSelector.removeGoal((Goal)this.aiStare);
            if (this.aiMelee != null) {
                this.goalSelector.addGoal(2, (Goal)this.aiMelee);
            }
            this.isMeleeMode = true;
        } else {
            this.goalSelector.removeGoal((Goal)this.aiMelee);
            if (this.aiStare != null) {
                this.goalSelector.addGoal(2, (Goal)this.aiStare);
            }
            this.isMeleeMode = false;
        }
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (this.isStaring()) {
            return false;
        }
        if (this.getRandom().nextBoolean()) {
            if (this.getAnimation() != ANIMATION_JUMPAT && this.getAnimation() != ANIMATION_BITE) {
                this.setAnimation(ANIMATION_JUMPAT);
            }
        } else if (this.getAnimation() != ANIMATION_BITE && this.getAnimation() != ANIMATION_JUMPAT) {
            this.setAnimation(ANIMATION_BITE);
        }
        return false;
    }

    public boolean canMove() {
        return !this.isOrderedToSit() && (this.getAnimation() != ANIMATION_JUMPAT || this.getAnimationTick() >= 7);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HEN, (Object)Boolean.FALSE);
        builder.define(STARING, (Object)Boolean.FALSE);
        builder.define(TARGET_ENTITY, (Object)0);
        builder.define(TAMING_PLAYER, (Object)0);
        builder.define(TAMING_LEVEL, (Object)0);
        builder.define(COMMAND, (Object)0);
    }

    public boolean hasTargetedEntity() {
        return (Integer)this.entityData.get(TARGET_ENTITY) != 0;
    }

    public boolean hasTamingPlayer() {
        return (Integer)this.entityData.get(TAMING_PLAYER) != 0;
    }

    public Entity getTamingPlayer() {
        if (!this.hasTamingPlayer()) {
            return null;
        }
        if (this.level().isClientSide) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.level().getEntity(((Integer)this.entityData.get(TAMING_PLAYER)).intValue());
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity;
                this.targetedEntity = livingEntity = (LivingEntity)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.level().getEntity(((Integer)this.entityData.get(TAMING_PLAYER)).intValue());
    }

    public void setTamingPlayer(int entityId) {
        this.entityData.set(TAMING_PLAYER, (Object)entityId);
    }

    public LivingEntity getTargetedEntity() {
        boolean blindness;
        boolean bl = blindness = this.hasEffect(MobEffects.BLINDNESS) || this.getTarget() != null && this.getTarget().hasEffect(MobEffects.BLINDNESS) || EntityGorgon.isBlindfolded(this.getTarget());
        if (blindness) {
            return null;
        }
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.level().isClientSide) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.level().getEntity(((Integer)this.entityData.get(TARGET_ENTITY)).intValue());
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity;
                this.targetedEntity = livingEntity = (LivingEntity)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.getTarget();
    }

    public void setTargetedEntity(int entityId) {
        this.entityData.set(TARGET_ENTITY, (Object)entityId);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (TARGET_ENTITY.equals(key)) {
            this.clientSideAttackTime = 0;
            this.targetedEntity = null;
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("Hen", this.isHen());
        tag.putBoolean("Staring", this.isStaring());
        tag.putInt("TamingLevel", this.getTamingLevel());
        tag.putInt("TamingPlayer", ((Integer)this.entityData.get(TAMING_PLAYER)).intValue());
        tag.putInt("Command", this.getCommand());
        tag.putBoolean("HasHomePosition", this.hasHomePosition);
        if (this.homePos != null && this.hasHomePosition) {
            this.homePos.write(tag);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setHen(tag.getBoolean("Hen"));
        this.setStaring(tag.getBoolean("Staring"));
        this.setTamingLevel(tag.getInt("TamingLevel"));
        this.setTamingPlayer(tag.getInt("TamingPlayer"));
        this.setCommand(tag.getInt("Command"));
        this.hasHomePosition = tag.getBoolean("HasHomePosition");
        if (this.hasHomePosition && tag.getInt("HomeAreaX") != 0 && tag.getInt("HomeAreaY") != 0 && tag.getInt("HomeAreaZ") != 0) {
            this.homePos = new HomePosition(tag, this.level());
        }
        this.setConfigurableAttributes();
    }

    public boolean isOrderedToSit() {
        if (this.level().isClientSide) {
            boolean isSitting;
            this.isSitting = isSitting = ((Byte)this.entityData.get(DATA_FLAGS_ID) & 1) != 0;
            return isSitting;
        }
        return this.isSitting;
    }

    public void setOrderedToSit(boolean sitting) {
        super.setSwimming(sitting);
        if (!this.level().isClientSide) {
            this.isSitting = sitting;
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn) {
        spawnDataIn = super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
        this.setHen(this.getRandom().nextBoolean());
        return spawnDataIn;
    }

    public boolean isHen() {
        return (Boolean)this.entityData.get(HEN);
    }

    public void setHen(boolean hen) {
        this.entityData.set(HEN, (Object)hen);
    }

    public int getTamingLevel() {
        return (Integer)this.entityData.get(TAMING_LEVEL);
    }

    public void setTamingLevel(int level) {
        this.entityData.set(TAMING_LEVEL, (Object)level);
    }

    public int getCommand() {
        return (Integer)this.entityData.get(COMMAND);
    }

    public void setCommand(int command) {
        this.entityData.set(COMMAND, (Object)command);
        this.setOrderedToSit(command == 1);
    }

    public boolean isStaring() {
        if (this.level().isClientSide) {
            this.isStaring = (Boolean)this.entityData.get(STARING);
            return this.isStaring;
        }
        return this.isStaring;
    }

    public void setStaring(boolean staring) {
        this.entityData.set(STARING, (Object)staring);
        if (!this.level().isClientSide) {
            this.isStaring = staring;
        }
    }

    public void forcePreyToLook(Mob mob) {
        mob.getLookControl().setLookAt(this.getX(), this.getY() + (double)this.getEyeHeight(), this.getZ(), (float)mob.getMaxHeadYRot(), (float)mob.getMaxHeadXRot());
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stackInHand = player.getItemInHand(hand);
        Item itemInHand = stackInHand.getItem();
        if (stackInHand.getItem() == Items.NAME_TAG || itemInHand == Items.LEAD || itemInHand == Items.POISONOUS_POTATO) {
            return super.mobInteract(player, hand);
        }
        if (this.isTame() && this.isOwnedBy((LivingEntity)player)) {
            if (stackInHand.is(IafItemTags.HEAL_COCKATRICE)) {
                if (this.getHealth() < this.getMaxHealth()) {
                    this.heal(8.0f);
                    this.playSound(SoundEvents.GENERIC_EAT, 1.0f, 1.0f);
                    stackInHand.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (stackInHand.isEmpty()) {
                if (player.isShiftKeyDown()) {
                    if (this.hasHomePosition) {
                        this.hasHomePosition = false;
                        player.displayClientMessage((Component)Component.translatable((String)"cockatrice.command.remove_home"), true);
                    } else {
                        BlockPos pos = this.blockPosition();
                        this.homePos = new HomePosition(pos, this.level());
                        this.hasHomePosition = true;
                        player.displayClientMessage((Component)Component.translatable((String)"cockatrice.command.new_home", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ(), this.homePos.getDimension()}), true);
                    }
                } else {
                    this.setCommand(this.getCommand() + 1);
                    if (this.getCommand() > 3) {
                        this.setCommand(0);
                    }
                    player.displayClientMessage((Component)Component.translatable((String)("cockatrice.command." + this.getCommand())), true);
                    this.playSound(SoundEvents.ZOMBIE_INFECT, 1.0f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    public void aiStep() {
        boolean blindness;
        boolean sitting;
        double dist;
        super.aiStep();
        LivingEntity attackTarget = this.getTarget();
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && attackTarget instanceof Player) {
            this.setTarget(null);
        }
        if (this.isOrderedToSit() && this.getCommand() != 1) {
            this.setOrderedToSit(false);
        }
        if (this.isOrderedToSit() && attackTarget != null) {
            this.setTarget(null);
        }
        if (attackTarget != null && this.isAlliedTo((Entity)attackTarget)) {
            this.setTarget(null);
        }
        if (!this.level().isClientSide) {
            if (attackTarget == null || !attackTarget.isAlive()) {
                this.setTargetedEntity(0);
            } else if (this.isStaring() || this.shouldStareAttack((Entity)attackTarget)) {
                this.setTargetedEntity(attackTarget.getId());
            }
        }
        if (this.getAnimation() == ANIMATION_BITE && attackTarget != null && this.getAnimationTick() == 7 && (dist = this.distanceToSqr((Entity)attackTarget)) < 8.0) {
            attackTarget.hurt(this.level().damageSources().mobAttack((LivingEntity)this), (float)((int)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue()));
        }
        if (this.getAnimation() == ANIMATION_JUMPAT && attackTarget != null) {
            dist = this.distanceToSqr((Entity)attackTarget);
            double d0 = attackTarget.getX() - this.getX();
            double d1 = attackTarget.getZ() - this.getZ();
            float leap = Mth.sqrt((float)((float)(d0 * d0 + d1 * d1)));
            if (dist < 4.0 && this.getAnimationTick() > 10) {
                attackTarget.hurt(this.level().damageSources().mobAttack((LivingEntity)this), (float)((int)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue()));
                if ((double)leap >= 1.0E-4) {
                    attackTarget.setDeltaMovement(attackTarget.getDeltaMovement().add(d0 / (double)leap * (double)0.8f + this.getDeltaMovement().x * (double)0.2f, 0.0, d1 / (double)leap * (double)0.8f + this.getDeltaMovement().z * (double)0.2f));
                }
            }
        }
        if ((sitting = this.isOrderedToSit()) && this.sitProgress < 20.0f) {
            this.sitProgress += 0.5f;
        } else if (!sitting && this.sitProgress > 0.0f) {
            this.sitProgress -= 0.5f;
        }
        boolean staring = this.isStaring();
        if (staring && this.stareProgress < 20.0f) {
            this.stareProgress += 0.5f;
        } else if (!staring && this.stareProgress > 0.0f) {
            this.stareProgress -= 0.5f;
        }
        if (!this.level().isClientSide) {
            this.ticksStaring = staring ? ++this.ticksStaring : 0;
        }
        if (!this.level().isClientSide && staring && (attackTarget == null || this.shouldMelee())) {
            this.setStaring(false);
        }
        if (attackTarget != null) {
            this.getLookControl().setLookAt(attackTarget.getX(), attackTarget.getY() + (double)attackTarget.getEyeHeight(), attackTarget.getZ(), (float)this.getMaxHeadYRot(), (float)this.getMaxHeadXRot());
            if (!this.shouldMelee() && attackTarget instanceof Mob) {
                Mob mob = (Mob)attackTarget;
                this.forcePreyToLook(mob);
            }
        }
        boolean bl = blindness = this.hasEffect(MobEffects.BLINDNESS) || attackTarget != null && attackTarget.hasEffect(MobEffects.BLINDNESS);
        if (blindness) {
            this.setStaring(false);
        }
        if (!this.level().isClientSide && !blindness && attackTarget != null && EntityGorgon.isEntityLookingAt((LivingEntity)this, attackTarget, 0.6f) && EntityGorgon.isEntityLookingAt(attackTarget, (LivingEntity)this, 0.6f) && !EntityGorgon.isBlindfolded(attackTarget) && !this.shouldMelee()) {
            if (!this.isStaring()) {
                this.setStaring(true);
            } else {
                int attackStrength = this.getFriendsCount(attackTarget);
                if (this.level().getDifficulty() == Difficulty.HARD) {
                    ++attackStrength;
                }
                attackTarget.addEffect(new MobEffectInstance(MobEffects.WITHER, 10, 2 + Math.min(1, attackStrength)));
                attackTarget.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 10, Math.min(4, attackStrength)));
                attackTarget.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 0));
                if (attackStrength >= 2 && attackTarget.tickCount % 40 == 0) {
                    attackTarget.hurt(this.level().damageSources().wither(), (float)(attackStrength - 1));
                }
                attackTarget.setLastHurtByMob((LivingEntity)this);
                if (!this.isTame() && attackTarget instanceof Player) {
                    this.setTamingPlayer(attackTarget.getId());
                    this.setTamingLevel(this.getTamingLevel() + 1);
                    if (this.getTamingLevel() % 100 == 0) {
                        this.level().broadcastEntityEvent((Entity)this, (byte)46);
                    }
                    if (this.getTamingLevel() >= 1000) {
                        this.level().broadcastEntityEvent((Entity)this, (byte)45);
                        Entity entity = this.getTamingPlayer();
                        if (entity instanceof Player) {
                            Player player = (Player)entity;
                            this.tame(player);
                        }
                        this.setTarget(null);
                        this.setTamingPlayer(0);
                        this.setTargetedEntity(0);
                    }
                }
            }
        }
        if (!this.level().isClientSide && attackTarget == null && this.getRandom().nextInt(300) == 0 && this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_WATTLESHAKE);
        }
        if (!this.level().isClientSide) {
            if (this.shouldMelee() && !this.isMeleeMode) {
                this.switchAI(true);
            }
            if (!this.shouldMelee() && this.isMeleeMode) {
                this.switchAI(false);
            }
        }
        if (this.level().isClientSide && this.getTargetedEntity() != null && EntityGorgon.isEntityLookingAt((LivingEntity)this, this.getTargetedEntity(), 0.6f) && EntityGorgon.isEntityLookingAt(this.getTargetedEntity(), (LivingEntity)this, 0.6f) && this.isStaring() && this.hasTargetedEntity()) {
            LivingEntity livingEntity;
            if (this.clientSideAttackTime < this.getAttackDuration()) {
                ++this.clientSideAttackTime;
            }
            if ((livingEntity = this.getTargetedEntity()) != null) {
                this.getLookControl().setLookAt((Entity)livingEntity, 90.0f, 90.0f);
                this.getLookControl().tick();
                double d5 = this.getAttackAnimationScale(0.0f);
                double d0 = livingEntity.getX() - this.getX();
                double d1 = livingEntity.getY() + (double)(livingEntity.getBbHeight() * 0.5f) - (this.getY() + (double)this.getEyeHeight());
                double d2 = livingEntity.getZ() - this.getZ();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d0 /= d3;
                d1 /= d3;
                d2 /= d3;
                double d4 = this.random.nextDouble();
                while (d4 < d3) {
                    this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)-16777216), this.getX() + d0 * (d4 += 1.8 - d5 + this.random.nextDouble() * (1.7 - d5)), this.getY() + d1 * d4 + (double)this.getEyeHeight(), this.getZ() + d2 * d4, 0.0, 0.0, 0.0);
                }
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    private int getFriendsCount(LivingEntity attackTarget) {
        if (this.getTarget() == null) {
            return 0;
        }
        float dist = ((Integer)IafCommonConfig.INSTANCE.cockatrice.chickenSearchLength.getValue()).intValue();
        List list = this.level().getEntitiesOfClass(EntityCockatrice.class, this.getBoundingBox().expandTowards((double)dist, (double)dist, (double)dist));
        int i = 0;
        for (EntityCockatrice cockatrice : list) {
            boolean bothLooking;
            if (cockatrice.is((Entity)this) || cockatrice.getTarget() == null || cockatrice.getTarget() != this.getTarget() || !(bothLooking = EntityGorgon.isEntityLookingAt((LivingEntity)cockatrice, cockatrice.getTarget(), 0.6f) && EntityGorgon.isEntityLookingAt(cockatrice.getTarget(), (LivingEntity)cockatrice, 0.6f))) continue;
            ++i;
        }
        return i;
    }

    public float getAttackAnimationScale(float f) {
        return ((float)this.clientSideAttackTime + f) / (float)this.getAttackDuration();
    }

    public boolean shouldStareAttack(Entity entity) {
        return this.distanceTo(entity) > 5.0f;
    }

    public int getAttackDuration() {
        return 80;
    }

    private boolean shouldMelee() {
        boolean blindness;
        boolean bl = blindness = this.hasEffect(MobEffects.BLINDNESS) || this.getTarget() != null && this.getTarget().hasEffect(MobEffects.BLINDNESS);
        if (this.getTarget() != null) {
            if ((double)this.distanceTo((Entity)this.getTarget()) < 4.0) {
                return true;
            }
            LivingEntity entity = this.getTarget();
            return entity.getType().is(IafEntityTags.COCKATRICE_TARGETS) || blindness || !this.canUseStareOn((Entity)this.getTarget());
        }
        return false;
    }

    public void travel(Vec3 motionVec) {
        if (!this.canMove() && !this.isVehicle()) {
            motionVec = motionVec.multiply(0.0, 1.0, 0.0);
        }
        super.travel(motionVec);
    }

    public void playAmbientSound() {
        if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.playAmbientSound();
    }

    protected void playHurtSound(DamageSource source) {
        if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.playHurtSound(source);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        return null;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_JUMPAT, ANIMATION_WATTLESHAKE, ANIMATION_BITE, ANIMATION_SPEAK, ANIMATION_EAT};
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 Vector3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        return this.level().clip(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() == HitResult.Type.MISS;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)IafSounds.COCKATRICE_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)IafSounds.COCKATRICE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)IafSounds.COCKATRICE_DIE.get();
    }

    public void handleEntityEvent(byte id) {
        if (id == 45) {
            this.playEffect(true);
        } else if (id == 46) {
            this.playEffect(false);
        } else {
            super.handleEntityEvent(id);
        }
    }

    protected void playEffect(boolean play) {
        SimpleParticleType enumparticletypes = ParticleTypes.HEART;
        if (!play) {
            enumparticletypes = ParticleTypes.DAMAGE_INDICATOR;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle((ParticleOptions)enumparticletypes, this.getX() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), this.getY() + 0.5 + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), d0, d1, d2);
        }
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }
}

