/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.entity.ai.PixieAIEnterHouse;
import com.iafenvoy.iceandfire.entity.ai.PixieAIFlee;
import com.iafenvoy.iceandfire.entity.ai.PixieAIFollowOwner;
import com.iafenvoy.iceandfire.entity.ai.PixieAIMoveRandom;
import com.iafenvoy.iceandfire.entity.ai.PixieAIPickupItem;
import com.iafenvoy.iceandfire.entity.ai.PixieAISteal;
import com.iafenvoy.iceandfire.entity.block.BlockEntityPixieHouse;
import com.iafenvoy.iceandfire.network.payload.UpdatePixieHousePayload;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafParticles;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.registry.tag.IafItemTags;
import com.iafenvoy.uranus.ServerHelper;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class EntityPixie
extends TamableAnimal {
    public static final float[][] PARTICLE_RGB = new float[][]{{1.0f, 0.752f, 0.792f}, {0.831f, 0.662f, 1.0f}, {0.513f, 0.843f, 1.0f}, {0.654f, 0.909f, 0.615f}, {0.996f, 0.788f, 0.407f}};
    public static final int STEAL_COOLDOWN = 3000;
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(EntityPixie.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.defineId(EntityPixie.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final Holder<MobEffect>[] positivePotions = new Holder[]{MobEffects.DAMAGE_BOOST, MobEffects.JUMP, MobEffects.MOVEMENT_SPEED, MobEffects.LUCK, MobEffects.DIG_SPEED};
    public final Holder<MobEffect>[] negativePotions = new Holder[]{MobEffects.WEAKNESS, MobEffects.CONFUSION, MobEffects.MOVEMENT_SLOWDOWN, MobEffects.UNLUCK, MobEffects.DIG_SLOWDOWN};
    public boolean slowSpeed = false;
    public int ticksUntilHouseAI;
    public int ticksHeldItemFor;
    public int stealCooldown = 0;
    private BlockPos housePos;
    private boolean isSitting;

    public EntityPixie(EntityType<? extends EntityPixie> type, Level worldIn) {
        super(type, worldIn);
        this.moveControl = new AIMoveControl(this);
        this.xpReward = 3;
        this.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
    }

    public static BlockPos getPositionRelativetoGround(Entity entity, Level world, double x, double z, RandomSource rand) {
        BlockPos pos = BlockPos.containing((double)x, (double)entity.getBlockY(), (double)z);
        for (int yDown = 0; yDown < 3; ++yDown) {
            if (world.isEmptyBlock(pos.below(yDown))) continue;
            return pos.above(yDown);
        }
        return pos;
    }

    public static BlockPos findAHouse(Entity entity, Level world) {
        for (int xSearch = -10; xSearch < 10; ++xSearch) {
            for (int ySearch = -10; ySearch < 10; ++ySearch) {
                for (int zSearch = -10; zSearch < 10; ++zSearch) {
                    BlockEntity blockEntity;
                    if (world.getBlockEntity(entity.blockPosition().offset(xSearch, ySearch, zSearch)) == null || !((blockEntity = world.getBlockEntity(entity.blockPosition().offset(xSearch, ySearch, zSearch))) instanceof BlockEntityPixieHouse)) continue;
                    BlockEntityPixieHouse house = (BlockEntityPixieHouse)blockEntity;
                    if (house.hasPixie) continue;
                    return entity.blockPosition().offset(xSearch, ySearch, zSearch);
                }
            }
        }
        return entity.blockPosition();
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public boolean isPixieSitting() {
        if (this.level().isClientSide) {
            boolean isSitting;
            this.isSitting = isSitting = ((Byte)this.entityData.get(DATA_FLAGS_ID) & 1) != 0;
            this.setOrderedToSit(isSitting);
            return isSitting;
        }
        return this.isSitting;
    }

    public void setPixieSitting(boolean sitting) {
        if (!this.level().isClientSide) {
            this.isSitting = sitting;
            this.setInSittingPose(sitting);
        }
        byte b0 = (Byte)this.entityData.get(DATA_FLAGS_ID);
        if (sitting) {
            this.entityData.set(DATA_FLAGS_ID, (Object)((byte)(b0 | 1)));
        } else {
            this.entityData.set(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public boolean isOrderedToSit() {
        return this.isPixieSitting();
    }

    public int getBaseExperienceReward() {
        return 3;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(Items.SUGAR);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (!this.level().isClientSide && this.getRandom().nextInt(3) == 0 && !this.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
            this.spawnAtLocation(this.getItemInHand(InteractionHand.MAIN_HAND), 0.0f);
            this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            this.stealCooldown = 3000;
            return true;
        }
        if (this.isOwnerClose() && (source.getEntity() != null && source == this.level().damageSources().fallingBlock(source.getEntity()) || source == this.level().damageSources().inWall() || this.getOwner() != null && source.getEntity() == this.getOwner())) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        LivingEntity owner;
        boolean invulnerable = super.isInvulnerableTo(source);
        if (!invulnerable && (owner = this.getOwner()) != null && source.getEntity() == owner) {
            return true;
        }
        return invulnerable;
    }

    public void die(DamageSource cause) {
        if (!this.level().isClientSide && !this.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
            this.spawnAtLocation(this.getItemInHand(InteractionHand.MAIN_HAND), 0.0f);
            this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        }
        super.die(cause);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COLOR, (Object)0);
        builder.define(COMMAND, (Object)0);
    }

    protected void doPush(Entity entityIn) {
        if (this.getOwner() != entityIn) {
            entityIn.push((Entity)this);
        }
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.isOwnedBy((LivingEntity)player)) {
            if (player.getItemInHand(hand).is(IafItemTags.HEAL_PIXIE) && this.getHealth() < this.getMaxHealth()) {
                this.heal(5.0f);
                player.getItemInHand(hand).shrink(1);
                this.playSound((SoundEvent)IafSounds.PIXIE_TAUNT.get(), 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            this.setCommand(this.getCommand() + 1);
            if (this.getCommand() > 1) {
                this.setCommand(0);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.getItemInHand(hand).getItem() == ((Block)IafBlocks.JAR_EMPTY.get()).asItem() && !this.isTame()) {
            if (!player.isCreative()) {
                player.getItemInHand(hand).shrink(1);
            }
            Block jar = switch (this.getColor()) {
                case 0 -> (Block)IafBlocks.JAR_PIXIE_0.get();
                case 1 -> (Block)IafBlocks.JAR_PIXIE_1.get();
                case 2 -> (Block)IafBlocks.JAR_PIXIE_2.get();
                case 3 -> (Block)IafBlocks.JAR_PIXIE_3.get();
                case 4 -> (Block)IafBlocks.JAR_PIXIE_4.get();
                default -> Blocks.AIR;
            };
            ItemStack stack = new ItemStack((ItemLike)jar, 1);
            if (!this.level().isClientSide) {
                if (!this.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                    this.spawnAtLocation(this.getItemInHand(InteractionHand.MAIN_HAND), 0.0f);
                    this.stealCooldown = 3000;
                }
                this.spawnAtLocation(stack, 0.0f);
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        return super.mobInteract(player, hand);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PixieAIFollowOwner(this, 1.0, 2.0f, 4.0f));
        this.goalSelector.addGoal(2, new PixieAIPickupItem(this, false));
        this.goalSelector.addGoal(2, new PixieAIFlee<Player>(this, Player.class, 10.0f, (Predicate<Player>)((com.google.common.base.Predicate)entity -> true)));
        this.goalSelector.addGoal(2, (Goal)new PixieAISteal(this));
        this.goalSelector.addGoal(3, (Goal)new PixieAIMoveRandom(this));
        this.goalSelector.addGoal(4, (Goal)new PixieAIEnterHouse(this));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn) {
        spawnDataIn = super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
        this.setColor(this.random.nextInt(5));
        this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        return spawnDataIn;
    }

    private boolean isBeyondHeight() {
        if (this.getY() > (double)this.level().getMaxBuildHeight()) {
            return true;
        }
        BlockPos height = this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.blockPosition());
        int maxY = 20 + height.getY();
        return this.getY() > (double)maxY;
    }

    public int getCommand() {
        return (Integer)this.entityData.get(COMMAND);
    }

    public void setCommand(int command) {
        this.entityData.set(COMMAND, (Object)command);
        this.setPixieSitting(command == 1);
    }

    public void aiStep() {
        BlockEntity blockEntity;
        super.aiStep();
        if (!this.level().isClientSide) {
            if (this.isPixieSitting() && this.getCommand() != 1) {
                this.setPixieSitting(false);
            }
            if (!this.isPixieSitting() && this.getCommand() == 1) {
                this.setPixieSitting(true);
            }
            if (this.isPixieSitting()) {
                this.getNavigation().stop();
            }
        }
        if (this.stealCooldown > 0) {
            --this.stealCooldown;
        }
        this.ticksHeldItemFor = !this.getMainHandItem().isEmpty() && !this.isTame() ? ++this.ticksHeldItemFor : 0;
        if (!this.isPixieSitting() && !this.isBeyondHeight()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.08, 0.0));
        }
        if (this.level().isClientSide) {
            this.level().addParticle((ParticleOptions)IafParticles.PIXIE_DUST.get(), this.getX() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), (double)PARTICLE_RGB[this.getColor()][0], (double)PARTICLE_RGB[this.getColor()][1], (double)PARTICLE_RGB[this.getColor()][2]);
        }
        if (this.ticksUntilHouseAI > 0) {
            --this.ticksUntilHouseAI;
        }
        if (!this.level().isClientSide && this.housePos != null && this.distanceToSqr(Vec3.atCenterOf((Vec3i)this.housePos)) < 1.5 && this.level().getBlockEntity(this.housePos) != null && (blockEntity = this.level().getBlockEntity(this.housePos)) instanceof BlockEntityPixieHouse) {
            BlockEntityPixieHouse house = (BlockEntityPixieHouse)blockEntity;
            if (house.hasPixie) {
                this.housePos = null;
            } else {
                house.hasPixie = true;
                house.pixieType = this.getColor();
                house.pixieItems.set(0, (Object)this.getItemInHand(InteractionHand.MAIN_HAND));
                house.tamedPixie = this.isTame();
                house.pixieOwnerUUID = this.getOwnerUUID();
                ServerHelper.sendToAll((CustomPacketPayload)new UpdatePixieHousePayload(this.housePos, true, this.getColor()));
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
        if (this.getOwner() != null && this.isOwnerClose() && this.tickCount % 80 == 0) {
            this.getOwner().addEffect(new MobEffectInstance(this.positivePotions[this.getColor()], 100, 0, false, false));
        }
    }

    public int getColor() {
        return Mth.clamp((int)((Integer)this.getEntityData().get(COLOR)), (int)0, (int)4);
    }

    public void setColor(int color) {
        this.getEntityData().set(COLOR, (Object)color);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.setColor(compound.getInt("Color"));
        this.stealCooldown = compound.getInt("StealCooldown");
        this.ticksHeldItemFor = compound.getInt("HoldingTicks");
        this.setPixieSitting(compound.getBoolean("PixieSitting"));
        this.setCommand(compound.getInt("Command"));
        super.readAdditionalSaveData(compound);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("Color", this.getColor());
        compound.putInt("Command", this.getCommand());
        compound.putInt("StealCooldown", this.stealCooldown);
        compound.putInt("HoldingTicks", this.ticksHeldItemFor);
        compound.putBoolean("PixieSitting", this.isPixieSitting());
        super.addAdditionalSaveData(compound);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        return null;
    }

    public void setHousePosition(BlockPos blockPos) {
        this.housePos = blockPos;
    }

    public BlockPos getHousePos() {
        return this.housePos;
    }

    public boolean isOwnerClose() {
        return this.isTame() && this.getOwner() != null && this.distanceToSqr((Entity)this.getOwner()) < 100.0;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)IafSounds.PIXIE_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)IafSounds.PIXIE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)IafSounds.PIXIE_DIE.get();
    }

    public boolean isAlliedTo(Entity entityIn) {
        if (this.isTame()) {
            LivingEntity livingentity = this.getOwner();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                TamableAnimal tameable = (TamableAnimal)entityIn;
                return tameable.isOwnedBy(livingentity);
            }
            if (livingentity != null) {
                return livingentity.isAlliedTo(entityIn);
            }
        }
        return super.isAlliedTo(entityIn);
    }

    class AIMoveControl
    extends MoveControl {
        public AIMoveControl(EntityPixie pixie) {
            super((Mob)pixie);
        }

        public void tick() {
            float speedMod = 1.0f;
            if (EntityPixie.this.slowSpeed) {
                speedMod = 2.0f;
            }
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                if (EntityPixie.this.horizontalCollision) {
                    EntityPixie.this.setYRot(this.mob.getYRot() + 180.0f);
                    speedMod = 0.1f;
                    BlockPos target = EntityPixie.getPositionRelativetoGround((Entity)EntityPixie.this, EntityPixie.this.level(), EntityPixie.this.getX() + (double)EntityPixie.this.random.nextInt(15) - 7.0, EntityPixie.this.getZ() + (double)EntityPixie.this.random.nextInt(15) - 7.0, EntityPixie.this.random);
                    this.wantedX = target.getX();
                    this.wantedY = target.getY();
                    this.wantedZ = target.getZ();
                }
                double d0 = this.wantedX - EntityPixie.this.getX();
                double d1 = this.wantedY - EntityPixie.this.getY();
                double d2 = this.wantedZ - EntityPixie.this.getZ();
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = Math.sqrt(d3)) < EntityPixie.this.getBoundingBox().getSize()) {
                    this.operation = MoveControl.Operation.WAIT;
                    EntityPixie.this.setDeltaMovement(EntityPixie.this.getDeltaMovement().multiply(0.5, 0.5, 0.5));
                } else {
                    EntityPixie.this.setDeltaMovement(EntityPixie.this.getDeltaMovement().add(d0 / d3 * 0.05 * this.speedModifier * (double)speedMod, d1 / d3 * 0.05 * this.speedModifier * (double)speedMod, d2 / d3 * 0.05 * this.speedModifier * (double)speedMod));
                    if (EntityPixie.this.getTarget() == null) {
                        EntityPixie.this.setYRot(-((float)Mth.atan2((double)EntityPixie.this.getDeltaMovement().x, (double)EntityPixie.this.getDeltaMovement().z)) * 57.295776f);
                        EntityPixie.this.yBodyRot = EntityPixie.this.getYRot();
                    } else {
                        double d4 = EntityPixie.this.getTarget().getX() - EntityPixie.this.getX();
                        double d5 = EntityPixie.this.getTarget().getZ() - EntityPixie.this.getZ();
                        EntityPixie.this.setYRot(-((float)Mth.atan2((double)d4, (double)d5)) * 57.295776f);
                        EntityPixie.this.yBodyRot = EntityPixie.this.getYRot();
                    }
                }
            }
        }
    }
}

