/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityStymphalianFeather;
import com.iafenvoy.iceandfire.entity.ai.StymphalianBirdAIAirTarget;
import com.iafenvoy.iceandfire.entity.ai.StymphalianBirdAIFlee;
import com.iafenvoy.iceandfire.entity.ai.StymphalianBirdAITarget;
import com.iafenvoy.iceandfire.entity.util.IAnimalFear;
import com.iafenvoy.iceandfire.entity.util.IVillagerFear;
import com.iafenvoy.iceandfire.entity.util.StymphalianBirdFlock;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityStymphalianBird
extends Monster
implements IAnimatedEntity,
Enemy,
IVillagerFear,
IAnimalFear {
    public static final Predicate<Entity> STYMPHALIAN_PREDICATE = entity -> entity instanceof EntityStymphalianBird;
    public static final Animation ANIMATION_PECK = Animation.create((int)20);
    public static final Animation ANIMATION_SHOOT_ARROWS = Animation.create((int)30);
    public static final Animation ANIMATION_SPEAK = Animation.create((int)10);
    private static final int FLIGHT_CHANCE_PER_TICK = 100;
    private static final EntityDataAccessor<Optional<UUID>> VICTOR_ENTITY = SynchedEntityData.defineId(EntityStymphalianBird.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.defineId(EntityStymphalianBird.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float flyProgress;
    public BlockPos airTarget;
    public StymphalianBirdFlock flock;
    private int animationTick;
    private Animation currentAnimation;
    private boolean isFlying;
    private int flyTicks;
    private int launchTicks;
    private boolean aiFlightLaunch = false;
    private int airBorneCounter;

    public EntityStymphalianBird(EntityType<? extends Monster> t, Level worldIn) {
        super(t, worldIn);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 24.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.FOLLOW_RANGE, (double)Math.min(2048, (Integer)IafCommonConfig.INSTANCE.stymphalianBird.targetSearchLength.getValue())).add(Attributes.ARMOR, 4.0);
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new StymphalianBirdAIFlee(this, 10.0f));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, false));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new StymphalianBirdAIAirTarget(this));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new StymphalianBirdAITarget(this, LivingEntity.class, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VICTOR_ENTITY, Optional.empty());
        builder.define(FLYING, (Object)Boolean.FALSE);
    }

    public int getBaseExperienceReward() {
        return 10;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.level().getDifficulty() == Difficulty.PEACEFUL) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.getVictorId() != null) {
            tag.putUUID("VictorUUID", this.getVictorId());
        }
        tag.putBoolean("Flying", this.isFlying());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        UUID s;
        super.readAdditionalSaveData(tag);
        if (tag.hasUUID("VictorUUID")) {
            s = tag.getUUID("VictorUUID");
        } else {
            String s1 = tag.getString("VictorUUID");
            s = OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.getServer(), (String)s1);
        }
        if (s != null) {
            try {
                this.setVictorId(s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.setFlying(tag.getBoolean("Flying"));
    }

    public boolean isFlying() {
        if (this.level().isClientSide) {
            this.isFlying = (Boolean)this.entityData.get(FLYING);
            return this.isFlying;
        }
        return this.isFlying;
    }

    public void setFlying(boolean flying) {
        this.entityData.set(FLYING, (Object)flying);
        if (!this.level().isClientSide) {
            this.isFlying = flying;
        }
    }

    public void die(DamageSource cause) {
        if (cause.getEntity() != null && cause.getEntity() instanceof LivingEntity && !this.level().isClientSide) {
            this.setVictorId(cause.getEntity().getUUID());
            if (this.flock != null) {
                this.flock.setFearTarget((LivingEntity)cause.getEntity());
            }
        }
        super.die(cause);
    }

    public UUID getVictorId() {
        return ((Optional)this.entityData.get(VICTOR_ENTITY)).orElse(null);
    }

    public void setVictorId(UUID uuid) {
        this.entityData.set(VICTOR_ENTITY, Optional.ofNullable(uuid));
    }

    public LivingEntity getVictor() {
        try {
            UUID uuid = this.getVictorId();
            return uuid == null ? null : this.level().getPlayerByUUID(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public void setVictor(LivingEntity player) {
        this.setVictorId(player.getUUID());
    }

    public boolean isVictor(LivingEntity entityIn) {
        return entityIn == this.getVictor();
    }

    public boolean isTargetBlocked(Vec3 target) {
        return this.level().clip(new ClipContext(target, this.getEyePosition(1.0f), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() == HitResult.Type.MISS;
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_PECK);
        }
        return true;
    }

    public void aiStep() {
        boolean flying;
        super.aiStep();
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.getTarget() instanceof Player) {
            this.setTarget(null);
        }
        if (this.getTarget() != null && (this.getTarget() instanceof Player && ((Player)this.getTarget()).isCreative() || this.getVictor() != null && this.isVictor(this.getTarget()))) {
            this.setTarget(null);
        }
        if (this.flock == null) {
            StymphalianBirdFlock otherFlock = StymphalianBirdFlock.getNearbyFlock(this);
            if (otherFlock == null) {
                this.flock = StymphalianBirdFlock.createFlock(this);
            } else {
                this.flock = otherFlock;
                this.flock.addToFlock(this);
            }
        } else {
            if (!this.flock.isLeader(this)) {
                double dist = this.distanceToSqr((Entity)this.flock.getLeader());
                if (dist > 360.0) {
                    this.setFlying(true);
                    this.navigation.stop();
                    this.airTarget = StymphalianBirdAIAirTarget.getNearbyAirTarget(this.flock.getLeader());
                    this.aiFlightLaunch = false;
                } else if (!this.flock.getLeader().isFlying()) {
                    this.setFlying(false);
                    this.airTarget = null;
                    this.aiFlightLaunch = false;
                }
                if (this.onGround() && dist < 40.0 && this.getAnimation() != ANIMATION_SHOOT_ARROWS) {
                    this.setFlying(false);
                }
            }
            this.flock.update();
        }
        if (!this.level().isClientSide && this.getTarget() != null && this.getTarget().isAlive()) {
            double dist = this.distanceToSqr((Entity)this.getTarget());
            if (this.getAnimation() == ANIMATION_PECK && this.getAnimationTick() == 7) {
                if (dist < 1.5) {
                    this.getTarget().hurt(this.level().damageSources().mobAttack((LivingEntity)this), (float)((int)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue()));
                }
                if (this.onGround()) {
                    this.setFlying(false);
                }
            }
            if (this.getAnimation() != ANIMATION_PECK && this.getAnimation() != ANIMATION_SHOOT_ARROWS && dist > 3.0 && dist < 225.0) {
                this.setAnimation(ANIMATION_SHOOT_ARROWS);
            }
            if (this.getAnimation() == ANIMATION_SHOOT_ARROWS) {
                LivingEntity target = this.getTarget();
                this.lookAt((Entity)target, 360.0f, 360.0f);
                if (this.isFlying()) {
                    this.setYRot(this.yBodyRot);
                    if ((this.getAnimationTick() == 7 || this.getAnimationTick() == 14) && this.isDirectPathBetweenPoints((Entity)this, this.position(), target.position())) {
                        this.playSound((SoundEvent)IafSounds.STYMPHALIAN_BIRD_ATTACK.get(), 1.0f, 1.0f);
                        for (int i = 0; i < 4; ++i) {
                            float wingX = (float)(this.getX() + (double)(0.9f * Mth.cos((float)((float)((double)(this.getYRot() + (float)(180 * (i % 2))) * Math.PI / 180.0)))));
                            float wingZ = (float)(this.getZ() + (double)(0.9f * Mth.sin((float)((float)((double)(this.getYRot() + (float)(180 * (i % 2))) * Math.PI / 180.0)))));
                            float wingY = (float)(this.getY() + 1.0);
                            double d0 = target.getX() - (double)wingX;
                            double d1 = target.getBoundingBox().minY - (double)wingY;
                            double d2 = target.getZ() - (double)wingZ;
                            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                            EntityStymphalianFeather entityarrow = new EntityStymphalianFeather((EntityType<? extends AbstractArrow>)((EntityType)IafEntities.STYMPHALIAN_FEATHER.get()), this.level(), (LivingEntity)this);
                            entityarrow.setPos(wingX, wingY, wingZ);
                            entityarrow.shoot(d0, d1 + d3 * 0.10000000298023223, d2, 1.6f, 14 - this.level().getDifficulty().getId() * 4);
                            this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
                            this.level().addFreshEntity((Entity)entityarrow);
                        }
                    }
                } else {
                    this.setFlying(true);
                }
            }
        }
        boolean bl = flying = this.isFlying() && !this.onGround() || this.airBorneCounter > 10 || this.getAnimation() == ANIMATION_SHOOT_ARROWS;
        if (flying && this.flyProgress < 20.0f) {
            this.flyProgress += 1.0f;
        } else if (!flying && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (!this.isFlying() && this.airTarget != null && this.onGround() && !this.level().isClientSide) {
            this.airTarget = null;
        }
        if (this.isFlying() && this.getTarget() == null) {
            this.flyAround();
        } else if (this.getTarget() != null) {
            this.flyTowardsTarget();
        }
        if (!this.level().isClientSide && this.doesWantToLand() && !this.aiFlightLaunch && this.getAnimation() != ANIMATION_SHOOT_ARROWS) {
            this.setFlying(false);
            this.airTarget = null;
        }
        if (!this.level().isClientSide && this.isFree(0.0, 0.0, 0.0) && !this.isFlying()) {
            this.setFlying(true);
            this.launchTicks = 0;
            this.flyTicks = 0;
            this.aiFlightLaunch = true;
        }
        if (!this.level().isClientSide && this.onGround() && this.isFlying() && !this.aiFlightLaunch && this.getAnimation() != ANIMATION_SHOOT_ARROWS) {
            this.setFlying(false);
            this.airTarget = null;
        }
        if (!this.level().isClientSide && (this.flock == null || this.flock.isLeader(this)) && this.getRandom().nextInt(100) == 0 && !this.isFlying() && this.getPassengers().isEmpty() && !this.isBaby() && this.onGround()) {
            this.setFlying(true);
            this.launchTicks = 0;
            this.flyTicks = 0;
            this.aiFlightLaunch = true;
        }
        if (!this.level().isClientSide) {
            if (this.aiFlightLaunch && this.launchTicks < 40) {
                ++this.launchTicks;
            } else {
                this.launchTicks = 0;
                this.aiFlightLaunch = false;
            }
            this.flyTicks = this.isFlying() ? ++this.flyTicks : 0;
        }
        this.airBorneCounter = !this.onGround() ? ++this.airBorneCounter : 0;
        if (this.getAnimation() == ANIMATION_SHOOT_ARROWS && !this.isFlying() && !this.level().isClientSide) {
            this.setFlying(true);
            this.aiFlightLaunch = true;
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public boolean isDirectPathBetweenPoints(Entity entity, Vec3 vec1, Vec3 vec2) {
        return this.level().clip(new ClipContext(vec1, vec2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() == HitResult.Type.MISS;
    }

    public void flyAround() {
        if (this.airTarget != null && this.isFlying()) {
            if (!this.isTargetInAir() || this.flyTicks > 6000 || !this.isFlying()) {
                this.airTarget = null;
            }
            this.flyTowardsTarget();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void flyTowardsTarget() {
        if (this.airTarget == null || !this.isTargetInAir() || !this.isFlying()) ** GOTO lbl-1000
        v0 = new Vec3((double)this.airTarget.getX(), this.getY(), (double)this.airTarget.getZ());
        if (this.getDistanceSquared(v0) > 3.0f) {
            targetX = (double)this.airTarget.getX() + 0.5 - this.getX();
            targetY = (double)Math.min(this.airTarget.getY(), 256) + 1.0 - this.getY();
            targetZ = (double)this.airTarget.getZ() + 0.5 - this.getZ();
            motionX = (Math.signum(targetX) * 0.5 - this.getDeltaMovement().x) * 0.100000000372529 * (double)this.getFlySpeed(false);
            motionY = (Math.signum(targetY) * 0.5 - this.getDeltaMovement().y) * 0.100000000372529 * (double)this.getFlySpeed(true);
            motionZ = (Math.signum(targetZ) * 0.5 - this.getDeltaMovement().z) * 0.100000000372529 * (double)this.getFlySpeed(false);
            this.setDeltaMovement(this.getDeltaMovement().add(motionX, motionY, motionZ));
            angle = (float)(Math.atan2(this.getDeltaMovement().z, this.getDeltaMovement().x) * 180.0 / 3.141592653589793) - 90.0f;
            rotation = Mth.wrapDegrees((float)(angle - this.getYRot()));
            this.zza = 0.5f;
            this.yRotO = this.getYRot();
            this.setYRot(this.getYRot() + rotation);
            if (!this.isFlying()) {
                this.setFlying(true);
            }
        } else lbl-1000:
        // 2 sources

        {
            this.airTarget = null;
        }
        if (this.airTarget != null && this.isTargetInAir() && this.isFlying()) {
            v1 = new Vec3((double)this.airTarget.getX(), this.getY(), (double)this.airTarget.getZ());
            if (this.getDistanceSquared(v1) < 3.0f && this.doesWantToLand()) {
                this.setFlying(false);
            }
        }
    }

    private float getFlySpeed(boolean y) {
        float speed = 2.0f;
        if (this.flock != null && !this.flock.isLeader(this) && this.distanceToSqr((Entity)this.flock.getLeader()) > 10.0) {
            speed = 4.0f;
        }
        if (this.getAnimation() == ANIMATION_SHOOT_ARROWS && !y) {
            speed *= 0.05f;
        }
        return speed;
    }

    public void playAmbientSound() {
        if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.playAmbientSound();
    }

    protected void playHurtSound(DamageSource source) {
        if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.playHurtSound(source);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)IafSounds.STYMPHALIAN_BIRD_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)IafSounds.STYMPHALIAN_BIRD_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)IafSounds.STYMPHALIAN_BIRD_DIE.get();
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn) {
        spawnDataIn = super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
        this.getAttribute(Attributes.FOLLOW_RANGE).setBaseValue((double)((Integer)IafCommonConfig.INSTANCE.stymphalianBird.targetSearchLength.getValue()).intValue());
        return spawnDataIn;
    }

    public void setTarget(LivingEntity entity) {
        if (this.isVictor(entity) && entity != null) {
            return;
        }
        super.setTarget(entity);
        if (this.flock != null && this.flock.isLeader(this) && entity != null) {
            this.flock.onLeaderAttack(entity);
        }
    }

    public float getDistanceSquared(Vec3 Vector3d) {
        float f = (float)(this.getX() - Vector3d.x);
        float f1 = (float)(this.getY() - Vector3d.y);
        float f2 = (float)(this.getZ() - Vector3d.z);
        return f * f + f1 * f1 + f2 * f2;
    }

    protected boolean isTargetInAir() {
        return this.airTarget != null && (this.level().getBlockState(this.airTarget).isAir() || this.level().getBlockState(this.airTarget).isAir());
    }

    public boolean doesWantToLand() {
        if (this.flock != null && !this.flock.isLeader(this) && this.flock.getLeader() != null) {
            return this.flock.getLeader().doesWantToLand();
        }
        return this.flyTicks > 500 || this.flyTicks > 40 && this.flyProgress == 0.0f;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_PECK, ANIMATION_SHOOT_ARROWS, ANIMATION_SPEAK};
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return (Boolean)IafCommonConfig.INSTANCE.stymphalianBird.attackAnimals.getValue();
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }
}

