/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityStymphalianBird;
import com.iafenvoy.iceandfire.registry.IafItems;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class EntityStymphalianFeather
extends AbstractArrow {
    public EntityStymphalianFeather(EntityType<? extends AbstractArrow> t, Level worldIn) {
        super(t, worldIn);
    }

    public EntityStymphalianFeather(EntityType<? extends AbstractArrow> t, Level worldIn, LivingEntity shooter) {
        super(t, worldIn);
        this.setOwner((Entity)shooter);
        this.setBaseDamage((Double)IafCommonConfig.INSTANCE.stymphalianBird.featherAttackDamage.getValue());
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        if ((Double)IafCommonConfig.INSTANCE.stymphalianBird.featherDropChance.getValue() > 0.0 && this.level().isClientSide && this.random.nextDouble() < (Double)IafCommonConfig.INSTANCE.stymphalianBird.featherDropChance.getValue()) {
            this.spawnAtLocation(this.getPickupItem(), 0.1f);
        }
    }

    public void tick() {
        super.tick();
        if (this.tickCount > 100) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void onHitEntity(EntityHitResult entityHit) {
        Entity shootingEntity = this.getOwner();
        if (!(shootingEntity instanceof EntityStymphalianBird) || entityHit.getEntity() == null || !(entityHit.getEntity() instanceof EntityStymphalianBird)) {
            Entity entity;
            super.onHitEntity(entityHit);
            if (entityHit.getEntity() != null && (entity = entityHit.getEntity()) instanceof EntityStymphalianBird) {
                EntityStymphalianBird bird = (EntityStymphalianBird)entity;
                bird.setArrowCount(bird.getArrowCount() - 1);
            }
        }
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)IafItems.STYMPHALIAN_BIRD_FEATHER.get());
    }
}

