/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.EntityCyclops;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;

public class CyclopsAIAttackMelee
extends MeleeAttackGoal {
    public CyclopsAIAttackMelee(EntityCyclops creature, double speedIn, boolean useLongMemory) {
        super((PathfinderMob)creature, speedIn, useLongMemory);
    }

    protected void checkAndPerformAttack(LivingEntity entity) {
        float distance = this.mob.distanceTo((Entity)entity);
        double d0 = Math.sqrt(this.getSquaredMaxAttackDistance(entity));
        if (this.isCyclopsBlinded() && distance >= 6.0f) {
            this.stop();
            return;
        }
        if ((double)distance <= d0) {
            this.mob.swing(InteractionHand.MAIN_HAND);
            this.mob.doHurtTarget((Entity)entity);
        }
    }

    private boolean isCyclopsBlinded() {
        EntityCyclops cyclops;
        PathfinderMob pathfinderMob = this.mob;
        return pathfinderMob instanceof EntityCyclops && (cyclops = (EntityCyclops)pathfinderMob).isBlinded();
    }

    protected double getSquaredMaxAttackDistance(LivingEntity entity) {
        return this.mob.getBbWidth() * 2.0f * this.mob.getBbWidth() * 2.0f + entity.getBbWidth();
    }
}

