/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import java.util.EnumSet;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class DragonAIWander
extends Goal {
    private final EntityDragonBase dragon;
    private final double speed;
    private double xPosition;
    private double yPosition;
    private double zPosition;
    private int executionChance;
    private boolean mustUpdate;

    public DragonAIWander(EntityDragonBase creatureIn, double speedIn) {
        this(creatureIn, speedIn, 20);
    }

    public DragonAIWander(EntityDragonBase creatureIn, double speedIn, int chance) {
        this.dragon = creatureIn;
        this.speed = speedIn;
        this.executionChance = chance;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!this.dragon.canMove() || this.dragon.isFuelingForge()) {
            return false;
        }
        if (this.dragon.isFlying() || this.dragon.isHovering()) {
            return false;
        }
        if (!this.mustUpdate && this.dragon.getRandom().nextInt(this.executionChance) != 0) {
            return false;
        }
        Vec3 Vector3d = DefaultRandomPos.getPos((PathfinderMob)this.dragon, (int)10, (int)7);
        if (Vector3d == null) {
            return false;
        }
        this.xPosition = Vector3d.x;
        this.yPosition = Vector3d.y;
        this.zPosition = Vector3d.z;
        this.mustUpdate = false;
        return true;
    }

    public boolean canContinueToUse() {
        return !this.dragon.getNavigation().isDone();
    }

    public void start() {
        this.dragon.getNavigation().moveTo(this.xPosition, this.yPosition, this.zPosition, this.speed);
    }

    public void makeUpdate() {
        this.mustUpdate = true;
    }

    public void setExecutionChance(int newchance) {
        this.executionChance = newchance;
    }
}

