/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.util.dragon;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityCockatrice;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityGhost;
import com.iafenvoy.iceandfire.entity.EntityGorgon;
import com.iafenvoy.iceandfire.entity.EntityHippogryph;
import com.iafenvoy.iceandfire.entity.EntityMultipartPart;
import com.iafenvoy.iceandfire.entity.EntitySeaSerpent;
import com.iafenvoy.iceandfire.entity.EntityStymphalianBird;
import com.iafenvoy.iceandfire.entity.util.IDeadMob;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.tag.IafBlockTags;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DragonUtils {
    public static BlockPos getBlockInViewEscort(EntityDragonBase dragon) {
        BlockPos escortPos = dragon.getEscortPosition();
        BlockPos ground = dragon.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, escortPos);
        int distFromGround = escortPos.getY() - ground.getY();
        for (int i = 0; i < 10; ++i) {
            BlockPos pos = new BlockPos(escortPos.getX() + dragon.getRandom().nextInt(((Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue()).intValue()) - (Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue() / 2, distFromGround > 16 ? escortPos.getY() : escortPos.getY() + 8 + dragon.getRandom().nextInt(16), escortPos.getZ() + dragon.getRandom().nextInt(((Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue()).intValue()) - (Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue() / 2);
            if (!(dragon.getDistanceSquared(Vec3.atCenterOf((Vec3i)pos)) > 6.0f) || dragon.isTargetBlocked(Vec3.atCenterOf((Vec3i)pos))) continue;
            return pos;
        }
        return null;
    }

    public static BlockPos getWaterBlockInViewEscort(EntityDragonBase dragon) {
        BlockPos inWaterEscortPos = dragon.getEscortPosition();
        if (Math.abs(dragon.getX() - (double)inWaterEscortPos.getX()) < dragon.getBoundingBox().getXsize() && Math.abs(dragon.getZ() - (double)inWaterEscortPos.getZ()) < dragon.getBoundingBox().getZsize()) {
            return dragon.blockPosition();
        }
        if ((double)inWaterEscortPos.getY() - dragon.getY() > (double)(8 + dragon.getYNavSize()) && !dragon.level().getFluidState(inWaterEscortPos.below()).is(FluidTags.WATER)) {
            dragon.setHovering(true);
        }
        return inWaterEscortPos;
    }

    public static BlockPos getBlockInView(EntityDragonBase dragon) {
        BlockPos pos;
        float radius = 12.0f * (0.7f * dragon.getRenderSize() / 3.0f);
        float neg = dragon.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = dragon.yBodyRot;
        if (dragon.hasHomePosition && dragon.homePos != null) {
            BlockPos dragonPos = dragon.blockPosition();
            BlockPos ground = dragon.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dragonPos);
            int distFromGround = (int)dragon.getY() - ground.getY();
            for (int i = 0; i < 10; ++i) {
                BlockPos homePos = dragon.homePos.getPosition();
                BlockPos pos2 = new BlockPos(homePos.getX() + dragon.getRandom().nextInt((Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue() * 2) - (Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue(), distFromGround > 16 ? (int)Math.min((double)((Integer)IafCommonConfig.INSTANCE.dragon.maxFlight.getValue()).intValue(), dragon.getY() + (double)dragon.getRandom().nextInt(16) - 8.0) : (int)dragon.getY() + dragon.getRandom().nextInt(16) + 1, homePos.getZ() + dragon.getRandom().nextInt((Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue() * 2) - (Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue());
                if (!(dragon.getDistanceSquared(Vec3.atCenterOf((Vec3i)pos2)) > 6.0f) || dragon.isTargetBlocked(Vec3.atCenterOf((Vec3i)pos2))) continue;
                return pos2;
            }
        }
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + dragon.getRandom().nextFloat() * neg;
        double extraX = radius * Mth.sin((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = BlockPos.containing((double)(dragon.getX() + extraX), (double)0.0, (double)(dragon.getZ() + extraZ));
        BlockPos ground = dragon.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, radialPos);
        int distFromGround = (int)dragon.getY() - ground.getY();
        BlockPos newPos = radialPos.above(distFromGround > 16 ? (int)Math.min((double)((Integer)IafCommonConfig.INSTANCE.dragon.maxFlight.getValue()).intValue(), dragon.getY() + (double)dragon.getRandom().nextInt(16) - 8.0) : (int)dragon.getY() + dragon.getRandom().nextInt(16) + 1);
        BlockPos blockPos = pos = dragon.doesWantToLand() ? ground : newPos;
        if (dragon.getDistanceSquared(Vec3.atCenterOf((Vec3i)newPos)) > 6.0f && !dragon.isTargetBlocked(Vec3.atCenterOf((Vec3i)newPos))) {
            return pos;
        }
        return null;
    }

    public static BlockPos getWaterBlockInView(EntityDragonBase dragon) {
        BlockPos surface;
        float radius = 0.75f * (0.7f * dragon.getRenderSize() / 3.0f) * -7.0f - (float)dragon.getRandom().nextInt(dragon.getDragonStage() * 6);
        float neg = dragon.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float angle = (float)Math.PI / 180 * dragon.yBodyRot + 3.15f + dragon.getRandom().nextFloat() * neg;
        double extraX = radius * Mth.sin((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = BlockPos.containing((double)(dragon.getX() + extraX), (double)0.0, (double)(dragon.getZ() + extraZ));
        BlockPos ground = dragon.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, radialPos);
        int distFromGround = (int)dragon.getY() - ground.getY();
        BlockPos newPos = radialPos.above(distFromGround > 16 ? (int)Math.min((double)((Integer)IafCommonConfig.INSTANCE.dragon.maxFlight.getValue()).intValue(), dragon.getY() + (double)dragon.getRandom().nextInt(16) - 8.0) : (int)dragon.getY() + dragon.getRandom().nextInt(16) + 1);
        BlockPos pos = dragon.doesWantToLand() ? ground : newPos;
        BlockPos blockPos = surface = dragon.level().getFluidState(newPos.below(2)).is(FluidTags.WATER) ? newPos.below(dragon.getRandom().nextInt(10) + 1) : newPos;
        if (dragon.getDistanceSquared(Vec3.atCenterOf((Vec3i)surface)) > 6.0f && dragon.level().getFluidState(surface).is(FluidTags.WATER)) {
            return surface;
        }
        return null;
    }

    public static LivingEntity riderLookingAtEntity(LivingEntity dragon, LivingEntity rider, double dist) {
        Vec3 Vector3d = rider.getEyePosition(1.0f);
        Vec3 Vector3d1 = rider.getViewVector(1.0f);
        Vec3 Vector3d2 = Vector3d.add(Vector3d1.x * dist, Vector3d1.y * dist, Vector3d1.z * dist);
        Entity pointedEntity = null;
        List list = rider.level().getEntities((Entity)rider, rider.getBoundingBox().expandTowards(Vector3d1.x * dist, Vector3d1.y * dist, Vector3d1.z * dist).inflate(1.0, 1.0, 1.0), (Predicate)((com.google.common.base.Predicate)entity -> {
            if (DragonUtils.onSameTeam((Entity)dragon, entity)) {
                return false;
            }
            return entity != null && entity.isPickable() && entity instanceof LivingEntity && !entity.is((Entity)dragon) && !entity.isAlliedTo((Entity)dragon) && (!(entity instanceof IDeadMob) || !((IDeadMob)entity).isMobDead());
        }));
        double d2 = dist;
        for (Entity entity1 : list) {
            AABB axisalignedbb = entity1.getBoundingBox().inflate((double)entity1.getPickRadius() + 2.0);
            Vec3 raytraceresult = axisalignedbb.clip(Vector3d, Vector3d2).orElse(Vec3.ZERO);
            if (axisalignedbb.contains(Vector3d)) {
                if (!(d2 >= 0.0)) continue;
                pointedEntity = entity1;
                d2 = 0.0;
                continue;
            }
            double d3 = Vector3d.distanceTo(raytraceresult);
            if (!(d3 < d2) && d2 != 0.0) continue;
            if (entity1.getRootVehicle() == rider.getRootVehicle()) {
                if (d2 != 0.0) continue;
                pointedEntity = entity1;
                continue;
            }
            pointedEntity = entity1;
            d2 = d3;
        }
        return (LivingEntity)pointedEntity;
    }

    public static BlockPos getBlockInViewHippogryph(EntityHippogryph hippo, float yawAddition) {
        int distFromGround;
        BlockPos ground;
        float radius = -12.599999f - (float)hippo.getRandom().nextInt(48);
        float neg = hippo.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float angle = (float)Math.PI / 180 * (hippo.yBodyRot + yawAddition) + 3.15f + hippo.getRandom().nextFloat() * neg;
        double extraX = radius * Mth.sin((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.cos((float)angle);
        if (hippo.hasHomePosition && hippo.homePos != null) {
            BlockPos dragonPos = hippo.blockPosition();
            ground = hippo.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dragonPos);
            distFromGround = (int)hippo.getY() - ground.getY();
            for (int i = 0; i < 10; ++i) {
                BlockPos pos = BlockPos.containing((double)(hippo.homePos.getX() + hippo.getRandom().nextInt(((Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue()).intValue()) - (Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue()), (double)(distFromGround > 16 ? (int)Math.min((double)((Integer)IafCommonConfig.INSTANCE.dragon.maxFlight.getValue()).intValue(), hippo.getY() + (double)hippo.getRandom().nextInt(16) - 8.0) : (int)hippo.getY() + hippo.getRandom().nextInt(16) + 1), (double)(hippo.homePos.getZ() + hippo.getRandom().nextInt((Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue() * 2) - (Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue()));
                if (!(hippo.getDistanceSquared(Vec3.atCenterOf((Vec3i)pos)) > 6.0f) || hippo.isTargetBlocked(Vec3.atCenterOf((Vec3i)pos))) continue;
                return pos;
            }
        }
        BlockPos radialPos = BlockPos.containing((double)(hippo.getX() + extraX), (double)0.0, (double)(hippo.getZ() + extraZ));
        ground = hippo.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, radialPos);
        distFromGround = (int)hippo.getY() - ground.getY();
        BlockPos newPos = radialPos.above(distFromGround > 16 ? (int)Math.min((double)((Integer)IafCommonConfig.INSTANCE.dragon.maxFlight.getValue()).intValue(), hippo.getY() + (double)hippo.getRandom().nextInt(16) - 8.0) : (int)hippo.getY() + hippo.getRandom().nextInt(16) + 1);
        if (!hippo.isTargetBlocked(Vec3.atCenterOf((Vec3i)newPos)) && hippo.getDistanceSquared(Vec3.atCenterOf((Vec3i)newPos)) > 6.0f) {
            return newPos;
        }
        return null;
    }

    public static BlockPos getBlockInViewStymphalian(EntityStymphalianBird bird) {
        float radius = -9.45f - (float)bird.getRandom().nextInt(24);
        float neg = bird.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = bird.flock != null && !bird.flock.isLeader(bird) ? DragonUtils.getStymphalianFlockDirection(bird) : bird.yBodyRot;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + bird.getRandom().nextFloat() * neg;
        double extraX = radius * Mth.sin((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = DragonUtils.getStymphalianFearPos(bird, BlockPos.containing((double)(bird.getX() + extraX), (double)0.0, (double)(bird.getZ() + extraZ)));
        BlockPos ground = bird.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, radialPos);
        int distFromGround = (int)bird.getY() - ground.getY();
        int flightHeight = Math.min((Integer)IafCommonConfig.INSTANCE.stymphalianBird.flightHeight.getValue(), ground.getY() + bird.getRandom().nextInt(16));
        BlockPos newPos = radialPos.above(distFromGround > 16 ? flightHeight : (int)bird.getY() + bird.getRandom().nextInt(16) + 1);
        if (bird.getDistanceSquared(Vec3.atCenterOf((Vec3i)newPos)) > 6.0f && !bird.isTargetBlocked(Vec3.atCenterOf((Vec3i)newPos))) {
            return newPos;
        }
        return null;
    }

    private static BlockPos getStymphalianFearPos(EntityStymphalianBird bird, BlockPos fallback) {
        Vec3 Vector3d;
        if (bird.getVictor() != null && bird.getVictor() instanceof PathfinderMob && (Vector3d = DefaultRandomPos.getPosAway((PathfinderMob)((PathfinderMob)bird.getVictor()), (int)16, (int)((Integer)IafCommonConfig.INSTANCE.stymphalianBird.flightHeight.getValue()), (Vec3)new Vec3(bird.getVictor().getX(), bird.getVictor().getY(), bird.getVictor().getZ()))) != null) {
            BlockPos pos = BlockPos.containing((Position)Vector3d);
            return new BlockPos(pos.getX(), 0, pos.getZ());
        }
        return fallback;
    }

    private static float getStymphalianFlockDirection(EntityStymphalianBird bird) {
        EntityStymphalianBird leader = bird.flock.getLeader();
        if (bird.distanceToSqr((Entity)leader) > 2.0) {
            double d0 = leader.getX() - bird.getX();
            double d2 = leader.getZ() - bird.getZ();
            float f = (float)(Mth.atan2((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
            float degrees = Mth.wrapDegrees((float)(f - bird.getYRot()));
            return bird.getYRot() + degrees;
        }
        return leader.yBodyRot;
    }

    public static BlockPos getBlockInTargetsViewCockatrice(EntityCockatrice cockatrice, LivingEntity target) {
        float radius = 10 + cockatrice.getRandom().nextInt(10);
        float angle = (float)Math.PI / 180 * target.yHeadRot;
        double extraX = radius * Mth.sin((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = BlockPos.containing((double)(target.getX() + extraX), (double)0.0, (double)(target.getZ() + extraZ));
        BlockPos ground = target.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, radialPos);
        if (cockatrice.distanceToSqr(Vec3.atCenterOf((Vec3i)ground)) > 30.0 && !cockatrice.isTargetBlocked(Vec3.atCenterOf((Vec3i)ground))) {
            return ground;
        }
        return target.blockPosition();
    }

    public static BlockPos getBlockInTargetsViewGhost(EntityGhost ghost, LivingEntity target) {
        float radius = 4 + ghost.getRandom().nextInt(5);
        float angle = (float)Math.PI / 180 * (target.yHeadRot + 90.0f + (float)ghost.getRandom().nextInt(180));
        double extraX = radius * Mth.sin((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.cos((float)angle);
        if (ghost.distanceToSqr(Vec3.atCenterOf((Vec3i)BlockPos.containing((double)(target.getX() + extraX), (double)target.getY(), (double)(target.getZ() + extraZ)))) > 30.0) {
            return BlockPos.containing((double)(target.getX() + extraX), (double)target.getY(), (double)(target.getZ() + extraZ));
        }
        return ghost.blockPosition();
    }

    public static BlockPos getBlockInTargetsViewGorgon(EntityGorgon cockatrice, LivingEntity target) {
        float radius = 6.0f;
        float angle = (float)Math.PI / 180 * target.yHeadRot;
        double extraX = radius * Mth.sin((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = BlockPos.containing((double)(target.getX() + extraX), (double)target.getY(), (double)(target.getZ() + extraZ));
        if (cockatrice.distanceToSqr(Vec3.atCenterOf((Vec3i)radialPos)) < 300.0 && !cockatrice.isTargetBlocked(Vec3.atCenterOf((Vec3i)radialPos).add(0.0, 0.75, 0.0))) {
            return radialPos;
        }
        return target.blockPosition();
    }

    public static BlockPos getBlockInTargetsViewSeaSerpent(EntitySeaSerpent serpent, LivingEntity target) {
        float radius = 10.0f * serpent.getSeaSerpentScale() + (float)serpent.getRandom().nextInt(10);
        float angle = (float)Math.PI / 180 * target.yHeadRot;
        double extraX = radius * Mth.sin((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = BlockPos.containing((double)(target.getX() + extraX), (double)0.0, (double)(target.getZ() + extraZ));
        BlockPos ground = target.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, radialPos);
        if (serpent.distanceToSqr(Vec3.atCenterOf((Vec3i)ground)) > 30.0) {
            return ground;
        }
        return target.blockPosition();
    }

    public static boolean canTameDragonAttack(TamableAnimal dragon, Entity entity) {
        if (DragonUtils.isVillager(entity)) {
            return false;
        }
        if (entity instanceof AbstractVillager || entity instanceof AbstractGolem || entity instanceof Player) {
            return false;
        }
        if (entity instanceof TamableAnimal) {
            TamableAnimal tameable = (TamableAnimal)entity;
            return !tameable.isTame();
        }
        return true;
    }

    public static boolean isVillager(Entity entity) {
        return entity instanceof Villager;
    }

    public static boolean isAnimaniaMob(Entity entity) {
        return false;
    }

    public static boolean isDragonTargetable(Entity entity, TagKey<EntityType<?>> tag) {
        return entity.getType().is(tag);
    }

    public static String getDimensionName(Level world) {
        return world.dimension().location().toString();
    }

    public static boolean isInHomeDimension(EntityDragonBase dragonBase) {
        return dragonBase.getHomeDimensionName() == null || DragonUtils.getDimensionName(dragonBase.level()).equals(dragonBase.getHomeDimensionName());
    }

    public static boolean canDragonBreak(BlockState state, Entity entity) {
        if (!entity.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            return false;
        }
        Block block = state.getBlock();
        return block.getExplosionResistance() < 1200.0f && !state.is(IafBlockTags.DRAGON_BLOCK_BREAK_BLACKLIST);
    }

    public static boolean hasSameOwner(TamableAnimal cockatrice, Entity entity) {
        if (entity instanceof TamableAnimal) {
            TamableAnimal tameable = (TamableAnimal)entity;
            return tameable.getOwnerUUID() != null && cockatrice.getOwnerUUID() != null && tameable.getOwnerUUID().equals(cockatrice.getOwnerUUID());
        }
        return false;
    }

    public static boolean isAlive(LivingEntity entity) {
        IDeadMob deadMob;
        EntityDragonBase dragon;
        if (entity instanceof EntityDragonBase && (dragon = (EntityDragonBase)entity).isMobDead()) {
            return false;
        }
        return (!(entity instanceof IDeadMob) || !(deadMob = (IDeadMob)entity).isMobDead()) && !EntityGorgon.isStoneMob(entity);
    }

    public static boolean canGrief(EntityDragonBase dragon) {
        if (dragon.isTame() && !((Boolean)IafCommonConfig.INSTANCE.dragon.tamedGriefing.getValue()).booleanValue()) {
            return false;
        }
        return (Boolean)IafCommonConfig.INSTANCE.dragon.griefing.getValue();
    }

    public static boolean canHostilesTarget(Entity entity) {
        LivingEntity livingEntity;
        EntityDragonBase dragonBase;
        if (entity instanceof Player && (entity.level().getDifficulty() == Difficulty.PEACEFUL || ((Player)entity).isCreative())) {
            return false;
        }
        if (entity instanceof EntityDragonBase && (dragonBase = (EntityDragonBase)entity).isMobDead()) {
            return false;
        }
        return entity instanceof LivingEntity && DragonUtils.isAlive(livingEntity = (LivingEntity)entity);
    }

    public static boolean onSameTeam(Entity entity1, Entity entity2) {
        TamableAnimal tameable;
        EntityMultipartPart mutlipartPart;
        Entity multipart;
        TamableAnimal tameable2;
        LivingEntity owner1 = null;
        LivingEntity owner2 = null;
        boolean def = entity1.isAlliedTo(entity2);
        if (entity1 instanceof TamableAnimal) {
            tameable2 = (TamableAnimal)entity1;
            owner1 = tameable2.getOwner();
        }
        if (entity2 instanceof TamableAnimal) {
            tameable2 = (TamableAnimal)entity2;
            owner2 = tameable2.getOwner();
        }
        if (entity1 instanceof EntityMultipartPart && (multipart = (mutlipartPart = (EntityMultipartPart)entity1).getParent()) instanceof TamableAnimal) {
            tameable = (TamableAnimal)multipart;
            owner1 = tameable.getOwner();
        }
        if (entity2 instanceof EntityMultipartPart && (multipart = (mutlipartPart = (EntityMultipartPart)entity2).getParent()) instanceof TamableAnimal) {
            tameable = (TamableAnimal)multipart;
            owner2 = tameable.getOwner();
        }
        if (owner1 != null && owner2 != null) {
            return owner1.is((Entity)owner2);
        }
        return def;
    }

    public static boolean isDreadBlock(BlockState state) {
        Block block = state.getBlock();
        return block == IafBlocks.DREAD_STONE.get() || block == IafBlocks.DREAD_STONE_BRICKS.get() || block == IafBlocks.DREAD_STONE_BRICKS_CHISELED.get() || block == IafBlocks.DREAD_STONE_BRICKS_CRACKED.get() || block == IafBlocks.DREAD_STONE_BRICKS_MOSSY.get() || block == IafBlocks.DREAD_STONE_TILE.get() || block == IafBlocks.DREAD_STONE_FACE.get() || block == IafBlocks.DREAD_TORCH.get() || block == IafBlocks.DREAD_STONE_BRICKS_STAIRS.get() || block == IafBlocks.DREAD_STONE_BRICKS_SLAB.get() || block == IafBlocks.DREADWOOD_LOG.get() || block == IafBlocks.DREADWOOD_PLANKS.get() || block == IafBlocks.DREADWOOD_PLANKS_LOCK.get() || block == IafBlocks.DREAD_PORTAL.get() || block == IafBlocks.DREAD_SPAWNER.get();
    }
}

