/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.util.dragon;

import com.iafenvoy.iceandfire.api.IafEvents;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.data.component.IafEntityData;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.block.BlockEntityDragonForgeInput;
import com.iafenvoy.iceandfire.entity.util.BlockLaunchExplosion;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.item.block.BlockCharedPath;
import com.iafenvoy.iceandfire.item.block.BlockFallingReturningState;
import com.iafenvoy.iceandfire.item.block.BlockReturningState;
import com.iafenvoy.iceandfire.item.block.util.IDragonProof;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafDamageTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SpreadingSnowyDirtBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class IafDragonDestructionManager {
    public static void destroyAreaBreath(Level level, BlockPos center, EntityDragonBase dragon) {
        float damageScale;
        int statusDuration;
        if (((IafEvents.DragonFireDamageWorld)IafEvents.ON_DRAGON_DAMAGE_BLOCK.invoker()).onDamageBlock(dragon, center.getX(), center.getY(), center.getZ())) {
            return;
        }
        if (dragon.dragonType == DragonType.FIRE) {
            statusDuration = 5 + dragon.getDragonStage() * 5;
            damageScale = ((Double)IafCommonConfig.INSTANCE.dragon.attackDamageFire.getValue()).floatValue();
        } else if (dragon.dragonType == DragonType.ICE) {
            statusDuration = 50 * dragon.getDragonStage();
            damageScale = ((Double)IafCommonConfig.INSTANCE.dragon.attackDamageIce.getValue()).floatValue();
        } else if (dragon.dragonType == DragonType.LIGHTNING) {
            statusDuration = 3;
            damageScale = ((Double)IafCommonConfig.INSTANCE.dragon.attackDamageLightning.getValue()).floatValue();
        } else {
            return;
        }
        double damageRadius = 3.5;
        boolean canBreakBlocks = level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
        if (dragon.getDragonStage() <= 3) {
            BlockPos.betweenClosedStream((BlockPos)center.offset(-1, -1, -1), (BlockPos)center.offset(1, 1, 1)).forEach(position -> {
                BlockEntity patt0$temp = level.getBlockEntity(position);
                if (patt0$temp instanceof BlockEntityDragonForgeInput) {
                    BlockEntityDragonForgeInput forge = (BlockEntityDragonForgeInput)patt0$temp;
                    forge.onHitWithFlame();
                    return;
                }
                if (canBreakBlocks && DragonUtils.canGrief(dragon) && dragon.getRandom().nextBoolean()) {
                    IafDragonDestructionManager.attackBlock(level, dragon, position);
                }
            });
        } else {
            int radius = dragon.getDragonStage() == 4 ? 2 : 3;
            int x = radius + level.random.nextInt(1);
            int y = radius + level.random.nextInt(1);
            int z = radius + level.random.nextInt(1);
            float f = (float)(x + y + z) * 0.333f + 0.5f;
            float ff = f * f;
            damageRadius = 2.5f + f * 1.2f;
            BlockPos.betweenClosedStream((BlockPos)center.offset(-x, -y, -z), (BlockPos)center.offset(x, y, z)).forEach(position -> {
                BlockEntity patt0$temp = level.getBlockEntity(position);
                if (patt0$temp instanceof BlockEntityDragonForgeInput) {
                    BlockEntityDragonForgeInput forge = (BlockEntityDragonForgeInput)patt0$temp;
                    forge.onHitWithFlame();
                    return;
                }
                if (canBreakBlocks && center.distSqr((Vec3i)position) <= (double)ff && DragonUtils.canGrief(dragon) && level.random.nextFloat() > (float)center.distSqr((Vec3i)position) / ff) {
                    IafDragonDestructionManager.attackBlock(level, dragon, position);
                }
            });
        }
        DamageSource damageSource = IafDragonDestructionManager.getDamageSource(dragon);
        float stageDamage = (float)dragon.getDragonStage() * damageScale;
        level.getEntitiesOfClass(LivingEntity.class, new AABB((double)center.getX() - damageRadius, (double)center.getY() - damageRadius, (double)center.getZ() - damageRadius, (double)center.getX() + damageRadius, (double)center.getY() + damageRadius, (double)center.getZ() + damageRadius)).forEach(target -> {
            if (!DragonUtils.onSameTeam((Entity)dragon, (Entity)target) && !dragon.is((Entity)target) && dragon.hasLineOfSight((Entity)target)) {
                target.hurt(damageSource, stageDamage);
                IafDragonDestructionManager.applyDragonEffect(target, dragon, statusDuration);
            }
        });
    }

    public static void destroyAreaCharge(Level level, BlockPos center, EntityDragonBase dragon) {
        int statusDuration;
        boolean canBreakBlocks;
        if (dragon == null) {
            return;
        }
        if (((IafEvents.DragonFireDamageWorld)IafEvents.ON_DRAGON_DAMAGE_BLOCK.invoker()).onDamageBlock(dragon, center.getX(), center.getY(), center.getZ())) {
            return;
        }
        int x = 2;
        int y = 2;
        int z = 2;
        boolean bl = canBreakBlocks = DragonUtils.canGrief(dragon) && level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
        if (canBreakBlocks) {
            if (dragon.getDragonStage() <= 3) {
                BlockPos.betweenClosedStream((BlockPos)center.offset(-x, -y, -z), (BlockPos)center.offset(x, y, z)).forEach(position -> {
                    BlockState state = level.getBlockState(position);
                    if (state.getBlock() instanceof IDragonProof) {
                        return;
                    }
                    if ((double)(dragon.getRandom().nextFloat() * 3.0f) > center.distSqr((Vec3i)position) && DragonUtils.canDragonBreak(state, (Entity)dragon)) {
                        level.destroyBlock(position, false);
                    }
                    if (dragon.getRandom().nextBoolean()) {
                        IafDragonDestructionManager.attackBlock(level, dragon, position, state);
                    }
                });
            } else {
                int radius = dragon.getDragonStage() == 4 ? 2 : 3;
                x = radius + level.random.nextInt(2);
                y = radius + level.random.nextInt(2);
                z = radius + level.random.nextInt(2);
                float f = (float)(x + y + z) * 0.333f + 0.5f;
                float ff = f * f;
                IafDragonDestructionManager.destroyBlocks(level, center, x, y, z, ff, (Entity)dragon);
                BlockPos.betweenClosedStream((BlockPos)center.offset(-(++x), -(++y), -(++z)), (BlockPos)center.offset(x, y, z)).forEach(position -> {
                    if (center.distSqr((Vec3i)position) <= (double)ff) {
                        IafDragonDestructionManager.attackBlock(level, dragon, position);
                    }
                });
            }
        }
        if (dragon.dragonType == DragonType.FIRE) {
            statusDuration = 15;
        } else if (dragon.dragonType == DragonType.ICE) {
            statusDuration = 400;
        } else if (dragon.dragonType == DragonType.LIGHTNING) {
            statusDuration = 9;
        } else {
            return;
        }
        float stageDamage = (float)Math.max(1, dragon.getDragonStage() - 1) * 2.0f;
        DamageSource damageSource = IafDragonDestructionManager.getDamageSource(dragon);
        level.getEntitiesOfClass(LivingEntity.class, new AABB((double)center.getX() - (double)x, (double)center.getY() - (double)y, (double)center.getZ() - (double)z, (double)center.getX() + (double)x, (double)center.getY() + (double)y, (double)center.getZ() + (double)z)).forEach(target -> {
            if (!dragon.isAlliedTo((Entity)target) && !dragon.is((Entity)target) && dragon.hasLineOfSight((Entity)target)) {
                target.hurt(damageSource, stageDamage);
                IafDragonDestructionManager.applyDragonEffect(target, dragon, statusDuration);
            }
        });
        if (((Boolean)IafCommonConfig.INSTANCE.dragon.explosiveBreath.getValue()).booleanValue()) {
            IafDragonDestructionManager.causeExplosion(level, center, dragon, damageSource, dragon.getDragonStage());
        }
    }

    private static DamageSource getDamageSource(EntityDragonBase dragon) {
        Player player = dragon.getRidingPlayer();
        if (dragon.dragonType == DragonType.FIRE) {
            return player != null ? IafDamageTypes.causeIndirectDragonFireDamage((Entity)dragon, (Entity)player) : IafDamageTypes.causeDragonFireDamage((Entity)dragon);
        }
        if (dragon.dragonType == DragonType.ICE) {
            return player != null ? IafDamageTypes.causeIndirectDragonIceDamage((Entity)dragon, (Entity)player) : IafDamageTypes.causeDragonIceDamage((Entity)dragon);
        }
        if (dragon.dragonType == DragonType.LIGHTNING) {
            return player != null ? IafDamageTypes.causeIndirectDragonLightningDamage((Entity)dragon, (Entity)player) : IafDamageTypes.causeDragonLightningDamage((Entity)dragon);
        }
        return dragon.level().damageSources().mobAttack((LivingEntity)dragon);
    }

    private static void attackBlock(Level level, EntityDragonBase dragon, BlockPos position, BlockState state) {
        boolean doPlaceBlock;
        Block elementalBlock;
        BlockState transformed;
        if (state.getBlock() instanceof IDragonProof || !DragonUtils.canDragonBreak(state, (Entity)dragon)) {
            return;
        }
        if (dragon.dragonType == DragonType.FIRE) {
            transformed = IafDragonDestructionManager.transformBlockFire(state);
        } else if (dragon.dragonType == DragonType.ICE) {
            transformed = IafDragonDestructionManager.transformBlockIce(state);
        } else if (dragon.dragonType == DragonType.LIGHTNING) {
            transformed = IafDragonDestructionManager.transformBlockLightning(state);
        } else {
            return;
        }
        if (!transformed.is(state.getBlock())) {
            level.setBlockAndUpdate(position, transformed);
        }
        if (dragon.dragonType == DragonType.FIRE) {
            elementalBlock = Blocks.FIRE;
            doPlaceBlock = dragon.getRandom().nextBoolean();
        } else if (dragon.dragonType == DragonType.ICE) {
            elementalBlock = (Block)IafBlocks.DRAGON_ICE_SPIKES.get();
            doPlaceBlock = dragon.getRandom().nextInt(9) == 0;
        } else {
            return;
        }
        BlockState stateAbove = level.getBlockState(position.above());
        if (doPlaceBlock && transformed.isSolid() && stateAbove.getFluidState().isEmpty() && !stateAbove.canOcclude() && state.canOcclude() && DragonUtils.canDragonBreak(stateAbove, (Entity)dragon)) {
            level.setBlockAndUpdate(position.above(), elementalBlock.defaultBlockState());
        }
    }

    private static void attackBlock(Level level, EntityDragonBase dragon, BlockPos position) {
        IafDragonDestructionManager.attackBlock(level, dragon, position, level.getBlockState(position));
    }

    private static void applyDragonEffect(LivingEntity target, EntityDragonBase dragon, int statusDuration) {
        if (dragon.dragonType == DragonType.FIRE) {
            target.igniteForSeconds((float)statusDuration);
        } else if (dragon.dragonType == DragonType.ICE) {
            IafEntityData data = IafEntityData.get(target);
            data.frozenData.setFrozen(target, statusDuration);
        } else if (dragon.dragonType == DragonType.LIGHTNING) {
            double x = dragon.getX() - target.getX();
            double y = dragon.getZ() - target.getZ();
            target.knockback((double)statusDuration / 10.0, x, y);
        }
    }

    private static void causeExplosion(Level world, BlockPos center, EntityDragonBase destroyer, DamageSource source, int stage) {
        Explosion.BlockInteraction mode = world.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP;
        BlockLaunchExplosion explosion = new BlockLaunchExplosion(world, (Mob)destroyer, source, center.getX(), center.getY(), center.getZ(), Math.min(2, stage - 2), mode);
        explosion.explode();
        explosion.finalizeExplosion(true);
    }

    private static void destroyBlocks(Level world, BlockPos center, int x, int y, int z, double radius2, Entity destroyer) {
        BlockPos.betweenClosedStream((BlockPos)center.offset(-x, -y, -z), (BlockPos)center.offset(x, y, z)).forEach(pos -> {
            if (center.distSqr((Vec3i)pos) <= radius2) {
                BlockState state = world.getBlockState(pos);
                if (state.getBlock() instanceof IDragonProof) {
                    return;
                }
                if ((double)(world.random.nextFloat() * 3.0f) > (double)((float)center.distSqr((Vec3i)pos)) / radius2 && DragonUtils.canDragonBreak(state, destroyer)) {
                    world.destroyBlock(pos, false);
                }
            }
        });
    }

    public static BlockState transformBlockFire(BlockState in) {
        if (in.getBlock() instanceof SpreadingSnowyDirtBlock) {
            return (BlockState)((Block)IafBlocks.CHARRED_GRASS.get()).defaultBlockState().setValue((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.is(Blocks.DIRT)) {
            return (BlockState)((Block)IafBlocks.CHARRED_DIRT.get()).defaultBlockState().setValue((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.is(BlockTags.SAND) && in.getBlock() == Blocks.GRAVEL) {
            return (BlockState)((Block)IafBlocks.CHARRED_GRAVEL.get()).defaultBlockState().setValue((Property)BlockFallingReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.is(BlockTags.BASE_STONE_OVERWORLD) && (in.getBlock() == Blocks.COBBLESTONE || in.getBlock().getDescriptionId().contains("cobblestone"))) {
            return (BlockState)((Block)IafBlocks.CHARRED_COBBLESTONE.get()).defaultBlockState().setValue((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.is(BlockTags.BASE_STONE_OVERWORLD) && in.getBlock() != IafBlocks.CHARRED_COBBLESTONE.get()) {
            return (BlockState)((Block)IafBlocks.CHARRED_STONE.get()).defaultBlockState().setValue((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.getBlock() == Blocks.DIRT_PATH) {
            return (BlockState)((Block)IafBlocks.CHARRED_DIRT_PATH.get()).defaultBlockState().setValue((Property)BlockCharedPath.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.is(BlockTags.LOGS) || in.is(BlockTags.PLANKS)) {
            return ((Block)IafBlocks.ASH.get()).defaultBlockState();
        }
        if (in.is(BlockTags.LEAVES) || in.is(BlockTags.FLOWERS) || in.is(BlockTags.CROPS) || in.getBlock() == Blocks.SNOW) {
            return Blocks.AIR.defaultBlockState();
        }
        return in;
    }

    public static BlockState transformBlockIce(BlockState in) {
        if (in.getBlock() instanceof SpreadingSnowyDirtBlock) {
            return (BlockState)((Block)IafBlocks.FROZEN_GRASS.get()).defaultBlockState().setValue((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.is(BlockTags.DIRT) && in.getBlock() == Blocks.DIRT || in.is(BlockTags.SNOW)) {
            return (BlockState)((Block)IafBlocks.FROZEN_DIRT.get()).defaultBlockState().setValue((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.is(BlockTags.SAND) && in.getBlock() == Blocks.GRAVEL) {
            return (BlockState)((Block)IafBlocks.FROZEN_GRAVEL.get()).defaultBlockState().setValue((Property)BlockFallingReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.is(BlockTags.SAND) && in.getBlock() != Blocks.GRAVEL) {
            return in;
        }
        if (in.is(BlockTags.BASE_STONE_OVERWORLD) && (in.getBlock() == Blocks.COBBLESTONE || in.getBlock().getDescriptionId().contains("cobblestone"))) {
            return (BlockState)((Block)IafBlocks.FROZEN_COBBLESTONE.get()).defaultBlockState().setValue((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.is(BlockTags.BASE_STONE_OVERWORLD) && in.getBlock() != IafBlocks.FROZEN_COBBLESTONE.get()) {
            return (BlockState)((Block)IafBlocks.FROZEN_STONE.get()).defaultBlockState().setValue((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.getBlock() == Blocks.DIRT_PATH) {
            return (BlockState)((Block)IafBlocks.FROZEN_DIRT_PATH.get()).defaultBlockState().setValue((Property)BlockCharedPath.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.is(BlockTags.LOGS) || in.is(BlockTags.PLANKS)) {
            return ((Block)IafBlocks.FROZEN_SPLINTERS.get()).defaultBlockState();
        }
        if (in.is(Blocks.WATER)) {
            return Blocks.ICE.defaultBlockState();
        }
        if (in.is(BlockTags.LEAVES) || in.is(BlockTags.FLOWERS) || in.is(BlockTags.CROPS) || in.getBlock() == Blocks.SNOW) {
            return Blocks.AIR.defaultBlockState();
        }
        return in;
    }

    public static BlockState transformBlockLightning(BlockState in) {
        if (in.getBlock() instanceof SpreadingSnowyDirtBlock) {
            return (BlockState)((Block)IafBlocks.CRACKLED_GRASS.get()).defaultBlockState().setValue((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.is(BlockTags.DIRT) && in.getBlock() == Blocks.DIRT) {
            return (BlockState)((Block)IafBlocks.CRACKLED_DIRT.get()).defaultBlockState().setValue((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.is(BlockTags.SAND) && in.getBlock() == Blocks.GRAVEL) {
            return (BlockState)((Block)IafBlocks.CRACKLED_GRAVEL.get()).defaultBlockState().setValue((Property)BlockFallingReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.is(BlockTags.BASE_STONE_OVERWORLD) && (in.getBlock() == Blocks.COBBLESTONE || in.getBlock().getDescriptionId().contains("cobblestone"))) {
            return (BlockState)((Block)IafBlocks.CRACKLED_COBBLESTONE.get()).defaultBlockState().setValue((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.is(BlockTags.BASE_STONE_OVERWORLD) && in.getBlock() != IafBlocks.CRACKLED_COBBLESTONE.get()) {
            return (BlockState)((Block)IafBlocks.CRACKLED_STONE.get()).defaultBlockState().setValue((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.getBlock() == Blocks.DIRT_PATH) {
            return (BlockState)((Block)IafBlocks.CRACKLED_DIRT_PATH.get()).defaultBlockState().setValue((Property)BlockCharedPath.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.is(BlockTags.LOGS) || in.is(BlockTags.PLANKS)) {
            return ((Block)IafBlocks.ASH.get()).defaultBlockState();
        }
        if (in.is(BlockTags.LEAVES) || in.is(BlockTags.FLOWERS) || in.is(BlockTags.CROPS) || in.getBlock() == Blocks.SNOW) {
            return Blocks.AIR.defaultBlockState();
        }
        return in;
    }
}

