/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item;

import com.iafenvoy.iceandfire.data.component.IafEntityData;
import com.iafenvoy.iceandfire.registry.IafDataComponents;
import com.iafenvoy.iceandfire.registry.IafSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ItemDeathwormGauntlet
extends Item {
    private boolean deathwormReceded = true;
    private boolean deathwormLaunched = false;
    private int specialDamage = 0;

    public ItemDeathwormGauntlet() {
        super(new Item.Properties().durability(500).component((DataComponentType)IafDataComponents.INT.get(), (Object)-1));
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 1;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack itemStackIn = playerIn.getItemInHand(hand);
        playerIn.startUsingItem(hand);
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStackIn);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int count) {
        if (!this.deathwormReceded && !this.deathwormLaunched && entity instanceof Player) {
            Player player = (Player)entity;
            if (((Integer)stack.get((DataComponentType)IafDataComponents.INT.get())).intValue() != player.getId()) {
                stack.set((DataComponentType)IafDataComponents.INT.get(), (Object)player.getId());
            }
            if (player.getCooldowns().getCooldownPercent((Item)this, 0.0f) == 0.0f) {
                player.getCooldowns().addCooldown((Item)this, 10);
                player.playSound((SoundEvent)IafSounds.DEATHWORM_ATTACK.get(), 1.0f, 1.0f);
                this.deathwormReceded = false;
                this.deathwormLaunched = true;
            }
        }
    }

    public void releaseUsing(ItemStack stack, Level worldIn, LivingEntity user, int timeLeft) {
        if (this.specialDamage > 0) {
            stack.hurtAndBreak(this.specialDamage, user, LivingEntity.getSlotForHand((InteractionHand)user.getUsedItemHand()));
            this.specialDamage = 0;
        }
        if ((Integer)stack.get((DataComponentType)IafDataComponents.INT.get()) != -1) {
            stack.set((DataComponentType)IafDataComponents.INT.get(), (Object)-1);
        }
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        if (user instanceof Player) {
            Player player = (Player)user;
            player.getCooldowns().addCooldown((Item)this, 20);
        }
        return super.finishUsingItem(stack, world, user);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        IafEntityData data = IafEntityData.get(living);
        int tempLungeTicks = data.miscData.lungeTicks;
        if (this.deathwormReceded) {
            if (tempLungeTicks > 0) {
                tempLungeTicks -= 4;
            }
            if (tempLungeTicks <= 0) {
                tempLungeTicks = 0;
                this.deathwormReceded = false;
                this.deathwormLaunched = false;
            }
        } else if (this.deathwormLaunched && (tempLungeTicks = 4 + tempLungeTicks) > 20) {
            this.deathwormReceded = true;
        }
        if (data.miscData.lungeTicks >= 20) {
            tempLungeTicks = 0;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                Vec3 Vector3d = player.getViewVector(1.0f).normalize();
                double range = 5.0;
                for (LivingEntity livingEntity2 : world.getEntitiesOfClass(LivingEntity.class, new AABB(player.getX() - range, player.getY() - range, player.getZ() - range, player.getX() + range, player.getY() + range, player.getZ() + range), livingEntity -> true)) {
                    if (livingEntity2 == entity) continue;
                    Vec3 Vector3d1 = new Vec3(livingEntity2.getX() - player.getX(), livingEntity2.getY() - player.getY(), livingEntity2.getZ() - player.getZ());
                    double d0 = Vector3d1.length();
                    double d1 = Vector3d.dot(Vector3d1 = Vector3d1.normalize());
                    boolean canSee = d1 > 1.0 - 0.5 / d0 && player.hasLineOfSight((Entity)livingEntity2);
                    if (!canSee) continue;
                    ++this.specialDamage;
                    livingEntity2.hurt(entity.level().damageSources.playerAttack(player), 3.0f);
                    livingEntity2.knockback(0.5, livingEntity2.getX() - player.getX(), livingEntity2.getZ() - player.getZ());
                }
            }
        }
        data.miscData.setLungeTicks(tempLungeTicks);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.legendary_weapon.desc").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.deathworm_gauntlet.desc_0").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.deathworm_gauntlet.desc_1").withStyle(ChatFormatting.GRAY));
    }
}

