/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.food;

import com.iafenvoy.iceandfire.item.food.ItemGenericFood;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ItemDragonFlesh
extends ItemGenericFood {
    final int dragonType;

    public ItemDragonFlesh(int dragonType) {
        super(8, 0.8f, false, false);
        this.dragonType = dragonType;
    }

    public static String getNameForType(int dragonType) {
        return switch (dragonType) {
            case 1 -> "ice_dragon_flesh";
            case 2 -> "lightning_dragon_flesh";
            default -> "fire_dragon_flesh";
        };
    }

    @Override
    public void onFoodEaten(ItemStack stack, Level worldIn, LivingEntity livingEntity) {
        if (!worldIn.isClientSide) {
            if (this.dragonType == 0) {
                livingEntity.igniteForSeconds(5.0f);
            } else if (this.dragonType == 1) {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 2));
            } else if (!livingEntity.level().isClientSide) {
                LightningBolt lightningboltentity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(livingEntity.level());
                assert (lightningboltentity != null);
                lightningboltentity.moveTo(livingEntity.position());
                if (!livingEntity.level().isClientSide) {
                    livingEntity.level().addFreshEntity((Entity)lightningboltentity);
                }
            }
        }
    }
}

