/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.tool;

import com.iafenvoy.iceandfire.data.TrollType;
import com.iafenvoy.iceandfire.registry.IafToolMaterials;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemTrollWeapon
extends SwordItem {
    public final TrollType.ITrollWeapon weapon;

    public ItemTrollWeapon(TrollType.ITrollWeapon weapon) {
        super((Tier)IafToolMaterials.TROLL_WEAPON_TOOL_MATERIAL, new Item.Properties().component(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemTrollWeapon.createAttributes((Tier)IafToolMaterials.TROLL_WEAPON_TOOL_MATERIAL, (int)15, (float)-3.5f)));
        this.weapon = weapon;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            return (double)player.getAttackStrengthScale(0.0f) < 0.95 || player.attackAnim != 0.0f;
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (selected && (double)player.getAttackStrengthScale(0.0f) < 0.95 && player.attackAnim > 0.0f) {
                --player.swingTime;
            }
        }
    }

    public boolean onEntitySwing(LivingEntity LivingEntity2, ItemStack stack) {
        if (LivingEntity2 instanceof Player) {
            Player player = (Player)LivingEntity2;
            if (player.getAttackStrengthScale(0.0f) < 1.0f && player.attackAnim > 0.0f) {
                return true;
            }
            player.swingTime = -1;
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.legendary_weapon.desc").withStyle(ChatFormatting.GRAY));
    }
}

