/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.network;

import com.iafenvoy.iceandfire.config.IafClientConfig;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.block.BlockEntityJar;
import com.iafenvoy.iceandfire.entity.block.BlockEntityPixieHouse;
import com.iafenvoy.iceandfire.entity.block.BlockEntityPodium;
import com.iafenvoy.iceandfire.entity.util.ISyncMount;
import com.iafenvoy.iceandfire.network.payload.DragonSetBurnBlockPayload;
import com.iafenvoy.iceandfire.network.payload.StartRidingMobS2CPayload;
import com.iafenvoy.iceandfire.network.payload.UpdatePixieHousePayload;
import com.iafenvoy.iceandfire.network.payload.UpdatePixieJarPayload;
import com.iafenvoy.iceandfire.network.payload.UpdatePodiumPayload;
import dev.architectury.networking.NetworkManager;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ClientNetworkHelper {
    private static CameraType prev = CameraType.FIRST_PERSON;

    public static void registerReceivers() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, DragonSetBurnBlockPayload.ID, DragonSetBurnBlockPayload.CODEC, (payload, ctx) -> {
            Entity entity;
            Player player = ctx.getPlayer();
            if (player != null && (entity = player.level().getEntity(payload.entityId())) instanceof EntityDragonBase) {
                EntityDragonBase dragon = (EntityDragonBase)entity;
                dragon.setBreathingFire(payload.breathing());
                dragon.burningTarget = new BlockPos((Vec3i)payload.target());
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, StartRidingMobS2CPayload.ID, StartRidingMobS2CPayload.CODEC, (payload, ctx) -> {
            TamableAnimal tamable;
            Entity entity;
            Options options = Minecraft.getInstance().options;
            Player player = ctx.getPlayer();
            if (player != null && (entity = player.level().getEntity(payload.dragonId())) instanceof ISyncMount && entity instanceof TamableAnimal && (tamable = (TamableAnimal)entity).isOwnedBy((LivingEntity)player) && tamable.distanceTo((Entity)player) < 14.0f) {
                if (payload.ride()) {
                    if (payload.baby()) {
                        tamable.startRiding((Entity)player, true);
                    } else {
                        player.startRiding((Entity)tamable, true);
                        if (((Boolean)IafClientConfig.INSTANCE.dragonAuto3rdPerson.getValue()).booleanValue()) {
                            prev = options.getCameraType();
                            options.setCameraType(CameraType.THIRD_PERSON_BACK);
                        }
                    }
                } else if (payload.baby()) {
                    tamable.stopRiding();
                } else {
                    player.stopRiding();
                    if (((Boolean)IafClientConfig.INSTANCE.dragonAuto3rdPerson.getValue()).booleanValue()) {
                        options.setCameraType(prev);
                    }
                }
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, UpdatePixieHousePayload.ID, UpdatePixieHousePayload.CODEC, (payload, ctx) -> {
            Player player = ctx.getPlayer();
            if (player != null) {
                BlockEntity blockEntity = player.level().getBlockEntity(payload.blockPos());
                if (blockEntity instanceof BlockEntityPixieHouse) {
                    BlockEntityPixieHouse house = (BlockEntityPixieHouse)blockEntity;
                    house.hasPixie = payload.hasPixie();
                    house.pixieType = payload.pixieType();
                } else if (blockEntity instanceof BlockEntityJar) {
                    BlockEntityJar jar = (BlockEntityJar)blockEntity;
                    jar.hasPixie = payload.hasPixie();
                    jar.pixieType = payload.pixieType();
                }
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, UpdatePixieJarPayload.ID, UpdatePixieJarPayload.CODEC, (payload, ctx) -> {
            BlockEntity patt0$temp;
            Player player = ctx.getPlayer();
            if (player != null && (patt0$temp = player.level().getBlockEntity(payload.blockPos())) instanceof BlockEntityJar) {
                BlockEntityJar jar = (BlockEntityJar)patt0$temp;
                jar.hasProduced = payload.isProducing();
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, UpdatePodiumPayload.ID, UpdatePodiumPayload.CODEC, (payload, ctx) -> {
            BlockEntity patt0$temp;
            Player player = ctx.getPlayer();
            if (player != null && (patt0$temp = player.level().getBlockEntity(payload.blockPos())) instanceof BlockEntityPodium) {
                BlockEntityPodium podium = (BlockEntityPodium)patt0$temp;
                podium.setItem(0, payload.heldStack());
            }
        });
    }
}

