/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.particle;

import com.iafenvoy.iceandfire.entity.EntityGhost;
import com.iafenvoy.iceandfire.registry.IafRenderLayers;
import com.iafenvoy.iceandfire.render.entity.RenderGhost;
import com.iafenvoy.iceandfire.render.model.ModelGhost;
import com.iafenvoy.iceandfire.util.Color4i;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ParticleGhostAppearance
extends Particle {
    private final ModelGhost model = new ModelGhost(0.0f);
    private final int ghost;
    private final boolean fromLeft;

    public ParticleGhostAppearance(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, int ghost) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn);
        this.gravity = 0.0f;
        this.lifetime = 15;
        this.ghost = ghost;
        this.fromLeft = worldIn.random.nextBoolean();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        float f = ((float)this.age + partialTicks) / (float)this.lifetime;
        float f1 = 0.05f + 0.5f * Mth.sin((float)(f * (float)Math.PI));
        Entity entity = this.level.getEntity(this.ghost);
        if (entity instanceof EntityGhost) {
            EntityGhost ghostEntity = (EntityGhost)entity;
            if (Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON) {
                PoseStack matrixstack = new PoseStack();
                matrixstack.mulPose(renderInfo.rotation());
                if (this.fromLeft) {
                    matrixstack.mulPose(Axis.YN.rotationDegrees(150.0f * f - 60.0f));
                    matrixstack.mulPose(Axis.ZN.rotationDegrees(150.0f * f - 60.0f));
                } else {
                    matrixstack.mulPose(Axis.YP.rotationDegrees(150.0f * f - 60.0f));
                    matrixstack.mulPose(Axis.ZP.rotationDegrees(150.0f * f - 60.0f));
                }
                matrixstack.scale(-1.0f, -1.0f, 1.0f);
                matrixstack.translate(0.0, (double)0.3f, 1.25);
                MultiBufferSource.BufferSource irendertypebuffer$impl = Minecraft.getInstance().renderBuffers().bufferSource();
                VertexConsumer ivertexbuilder = irendertypebuffer$impl.getBuffer(IafRenderLayers.getGhost(RenderGhost.getGhostOverlayForType(ghostEntity.getColor())));
                this.model.setAngles(ghostEntity, 0.0f, 0.0f, (float)entity.tickCount + partialTicks, 0.0f, 0.0f);
                this.model.renderToBuffer(matrixstack, ivertexbuilder, 240, OverlayTexture.NO_OVERLAY, new Color4i(1.0, 1.0, 1.0, f1).getIntValue());
                irendertypebuffer$impl.endBatch();
            }
        }
    }
}

