/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.registry;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.TrollType;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.tag.CommonTags;
import com.iafenvoy.uranus.util.function.MemorizeSupplier;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public final class IafArmorMaterials {
    public static final DeferredRegister<ArmorMaterial> REGISTRY = DeferredRegister.create((String)"iceandfire", (ResourceKey)Registries.ARMOR_MATERIAL);
    public static final RegistrySupplier<ArmorMaterial> COPPER_ARMOR_MATERIAL = IafArmorMaterials.register("copper", new int[]{1, 3, 4, 2}, 15, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GOLD, 0.0f, (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{Items.COPPER_INGOT})));
    public static final RegistrySupplier<ArmorMaterial> SILVER_ARMOR_MATERIAL = IafArmorMaterials.register("silver", new int[]{1, 4, 5, 2}, 20, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_CHAIN, 0.0f, (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of(CommonTags.Items.INGOTS_SILVER)));
    public static final RegistrySupplier<ArmorMaterial> BLINDFOLD_ARMOR_MATERIAL = IafArmorMaterials.register("blindfold", new int[]{1, 1, 1, 1}, 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 0.0f, (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of(CommonTags.Items.STRINGS)));
    public static final RegistrySupplier<ArmorMaterial> SHEEP_ARMOR_MATERIAL = IafArmorMaterials.register("sheep", new int[]{1, 3, 2, 1}, 15, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 0.0f, (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{Blocks.WHITE_WOOL})));
    public static final RegistrySupplier<ArmorMaterial> EARPLUGS_ARMOR_MATERIAL = IafArmorMaterials.register("earplugs", new int[]{1, 1, 1, 1}, 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 0.0f, (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{Blocks.OAK_BUTTON})));
    public static final RegistrySupplier<ArmorMaterial> DEATHWORM_0_ARMOR_MATERIAL = IafArmorMaterials.register("yellow_deathworm", new int[]{2, 5, 7, 3}, 5, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 1.5f, (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)IafItems.DEATH_WORM_CHITIN_YELLOW.get()})));
    public static final RegistrySupplier<ArmorMaterial> DEATHWORM_1_ARMOR_MATERIAL = IafArmorMaterials.register("white_deathworm", new int[]{2, 5, 7, 3}, 5, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 1.5f, (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)IafItems.DEATH_WORM_CHITIN_RED.get()})));
    public static final RegistrySupplier<ArmorMaterial> DEATHWORM_2_ARMOR_MATERIAL = IafArmorMaterials.register("red_deathworm", new int[]{2, 5, 7, 3}, 5, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 1.5f, (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)IafItems.DEATH_WORM_CHITIN_WHITE.get()})));
    public static final RegistrySupplier<ArmorMaterial> TROLL_MOUNTAIN_ARMOR_MATERIAL = IafArmorMaterials.register("mountain_troll", new int[]{2, 5, 7, 3}, 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 1.0f, (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TrollType.MOUNTAIN.leather.get()})));
    public static final RegistrySupplier<ArmorMaterial> TROLL_FOREST_ARMOR_MATERIAL = IafArmorMaterials.register("forest_troll", new int[]{2, 5, 7, 3}, 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 1.0f, (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TrollType.FOREST.leather.get()})));
    public static final RegistrySupplier<ArmorMaterial> TROLL_FROST_ARMOR_MATERIAL = IafArmorMaterials.register("frost_troll", new int[]{2, 5, 7, 3}, 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 1.0f, (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TrollType.FROST.leather.get()})));
    public static final RegistrySupplier<ArmorMaterial> DRAGONSTEEL_FIRE_ARMOR_MATERIAL = IafArmorMaterials.register("dragonsteel_fire", new int[]{(Integer)IafCommonConfig.INSTANCE.armors.dragonsteelBootsArmor.getValue(), (Integer)IafCommonConfig.INSTANCE.armors.dragonsteelLeggingsArmor.getValue(), (Integer)IafCommonConfig.INSTANCE.armors.dragonsteelChestplateArmor.getValue(), (Integer)IafCommonConfig.INSTANCE.armors.dragonsteelHelmetArmor.getValue()}, (Integer)IafCommonConfig.INSTANCE.armors.dragonsteelArmorEnchantability.getValue(), (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, ((Double)IafCommonConfig.INSTANCE.armors.dragonsteelArmorToughness.getValue()).floatValue(), ((Double)IafCommonConfig.INSTANCE.armors.dragonsteelArmorKnockbackResistance.getValue()).floatValue(), (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)IafItems.DRAGONSTEEL_FIRE_INGOT.get()})));
    public static final RegistrySupplier<ArmorMaterial> DRAGONSTEEL_ICE_ARMOR_MATERIAL = IafArmorMaterials.register("dragonsteel_ice", new int[]{(Integer)IafCommonConfig.INSTANCE.armors.dragonsteelBootsArmor.getValue(), (Integer)IafCommonConfig.INSTANCE.armors.dragonsteelLeggingsArmor.getValue(), (Integer)IafCommonConfig.INSTANCE.armors.dragonsteelChestplateArmor.getValue(), (Integer)IafCommonConfig.INSTANCE.armors.dragonsteelHelmetArmor.getValue()}, (Integer)IafCommonConfig.INSTANCE.armors.dragonsteelArmorEnchantability.getValue(), (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, ((Double)IafCommonConfig.INSTANCE.armors.dragonsteelArmorToughness.getValue()).floatValue(), ((Double)IafCommonConfig.INSTANCE.armors.dragonsteelArmorKnockbackResistance.getValue()).floatValue(), (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)IafItems.DRAGONSTEEL_ICE_INGOT.get()})));
    public static final RegistrySupplier<ArmorMaterial> DRAGONSTEEL_LIGHTNING_ARMOR_MATERIAL = IafArmorMaterials.register("dragonsteel_lightning", new int[]{(Integer)IafCommonConfig.INSTANCE.armors.dragonsteelBootsArmor.getValue(), (Integer)IafCommonConfig.INSTANCE.armors.dragonsteelLeggingsArmor.getValue(), (Integer)IafCommonConfig.INSTANCE.armors.dragonsteelChestplateArmor.getValue(), (Integer)IafCommonConfig.INSTANCE.armors.dragonsteelHelmetArmor.getValue()}, (Integer)IafCommonConfig.INSTANCE.armors.dragonsteelArmorEnchantability.getValue(), (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, ((Double)IafCommonConfig.INSTANCE.armors.dragonsteelArmorToughness.getValue()).floatValue(), ((Double)IafCommonConfig.INSTANCE.armors.dragonsteelArmorKnockbackResistance.getValue()).floatValue(), (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)IafItems.DRAGONSTEEL_ICE_INGOT.get()})));

    public static RegistrySupplier<ArmorMaterial> register(String name, int[] damageReduction, int enchantability, Holder<SoundEvent> sound, float toughness, Supplier<Ingredient> repairIngredients) {
        return REGISTRY.register(name, () -> IafArmorMaterials.createMaterial(name, damageReduction, enchantability, sound, toughness, 0.0f, repairIngredients));
    }

    public static RegistrySupplier<ArmorMaterial> register(String name, int[] damageReduction, int enchantability, Holder<SoundEvent> sound, float toughness, float knockBackResistance, Supplier<Ingredient> repairIngredients) {
        return REGISTRY.register(name, () -> IafArmorMaterials.createMaterial(name, damageReduction, enchantability, sound, toughness, knockBackResistance, repairIngredients));
    }

    public static ArmorMaterial createMaterial(String name, int[] protection, int enchantAbility, Holder<SoundEvent> equipSound, float toughness, float knockBackResistance, Supplier<Ingredient> repairIngredients) {
        return new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.HELMET, protection[3]);
            map.put(ArmorItem.Type.CHESTPLATE, protection[2]);
            map.put(ArmorItem.Type.LEGGINGS, protection[1]);
            map.put(ArmorItem.Type.BOOTS, protection[0]);
        }), enchantAbility, equipSound, repairIngredients, List.of(new ArmorMaterial.Layer(ResourceLocation.tryParse((String)name))), toughness, knockBackResistance);
    }
}

