/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.registry;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public final class IafDamageTypes {
    public static final ResourceKey<DamageType> BONUS = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"bonus"));
    public static final ResourceKey<DamageType> GORGON_DMG_TYPE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"gorgon"));
    public static final ResourceKey<DamageType> DRAGON_FIRE_TYPE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"dragon_fire"));
    public static final ResourceKey<DamageType> DRAGON_ICE_TYPE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"dragon_ice"));
    public static final ResourceKey<DamageType> DRAGON_LIGHTNING_TYPE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"dragon_lightning"));

    public static DamageSource bonusDamage(Entity attacker) {
        Holder holder = (Holder)attacker.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolder(BONUS).get();
        return new DamageSource(holder, attacker);
    }

    public static CustomEntityDamageSource causeGorgonDamage(Entity entity) {
        Holder holder = (Holder)entity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolder(GORGON_DMG_TYPE).get();
        return new CustomEntityDamageSource((Holder<DamageType>)holder, entity);
    }

    public static CustomEntityDamageSource causeDragonFireDamage(Entity entity) {
        Holder holder = (Holder)entity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolder(DRAGON_FIRE_TYPE).get();
        return new CustomEntityDamageSource((Holder<DamageType>)holder, entity);
    }

    public static CustomIndirectEntityDamageSource causeIndirectDragonFireDamage(Entity source, Entity indirectEntityIn) {
        Holder holder = (Holder)indirectEntityIn.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolder(DRAGON_FIRE_TYPE).get();
        return new CustomIndirectEntityDamageSource((Holder<DamageType>)holder, source, indirectEntityIn);
    }

    public static CustomEntityDamageSource causeDragonIceDamage(Entity entity) {
        Holder holder = (Holder)entity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolder(DRAGON_ICE_TYPE).get();
        return new CustomEntityDamageSource((Holder<DamageType>)holder, entity);
    }

    public static CustomIndirectEntityDamageSource causeIndirectDragonIceDamage(Entity source, Entity indirectEntityIn) {
        Holder holder = (Holder)indirectEntityIn.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolder(DRAGON_ICE_TYPE).get();
        return new CustomIndirectEntityDamageSource((Holder<DamageType>)holder, source, indirectEntityIn);
    }

    public static CustomEntityDamageSource causeDragonLightningDamage(Entity entity) {
        Holder holder = (Holder)entity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolder(DRAGON_LIGHTNING_TYPE).get();
        return new CustomEntityDamageSource((Holder<DamageType>)holder, entity);
    }

    public static CustomIndirectEntityDamageSource causeIndirectDragonLightningDamage(Entity source, Entity indirectEntityIn) {
        Holder holder = (Holder)indirectEntityIn.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolder(DRAGON_LIGHTNING_TYPE).get();
        return new CustomIndirectEntityDamageSource((Holder<DamageType>)holder, source, indirectEntityIn);
    }

    public static class CustomEntityDamageSource
    extends DamageSource {
        public CustomEntityDamageSource(Holder<DamageType> damageTypeIn, Entity damageSourceEntityIn) {
            super(damageTypeIn, damageSourceEntityIn);
        }

        public Component getLocalizedDeathMessage(LivingEntity entityLivingBaseIn) {
            LivingEntity livingentity = entityLivingBaseIn.getKillCredit();
            String s = "death.attack." + this.getMsgId();
            int index = entityLivingBaseIn.getRandom().nextInt(2);
            String s1 = s + "." + index;
            String s2 = s + ".attacker_" + index;
            return livingentity != null ? Component.translatable((String)s2, (Object[])new Object[]{entityLivingBaseIn.getDisplayName(), livingentity.getDisplayName()}) : Component.translatable((String)s1, (Object[])new Object[]{entityLivingBaseIn.getDisplayName()});
        }
    }

    public static class CustomIndirectEntityDamageSource
    extends DamageSource {
        public CustomIndirectEntityDamageSource(Holder<DamageType> damageTypeIn, Entity source, Entity indirectEntityIn) {
            super(damageTypeIn, source, indirectEntityIn);
        }

        public Component getLocalizedDeathMessage(LivingEntity entityLivingBaseIn) {
            LivingEntity livingentity = entityLivingBaseIn.getKillCredit();
            String s = "death.attack." + this.getMsgId();
            int index = entityLivingBaseIn.getRandom().nextInt(2);
            String s1 = s + "." + index;
            String s2 = s + ".attacker_" + index;
            return livingentity != null ? Component.translatable((String)s2, (Object[])new Object[]{entityLivingBaseIn.getDisplayName(), livingentity.getDisplayName()}) : Component.translatable((String)s1, (Object[])new Object[]{entityLivingBaseIn.getDisplayName()});
        }
    }
}

