/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity;

import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityDragonSkull;
import com.iafenvoy.iceandfire.registry.IafRenderers;
import com.iafenvoy.iceandfire.render.model.animator.FireDragonTabulaModelAnimator;
import com.iafenvoy.iceandfire.render.model.animator.IceDragonTabulaModelAnimator;
import com.iafenvoy.iceandfire.render.model.animator.LightningTabulaDragonAnimator;
import com.iafenvoy.uranus.client.model.ITabulaModelAnimator;
import com.iafenvoy.uranus.client.model.TabulaModel;
import com.iafenvoy.uranus.client.model.basic.BasicModelPart;
import com.iafenvoy.uranus.client.model.util.TabulaModelHandlerHelper;
import com.iafenvoy.uranus.util.function.MemorizeSupplier;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class RenderDragonSkull
extends EntityRenderer<EntityDragonSkull> {
    public static final Map<DragonType, Pair<ResourceLocation, MemorizeSupplier<ITabulaModelAnimator<EntityDragonBase>>>> MODELS = new HashMap<DragonType, Pair<ResourceLocation, MemorizeSupplier<ITabulaModelAnimator<EntityDragonBase>>>>();
    public static final float[] growth_stage_1 = new float[]{1.0f, 3.0f};
    public static final float[] growth_stage_2 = new float[]{3.0f, 7.0f};
    public static final float[] growth_stage_3 = new float[]{7.0f, 12.5f};
    public static final float[] growth_stage_4 = new float[]{12.5f, 20.0f};
    public static final float[] growth_stage_5 = new float[]{20.0f, 30.0f};
    public final float[][] growth_stages = new float[][]{growth_stage_1, growth_stage_2, growth_stage_3, growth_stage_4, growth_stage_5};

    public RenderDragonSkull(EntityRendererProvider.Context context) {
        super(context);
    }

    private static void setRotationAngles(BasicModelPart cube, float rotX) {
        cube.rotateAngleX = rotX;
        cube.rotateAngleY = 0.0f;
        cube.rotateAngleZ = 0.0f;
    }

    public void render(EntityDragonSkull entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        Pair<ResourceLocation, MemorizeSupplier<ITabulaModelAnimator<EntityDragonBase>>> p = MODELS.get(DragonType.getTypeById(entity.getDragonType()));
        TabulaModel model = TabulaModelHandlerHelper.getModel((ResourceLocation)((ResourceLocation)p.getFirst()), (MemorizeSupplier)((MemorizeSupplier)p.getSecond()));
        if (model == null) {
            return;
        }
        VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTexture(entity)));
        matrixStackIn.pushPose();
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(-180.0f));
        matrixStackIn.mulPose(Axis.YN.rotationDegrees(-180.0f - entity.getYRot()));
        matrixStackIn.scale(1.0f, 1.0f, 1.0f);
        float size = this.getRenderSize(entity) / 3.0f;
        matrixStackIn.scale(size, size, size);
        matrixStackIn.translate(0.0f, entity.isOnWall() ? -0.24f : -0.12f, entity.isOnWall() ? 0.4f : 0.5f);
        model.resetToDefaultPose();
        RenderDragonSkull.setRotationAngles((BasicModelPart)model.getCube("Head"), entity.isOnWall() ? (float)Math.toRadians(50.0) : 0.0f);
        model.getCube("Head").render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, -1);
        matrixStackIn.popPose();
    }

    public ResourceLocation getTexture(EntityDragonSkull entity) {
        return DragonType.getTypeById(entity.getDragonType()).getSkeletonTexture(entity.getDragonStage());
    }

    public float getRenderSize(EntityDragonSkull skull) {
        float step = (this.growth_stages[skull.getDragonStage() - 1][1] - this.growth_stages[skull.getDragonStage() - 1][0]) / 25.0f;
        if (skull.getDragonAge() > 125) {
            return this.growth_stages[skull.getDragonStage() - 1][0] + step * 25.0f;
        }
        return this.growth_stages[skull.getDragonStage() - 1][0] + step * (float)this.getAgeFactor(skull);
    }

    private int getAgeFactor(EntityDragonSkull skull) {
        return skull.getDragonStage() > 1 ? skull.getDragonAge() - 25 * (skull.getDragonStage() - 1) : skull.getDragonAge();
    }

    static {
        MODELS.put(DragonType.FIRE, (Pair<ResourceLocation, MemorizeSupplier<ITabulaModelAnimator<EntityDragonBase>>>)Pair.of((Object)IafRenderers.FIRE_DRAGON, (Object)new MemorizeSupplier(FireDragonTabulaModelAnimator::new)));
        MODELS.put(DragonType.ICE, (Pair<ResourceLocation, MemorizeSupplier<ITabulaModelAnimator<EntityDragonBase>>>)Pair.of((Object)IafRenderers.ICE_DRAGON, (Object)new MemorizeSupplier(IceDragonTabulaModelAnimator::new)));
        MODELS.put(DragonType.LIGHTNING, (Pair<ResourceLocation, MemorizeSupplier<ITabulaModelAnimator<EntityDragonBase>>>)Pair.of((Object)IafRenderers.LIGHTNING_DRAGON, (Object)new MemorizeSupplier(LightningTabulaDragonAnimator::new)));
    }
}

