/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.model.animator;

import com.iafenvoy.iceandfire.util.IafMath;
import com.iafenvoy.uranus.client.model.AdvancedModelBox;
import com.iafenvoy.uranus.client.model.ModelAnimator;
import com.iafenvoy.uranus.client.model.TabulaModel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class IceAndFireTabulaModelAnimator<T extends Entity> {
    protected final TabulaModel<T> baseModel;

    public IceAndFireTabulaModelAnimator(TabulaModel<T> baseModel) {
        this.baseModel = baseModel;
    }

    public void setRotateAngle(AdvancedModelBox model, float limbSwingAmount, float x, float y, float z) {
        model.rotateAngleX += limbSwingAmount * this.distance(model.rotateAngleX, x);
        model.rotateAngleY += limbSwingAmount * this.distance(model.rotateAngleY, y);
        model.rotateAngleZ += limbSwingAmount * this.distance(model.rotateAngleZ, z);
    }

    public void addToRotateAngle(AdvancedModelBox model, float limbSwingAmount, float x, float y, float z) {
        model.rotateAngleX += Math.min(limbSwingAmount * 2.0f, 1.0f) * this.distance(model.defaultRotationX, x);
        model.rotateAngleY += Math.min(limbSwingAmount * 2.0f, 1.0f) * this.distance(model.defaultRotationY, y);
        model.rotateAngleZ += Math.min(limbSwingAmount * 2.0f, 1.0f) * this.distance(model.defaultRotationZ, z);
    }

    public boolean isRotationEqual(AdvancedModelBox original, AdvancedModelBox pose) {
        return pose != null && pose.rotateAngleX == original.defaultRotationX && pose.rotateAngleY == original.defaultRotationY && pose.rotateAngleZ == original.defaultRotationZ;
    }

    public boolean isPositionEqual(AdvancedModelBox original, AdvancedModelBox pose) {
        return pose.rotationPointX == original.defaultPositionX && pose.rotationPointY == original.defaultPositionY && pose.rotationPointZ == original.defaultPositionZ;
    }

    public void transitionTo(AdvancedModelBox from, AdvancedModelBox to, float timer, float maxTime, boolean oldFashioned) {
        if (oldFashioned) {
            from.rotateAngleX += (to.rotateAngleX - from.rotateAngleX) / maxTime * timer;
            from.rotateAngleY += (to.rotateAngleY - from.rotateAngleY) / maxTime * timer;
            from.rotateAngleZ += (to.rotateAngleZ - from.rotateAngleZ) / maxTime * timer;
        } else {
            this.transitionAngles(from, to, timer, maxTime);
        }
        from.rotationPointX += (to.rotationPointX - from.rotationPointX) / maxTime * timer;
        from.rotationPointY += (to.rotationPointY - from.rotationPointY) / maxTime * timer;
        from.rotationPointZ += (to.rotationPointZ - from.rotationPointZ) / maxTime * timer;
    }

    public void transitionAngles(AdvancedModelBox from, AdvancedModelBox to, float timer, float maxTime) {
        from.rotateAngleX += this.distance(from.rotateAngleX, to.rotateAngleX) / maxTime * timer;
        from.rotateAngleY += this.distance(from.rotateAngleY, to.rotateAngleY) / maxTime * timer;
        from.rotateAngleZ += this.distance(from.rotateAngleZ, to.rotateAngleZ) / maxTime * timer;
    }

    public float distance(float rotateAngleFrom, float rotateAngleTo) {
        return (float)IafMath.atan2_accurate(Mth.sin((float)(rotateAngleTo - rotateAngleFrom)), Mth.cos((float)(rotateAngleTo - rotateAngleFrom)));
    }

    public void rotate(ModelAnimator animator, AdvancedModelBox model, float x, float y, float z) {
        animator.rotate(model, (float)Math.toRadians(x), (float)Math.toRadians(y), (float)Math.toRadians(z));
    }

    public void moveToPose(TabulaModel<T> model, TabulaModel<T> modelTo) {
        if (model == null || modelTo == null) {
            return;
        }
        for (AdvancedModelBox cube : model.getCubes().values()) {
            float toZ;
            float toY;
            float toX;
            AdvancedModelBox cubeTo = modelTo.getCube(cube.boxName);
            if (!this.isRotationEqual(this.baseModel.getCube(cube.boxName), cubeTo)) {
                toX = cubeTo.rotateAngleX;
                toY = cubeTo.rotateAngleY;
                toZ = cubeTo.rotateAngleZ;
                model.animator.rotate(cube, this.distance(cube.rotateAngleX, toX), this.distance(cube.rotateAngleY, toY), this.distance(cube.rotateAngleZ, toZ));
            }
            if (this.isPositionEqual(this.baseModel.getCube(cube.boxName), cubeTo)) continue;
            toX = cubeTo.rotationPointX;
            toY = cubeTo.rotationPointY;
            toZ = cubeTo.rotationPointZ;
            model.animator.move(cube, toX - cube.rotationPointX, toY - cube.rotationPointY, toZ - cube.rotationPointZ);
        }
    }
}

