/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.feature;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SpawnDragonSkeleton
extends Feature<NoneFeatureConfiguration> {
    protected final EntityType<? extends EntityDragonBase> dragonType;

    public SpawnDragonSkeleton(EntityType<? extends EntityDragonBase> dt, Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
        this.dragonType = dt;
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldIn = context.level();
        RandomSource rand = context.random();
        BlockPos position = context.origin();
        position = worldIn.getHeightmapPos(Heightmap.Types.OCEAN_FLOOR_WG, position.offset(8, 0, 8));
        if (((Boolean)IafCommonConfig.INSTANCE.dragon.generateSkeletons.getValue()).booleanValue() && rand.nextDouble() < (Double)IafCommonConfig.INSTANCE.dragon.generateSkeletonChance.getValue()) {
            EntityDragonBase dragon = (EntityDragonBase)this.dragonType.create((Level)worldIn.getLevel());
            assert (dragon != null);
            dragon.setPos((float)position.getX() + 0.5f, position.getY() + 1, (float)position.getZ() + 0.5f);
            int dragonage = 10 + rand.nextInt(100);
            dragon.growDragon(dragonage);
            dragon.modelDeadProgress = 20.0f;
            dragon.setModelDead(true);
            dragon.setDeathStage(dragonage / 5 / 2);
            dragon.setYRot(rand.nextInt(360));
            worldIn.addFreshEntity((Entity)dragon);
        }
        return true;
    }
}

