/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.model.entity;

import com.klikli_dev.occultism.common.entity.familiar.BeaverFamiliarEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class BeaverFamiliarModel
extends EntityModel<BeaverFamiliarEntity> {
    private static final float PI = (float)Math.PI;
    public ModelPart body;
    public ModelPart tail;
    public ModelPart leftLeg1;
    public ModelPart head;
    public ModelPart leftArm1;
    public ModelPart tail2;
    public ModelPart rightLeg1;
    public ModelPart rightArm1;
    public ModelPart leftLeg2;
    public ModelPart mouth;
    public ModelPart leftEye;
    public ModelPart leftEar;
    public ModelPart rightEye;
    public ModelPart rightEar;
    public ModelPart nose;
    public ModelPart teeth;
    public ModelPart whiskers1;
    public ModelPart whiskers2;
    public ModelPart leftArm2;
    public ModelPart rightLeg2;
    public ModelPart rightArm2;

    public BeaverFamiliarModel(ModelPart part) {
        this.body = part.getChild("body");
        this.tail = this.body.getChild("tail");
        this.leftLeg1 = this.body.getChild("leftLeg1");
        this.head = this.body.getChild("head");
        this.leftArm1 = this.body.getChild("leftArm1");
        this.tail2 = this.body.getChild("tail2");
        this.rightLeg1 = this.body.getChild("rightLeg1");
        this.rightArm1 = this.body.getChild("rightArm1");
        this.leftLeg2 = this.leftLeg1.getChild("leftLeg2");
        this.mouth = this.head.getChild("mouth");
        this.leftEye = this.head.getChild("leftEye");
        this.leftEar = this.head.getChild("leftEar");
        this.rightEye = this.head.getChild("rightEye");
        this.rightEar = this.head.getChild("rightEar");
        this.nose = this.mouth.getChild("nose");
        this.teeth = this.mouth.getChild("teeth");
        this.whiskers1 = this.mouth.getChild("whiskers1");
        this.whiskers2 = this.mouth.getChild("whiskers2");
        this.leftArm2 = this.leftArm1.getChild("leftArm2");
        this.rightLeg2 = this.rightLeg1.getChild("rightLeg2");
        this.rightArm2 = this.rightArm1.getChild("rightArm2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.getRoot();
        PartDefinition body = parts.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -5.0f, 6.0f, 6.0f, 10.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)19.5f, (float)0.0f, (float)0.08726646f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(-10, 22).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 0.0f, 10.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)5.0f, (float)0.50823987f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg1 = body.addOrReplaceChild("leftLeg1", CubeListBuilder.create().texOffs(22, 0).addBox(0.0f, 0.0f, -2.0f, 2.0f, 6.0f, 4.0f, false), PartPose.offsetAndRotation((float)2.0f, (float)-1.5f, (float)2.5f, (float)-0.06981317f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(43, 0).addBox(-2.5f, -2.5f, -5.0f, 5.0f, 5.0f, 5.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-4.0f, (float)-0.08726646f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm1 = body.addOrReplaceChild("leftArm1", CubeListBuilder.create().texOffs(32, 9).addBox(0.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, false), PartPose.offsetAndRotation((float)1.7f, (float)0.0f, (float)-3.0f, (float)-0.06981317f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = body.addOrReplaceChild("tail2", CubeListBuilder.create().texOffs(16, 22).addBox(-3.5f, -0.5f, 0.0f, 7.0f, 1.0f, 9.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)5.0f, (float)0.50823987f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg1 = body.addOrReplaceChild("rightLeg1", CubeListBuilder.create().texOffs(22, 0).addBox(-2.0f, 0.0f, -2.0f, 2.0f, 6.0f, 4.0f, true), PartPose.offsetAndRotation((float)-2.0f, (float)-1.5f, (float)2.5f, (float)-0.06981317f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm1 = body.addOrReplaceChild("rightArm1", CubeListBuilder.create().texOffs(32, 9).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, true), PartPose.offsetAndRotation((float)-1.7f, (float)0.0f, (float)-3.0f, (float)-0.06981317f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg2 = leftLeg1.addOrReplaceChild("leftLeg2", CubeListBuilder.create().texOffs(34, 0).addBox(-1.5f, -0.5f, -4.0f, 3.0f, 1.0f, 4.0f, false), PartPose.offsetAndRotation((float)1.48f, (float)5.7f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition mouth = head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -1.5f, -2.0f, 3.0f, 3.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.3f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEye = head.addOrReplaceChild("leftEye", CubeListBuilder.create().texOffs(34, 5).addBox(0.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)2.0f, (float)-0.5f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEar = head.addOrReplaceChild("leftEar", CubeListBuilder.create().texOffs(0, 20).addBox(0.0f, -2.0f, 0.0f, 2.0f, 2.0f, 0.0f, false), PartPose.offsetAndRotation((float)1.5f, (float)-2.1f, (float)-2.1f, (float)-0.23457225f, (float)-0.35185838f, (float)0.50823987f));
        PartDefinition rightEye = head.addOrReplaceChild("rightEye", CubeListBuilder.create().texOffs(34, 5).addBox(-1.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, true), PartPose.offsetAndRotation((float)-2.0f, (float)-0.5f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightEar = head.addOrReplaceChild("rightEar", CubeListBuilder.create().texOffs(0, 20).addBox(-2.0f, -2.0f, 0.0f, 2.0f, 2.0f, 0.0f, true), PartPose.offsetAndRotation((float)-1.5f, (float)-2.1f, (float)-2.1f, (float)-0.23457225f, (float)0.35185838f, (float)-0.50823987f));
        PartDefinition nose = mouth.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(30, 0).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-0.2f, (float)-1.7f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition teeth = mouth.addOrReplaceChild("teeth", CubeListBuilder.create().texOffs(0, 5).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-0.8f, (float)0.11728612f, (float)0.0f, (float)0.0f));
        PartDefinition whiskers1 = mouth.addOrReplaceChild("whiskers1", CubeListBuilder.create().texOffs(4, 20).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 2.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.3f, (float)-1.7f, (float)0.39095375f, (float)0.03926991f, (float)((float)Math.PI / 180)));
        PartDefinition whiskers2 = mouth.addOrReplaceChild("whiskers2", CubeListBuilder.create().texOffs(4, 20).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 2.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-0.8f, (float)-1.3f, (float)0.39095375f, (float)0.03926991f, (float)((float)(-Math.PI) / 180)));
        PartDefinition leftArm2 = leftArm1.addOrReplaceChild("leftArm2", CubeListBuilder.create().texOffs(40, 10).addBox(-1.0f, -0.5f, -2.0f, 2.0f, 1.0f, 3.0f, false), PartPose.offsetAndRotation((float)1.02f, (float)3.7f, (float)0.02f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg2 = rightLeg1.addOrReplaceChild("rightLeg2", CubeListBuilder.create().texOffs(34, 0).addBox(-1.5f, -0.5f, -4.0f, 3.0f, 1.0f, 4.0f, true), PartPose.offsetAndRotation((float)-1.48f, (float)5.7f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm2 = rightArm1.addOrReplaceChild("rightArm2", CubeListBuilder.create().texOffs(40, 10).addBox(-1.0f, -0.5f, -2.0f, 2.0f, 1.0f, 3.0f, true), PartPose.offsetAndRotation((float)-1.02f, (float)3.7f, (float)0.02f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, int pColor) {
        this.body.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor);
    }

    public void setupAnim(BeaverFamiliarEntity pEntity, float limbSwing, float limbSwingAmount, float pAgeInTicks, float netHeadYaw, float headPitch) {
        this.showModels(pEntity);
        this.rightLeg1.zRot = 0.0f;
        this.leftLeg1.zRot = 0.0f;
        this.rightArm1.zRot = 0.0f;
        this.leftArm1.zRot = 0.0f;
        this.body.xRot = 0.09f;
        this.body.yRot = 0.0f;
        this.body.y = 19.5f;
        this.leftLeg2.xRot = 0.0f;
        this.rightLeg2.xRot = 0.0f;
        this.leftArm2.xRot = 0.0f;
        this.rightArm2.xRot = 0.0f;
        this.head.xRot = this.toRads(headPitch);
        this.head.yRot = this.toRads(netHeadYaw);
        this.rightLeg1.xRot = -0.07f + Mth.cos((float)(limbSwing * 0.7f)) * 0.8f * limbSwingAmount;
        this.leftLeg1.xRot = -0.07f + Mth.cos((float)(limbSwing * 0.7f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        this.rightArm1.xRot = -0.07f + Mth.cos((float)(limbSwing * 0.7f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        this.leftArm1.xRot = -0.07f + Mth.cos((float)(limbSwing * 0.7f)) * 0.8f * limbSwingAmount;
        this.tail.xRot = 0.51f + Mth.cos((float)(pAgeInTicks * 0.1f)) * this.toRads(20.0f);
        this.tail2.xRot = 0.51f + Mth.cos((float)(pAgeInTicks * 0.1f)) * this.toRads(20.0f);
        if (!pEntity.isSitting() && pEntity.isInWater()) {
            this.rightLeg1.zRot = this.toRads(40.0f);
            this.leftLeg1.zRot = -this.toRads(40.0f);
            this.rightArm1.zRot = this.toRads(40.0f);
            this.leftArm1.zRot = -this.toRads(40.0f);
            this.rightLeg1.xRot = -0.07f + Mth.cos((float)(pAgeInTicks * 0.3f)) * 0.4f;
            this.leftLeg1.xRot = -0.07f + Mth.cos((float)(pAgeInTicks * 0.3f)) * 0.4f;
            this.rightArm1.xRot = -0.07f + Mth.cos((float)(pAgeInTicks * 0.3f + (float)Math.PI)) * 0.4f;
            this.leftArm1.xRot = -0.07f + Mth.cos((float)(pAgeInTicks * 0.3f + (float)Math.PI)) * 0.4f;
        }
        if (pEntity.isSitting()) {
            this.body.xRot = this.toRads(-40.0f);
            this.head.xRot = this.toRads(25.0f);
            this.head.yRot = 0.0f;
            this.tail.xRot = this.toRads(70.0f);
            this.tail2.xRot = this.toRads(70.0f);
            this.leftLeg1.xRot = this.toRads(-20.0f);
            this.leftLeg2.xRot = this.toRads(50.0f);
            this.rightLeg1.xRot = this.toRads(-20.0f);
            this.rightLeg2.xRot = this.toRads(50.0f);
            this.leftArm1.xRot = this.toRads(10.0f);
            this.leftArm2.xRot = this.toRads(40.0f);
            this.rightArm1.xRot = this.toRads(10.0f);
            this.rightArm2.xRot = this.toRads(40.0f);
        }
        if (pEntity.isPartying()) {
            this.body.xRot = this.toRads(90.0f);
            this.body.yRot = pAgeInTicks * 0.5f;
            this.body.y = 12.5f;
            this.head.xRot = 0.0f;
            this.head.yRot = 0.0f;
            this.tail.xRot = Mth.cos((float)(pAgeInTicks * 0.8f)) * this.toRads(50.0f);
            this.tail2.xRot = Mth.cos((float)(pAgeInTicks * 0.8f)) * this.toRads(50.0f);
            this.rightLeg1.xRot = -0.07f + Mth.cos((float)(pAgeInTicks * 0.7f)) * this.toRads(40.0f);
            this.leftLeg1.xRot = -0.07f + Mth.cos((float)(pAgeInTicks * 0.7f + (float)Math.PI)) * this.toRads(40.0f);
            this.rightArm1.xRot = -0.07f + Mth.cos((float)(pAgeInTicks * 0.7f + (float)Math.PI)) * this.toRads(40.0f);
            this.leftArm1.xRot = -0.07f + Mth.cos((float)(pAgeInTicks * 0.7f)) * this.toRads(40.0f);
        }
    }

    private float toRads(float deg) {
        return (float)Math.toRadians(deg);
    }

    private void showModels(BeaverFamiliarEntity entityIn) {
        boolean hasEars = entityIn.hasEars();
        boolean hasWhiskers = entityIn.hasWhiskers();
        boolean hasBigTail = entityIn.hasBigTail();
        this.leftEar.visible = hasEars;
        this.rightEar.visible = hasEars;
        this.whiskers1.visible = hasWhiskers;
        this.whiskers2.visible = hasWhiskers;
        this.tail.visible = !hasBigTail;
        this.tail2.visible = hasBigTail;
    }
}

