/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render.entity;

import com.klikli_dev.occultism.client.model.entity.DragonFamiliarModel;
import com.klikli_dev.occultism.client.render.entity.DragonRendering;
import com.klikli_dev.occultism.common.entity.familiar.DragonFamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import org.joml.Matrix4f;

public class DragonFamiliarRenderer
extends MobRenderer<DragonFamiliarEntity, DragonFamiliarModel> {
    private static final ResourceLocation TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/dragon_familiar.png");

    public DragonFamiliarRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new DragonFamiliarModel(context.bakeLayer(OccultismModelLayers.FAMILIAR_DRAGON)), 0.3f);
        this.addLayer(new DragonRendering.StickLayer((RenderLayerParent<DragonFamiliarEntity, DragonFamiliarModel>)this));
        this.addLayer(new DragonRendering.SwordLayer((RenderLayerParent<DragonFamiliarEntity, DragonFamiliarModel>)this));
    }

    public ResourceLocation getTextureLocation(DragonFamiliarEntity entity) {
        return TEXTURES;
    }

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="occultism", value={Dist.CLIENT})
    private static class RenderText {
        private RenderText() {
        }

        @SubscribeEvent
        public static void renderText(RenderLivingEvent.Post<DragonFamiliarEntity, DragonFamiliarModel> event) {
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof DragonFamiliarEntity)) {
                return;
            }
            DragonFamiliarEntity dragon = (DragonFamiliarEntity)livingEntity;
            float partialTicks = event.getPartialTick();
            float textTimer = (float)dragon.getPetTimer() + partialTicks;
            if (textTimer >= 40.0f) {
                return;
            }
            float height = dragon.getBbHeight() + 0.5f;
            MutableComponent text = Component.translatable((String)"dialog.occultism.dragon.pet");
            PoseStack matrixStackIn = event.getPoseStack();
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.0f, height + textTimer / 20.0f, 0.0f);
            matrixStackIn.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
            matrixStackIn.translate((double)Mth.sin((float)(textTimer / 2.0f)) * 0.5, 0.0, 0.0);
            float size = (1.0f - textTimer / 40.0f) * 0.025f;
            matrixStackIn.scale(-size, -size, size);
            Matrix4f matrix = matrixStackIn.last().pose();
            Font font = event.getRenderer().getFont();
            font.drawInBatch((Component)text, (float)(-font.width((FormattedText)text)) / 2.0f, 0.0f, 0xFFFFFF, false, matrix, event.getMultiBufferSource(), Font.DisplayMode.NORMAL, 0, event.getPackedLight());
            matrixStackIn.popPose();
        }
    }
}

