/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.ai.goal;

import com.google.common.base.Predicate;
import com.klikli_dev.occultism.common.entity.ai.EntitySorter;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;

public class PickupItemsGoal
extends TargetGoal {
    protected final SpiritEntity entity;
    protected final Predicate<? super ItemEntity> targetItemSelector;
    protected final EntitySorter entitySorter;
    protected ItemEntity targetItem;
    protected int executionChance;
    protected float pickupRange;

    public PickupItemsGoal(SpiritEntity entity) {
        this(entity, 2.0f, 10);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public PickupItemsGoal(final SpiritEntity entity, float pickupRange, int executionChance) {
        super((Mob)entity, false, false);
        this.entity = entity;
        this.pickupRange = pickupRange;
        this.executionChance = executionChance;
        this.targetItemSelector = new Predicate<ItemEntity>(){

            public boolean apply(@Nullable ItemEntity item) {
                ItemStack stack = item.getItem();
                return !stack.isEmpty() && entity.canPickupItem(item) && ItemHandlerHelper.insertItemStacked((IItemHandler)entity.inventory, (ItemStack)stack, (boolean)true).getCount() < stack.getCount();
            }
        };
        this.entitySorter = new EntitySorter((Entity)entity);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        long worldTime = this.mob.level().getGameTime() % 10L;
        if (this.entity.getNoActionTime() >= 100 && worldTime != 0L) {
            return false;
        }
        if (this.executionChance > 0 && this.entity.getRandom().nextInt(this.executionChance) != 0 && worldTime != 0L) {
            return false;
        }
        int workAreaSize = this.entity.getWorkAreaSize().getValue();
        AABB targetBox = new AABB((double)(-workAreaSize), (double)(-workAreaSize) / 2.0, (double)(-workAreaSize), (double)workAreaSize, (double)workAreaSize / 2.0, (double)workAreaSize).move(this.entity.getWorkAreaCenter());
        List list = this.mob.level().getEntitiesOfClass(ItemEntity.class, targetBox, this.targetItemSelector);
        if (list.isEmpty()) {
            return false;
        }
        list.sort(this.entitySorter);
        this.targetItem = (ItemEntity)list.get(0);
        return true;
    }

    public void tick() {
        if (this.targetItem == null || !this.targetItem.isAlive()) {
            this.stop();
            this.mob.getNavigation().stop();
        } else {
            this.mob.getNavigation().moveTo(this.mob.getNavigation().createPath((Entity)this.targetItem, 0), 1.0);
            double distance = this.entity.position().distanceTo(this.targetItem.position());
            if (distance < (double)this.pickupRange) {
                this.entity.setDeltaMovement(0.0, 0.0, 0.0);
                this.entity.getNavigation().stop();
                ItemStack duplicate = this.targetItem.getItem().copy();
                ItemStackHandler handler = this.entity.inventory;
                if (ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)duplicate, (boolean)true).getCount() < duplicate.getCount()) {
                    ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)duplicate, (boolean)false);
                    this.targetItem.getItem().setCount(remaining.getCount());
                }
            }
        }
    }

    public boolean canContinueToUse() {
        return !this.mob.getNavigation().isDone();
    }

    public void start() {
        this.mob.getNavigation().moveTo(this.mob.getNavigation().createPath((Entity)this.targetItem, 0), 1.0);
        super.start();
    }
}

