/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ops;

import io.wispforest.owo.mixin.SetComponentsLootFunctionAccessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.ApiStatus;

public final class LootOps {
    private static final Map<ResourceLocation[], Supplier<LootPoolEntryContainer.Builder<?>>> ADDITIONS = new HashMap();

    private LootOps() {
    }

    public static void injectItem(ItemLike item, float chance, ResourceLocation ... targetTables) {
        ADDITIONS.put(targetTables, () -> LootItem.lootTableItem((ItemLike)item).when(LootItemRandomChanceCondition.randomChance((float)chance)));
    }

    public static void injectItemWithCount(ItemLike item, float chance, int min, int max, ResourceLocation ... targetTables) {
        ADDITIONS.put(targetTables, () -> ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)item).when(LootItemRandomChanceCondition.randomChance((float)chance))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max))));
    }

    public static void injectItemStack(ItemStack stack, float chance, ResourceLocation ... targetTables) {
        ADDITIONS.put(targetTables, () -> ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)stack.getItem()).when(LootItemRandomChanceCondition.randomChance((float)chance))).apply(() -> SetComponentsLootFunctionAccessor.createSetComponentsLootFunction(List.of(), stack.getComponentsPatch())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)stack.getCount()))));
    }

    public static boolean anyMatch(ResourceLocation target, ResourceLocation ... predicates) {
        for (ResourceLocation predicate : predicates) {
            if (!target.equals((Object)predicate)) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public static void registerListener() {
        NeoForge.EVENT_BUS.addListener(event -> ADDITIONS.forEach((identifiers, lootPoolEntrySupplier) -> {
            if (LootOps.anyMatch(event.getName(), identifiers)) {
                event.getTable().addPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)lootPoolEntrySupplier.get()).build());
            }
        }));
    }
}

