/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import by.dragonsurvivalteam.dragonsurvival.common.capability.Capabilities;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.ClawInventoryData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.neoforged.neoforge.common.ItemAbilities;
import ovh.corail.tombstone.compatibility.IEquipableCompat;

public class CompatibilityDragonSurvival
implements IEquipableCompat {
    public static final CompatibilityDragonSurvival instance = new CompatibilityDragonSurvival();

    private CompatibilityDragonSurvival() {
    }

    @Override
    public boolean autoEquip(ItemStack stack, Player player) {
        try {
            if (!Optional.ofNullable(Capabilities.DRAGON_CAPABILITY).map(arg_0 -> ((Player)player).getCapability(arg_0)).map(DragonStateHandler::isDragon).orElse(false).booleanValue()) {
                return false;
            }
            int slotId = this.getSlot(stack);
            if (slotId < 0) {
                return false;
            }
            SimpleContainer invent = player.getExistingData((Supplier)DSDataAttachments.CLAW_INVENTORY).map(ClawInventoryData::getContainer).orElse(null);
            if (invent != null && invent.getItem(slotId).isEmpty()) {
                invent.setItem(slotId, stack.copy());
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private int getSlot(ItemStack stack) {
        if (stack.canPerformAction(ItemAbilities.PICKAXE_DIG)) {
            return 1;
        }
        if (stack.canPerformAction(ItemAbilities.AXE_DIG)) {
            return 2;
        }
        if (stack.canPerformAction(ItemAbilities.SHOVEL_DIG)) {
            return 3;
        }
        if (stack.canPerformAction(ItemAbilities.SWORD_SWEEP) || stack.getItem() instanceof SwordItem) {
            return 0;
        }
        return -1;
    }
}

