/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.effect;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import ovh.corail.tombstone.effect.TombstoneEffect;
import ovh.corail.tombstone.helper.EffectHelper;

public class GiantStrengthEffect
extends TombstoneEffect {
    public GiantStrengthEffect() {
        super(MobEffectCategory.BENEFICIAL, -2551515);
        this.addAttributeModifier(Attributes.ATTACK_DAMAGE, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"giant_strength_attack_damage"), 3.0, AttributeModifier.Operation.ADD_VALUE);
        this.addAttributeModifier(Attributes.ATTACK_KNOCKBACK, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"giant_strength_knockback"), 0.2f, AttributeModifier.Operation.ADD_VALUE);
        this.addAttributeModifier(Attributes.SCALE, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"giant_strength_scale"), 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        this.addAttributeModifier(Attributes.STEP_HEIGHT, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"giant_strength_step_height"), 0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (!entity.level().isClientSide()) {
            EffectHelper.clearEffect(entity, effect -> effect == MobEffects.DAMAGE_BOOST);
        }
        return true;
    }

    @Override
    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 10 == 0;
    }
}

