/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity.ai;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;

public class StayNearHome<T extends PathfinderMob>
extends RandomStrollGoal {
    private static final int INTERVAL_WALK_RANDOM = 120;
    private static final int INTERVAL_WALK_BACK = 10;
    private final T pathfinderMob;
    private final Function<T, GlobalPos> homeGetter;
    private final Consumer<T> homeReset;

    public StayNearHome(T pathfinderMob, Function<T, GlobalPos> homeGetter, Consumer<T> homeReset, double speedModifier) {
        super(pathfinderMob, speedModifier, 120, false);
        this.pathfinderMob = pathfinderMob;
        this.homeGetter = homeGetter;
        this.homeReset = homeReset;
    }

    public boolean canUse() {
        if (!EntityHelper.targetAnEnemy(this.pathfinderMob)) {
            GlobalPos home = this.homeGetter.apply(this.pathfinderMob);
            if (this.pathfinderMob.level().dimension().equals(home.dimension()) && Math.abs(this.pathfinderMob.getY() - (double)home.pos().getY()) < 10.0) {
                if (home.pos().closerToCenterThan((Position)this.pathfinderMob.position(), 15.0)) {
                    return this.pathfinderMob.getRandom().nextInt(120) == 0 && this.walk(false);
                }
                return this.pathfinderMob.getRandom().nextInt(10) == 0 && this.walk(true);
            }
            if (this.pathfinderMob.onGround() && this.pathfinderMob.getRandom().nextInt(10) == 0) {
                Optional.ofNullable(Helper.getServer()).map(s -> s.getLevel(home.dimension())).ifPresent(level -> CallbackHandler.addFastCallback(() -> {
                    BlockPos startPos = this.pathfinderMob.blockPosition();
                    level.sendParticles((ParticleOptions)ParticleTypes.FLASH, (double)startPos.getX(), (double)startPos.getY() + 0.5, (double)startPos.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                    level.sendParticles((ParticleOptions)ParticleTypes.FLASH, (double)home.pos().getX(), (double)home.pos().getY() + 0.5, (double)home.pos().getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                    Location spawnPos = new SpawnHelper((ServerLevel)level, home.pos()).findSpawnPlace();
                    if (!spawnPos.isOrigin()) {
                        Helper.teleport(this.pathfinderMob, spawnPos, level);
                    } else {
                        this.homeReset.accept(this.pathfinderMob);
                    }
                }));
            }
        }
        return false;
    }

    public boolean canContinueToUse() {
        return !EntityHelper.targetAnEnemy(this.pathfinderMob) && !this.pathfinderMob.getNavigation().isDone();
    }

    protected boolean walk(boolean isBack) {
        Vec3 vec3;
        Vec3 vec32 = vec3 = isBack ? DefaultRandomPos.getPosTowards(this.pathfinderMob, (int)10, (int)7, (Vec3)Vec3.atBottomCenterOf((Vec3i)this.homeGetter.apply(this.pathfinderMob).pos()), (double)1.5707963705062866) : DefaultRandomPos.getPos(this.pathfinderMob, (int)10, (int)7);
        if (vec3 != null) {
            this.wantedX = vec3.x;
            this.wantedY = vec3.y;
            this.wantedZ = vec3.z;
            this.forceTrigger = isBack;
            return true;
        }
        return false;
    }
}

