/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import ovh.corail.tombstone.gui.CycleButton;
import ovh.corail.tombstone.gui.IOption;

@OnlyIn(value=Dist.CLIENT)
public class CycleConfigOption<T>
implements IOption {
    private final Component caption;
    private final OptionSetter<T> setter;
    private final Supplier<T> getter;
    private final Supplier<CycleButton.Builder<T>> buttonSetup;
    private final BooleanConsumer dirty;
    private Function<Minecraft, CycleButton.TooltipSupplier<T>> tooltip = mc -> tooltip -> ImmutableList.of();

    private CycleConfigOption(String name, Supplier<T> getter, OptionSetter<T> setter, Supplier<CycleButton.Builder<T>> buttonSetup, BooleanConsumer dirty) {
        this.caption = Component.translatable((String)name);
        this.getter = getter;
        this.setter = setter;
        this.buttonSetup = buttonSetup;
        this.dirty = dirty;
    }

    public static <T> CycleConfigOption<T> create(String name, List<T> options, Function<T, Component> p_167740_, Supplier<T> getter, OptionSetter<T> setter, BooleanConsumer dirty) {
        return new CycleConfigOption<T>(name, getter, setter, () -> CycleButton.builder(p_167740_).withValues(options), dirty);
    }

    public static <T> CycleConfigOption<T> create(String name, Supplier<List<T>> supplierOptions, Function<T, Component> translation, Supplier<T> getter, OptionSetter<T> setter, BooleanConsumer dirty) {
        return new CycleConfigOption<T>(name, getter, setter, () -> CycleButton.builder(translation).withValues((List)supplierOptions.get()), dirty);
    }

    public static <T> CycleConfigOption<T> create(String name, List<T> options1, List<T> options2, BooleanSupplier supplierBool, Function<T, Component> translation, Supplier<T> getter, OptionSetter<T> setter, BooleanConsumer dirty) {
        return new CycleConfigOption<T>(name, getter, setter, () -> CycleButton.builder(translation).withValues(supplierBool, options1, options2), dirty);
    }

    public static <T> CycleConfigOption<T> create(String name, T[] options, Function<T, Component> translation, Supplier<T> getter, OptionSetter<T> setter, BooleanConsumer dirty) {
        return new CycleConfigOption<T>(name, getter, setter, () -> CycleButton.builder(translation).withValues(options), dirty);
    }

    public static CycleConfigOption<Boolean> createBinaryOption(String name, Component translationTrue, Component translationFalse, Supplier<Boolean> getter, OptionSetter<Boolean> setter, BooleanConsumer dirty) {
        return new CycleConfigOption<Boolean>(name, getter, setter, () -> CycleButton.booleanBuilder(translationTrue, translationFalse), dirty);
    }

    public static CycleConfigOption<Boolean> createOnOff(String name, Supplier<Boolean> getter, OptionSetter<Boolean> setter, BooleanConsumer dirty) {
        return new CycleConfigOption<Boolean>(name, getter, setter, CycleButton::onOffBuilder, dirty);
    }

    public static CycleConfigOption<Boolean> createOnOff(String name, Component translation, Supplier<Boolean> getter, OptionSetter<Boolean> setter, BooleanConsumer dirty) {
        return CycleConfigOption.createOnOff(name, getter, setter, dirty).setTooltip(mc -> tooltip -> mc.font.split((FormattedText)translation, 200));
    }

    public CycleConfigOption<T> setTooltip(Function<Minecraft, CycleButton.TooltipSupplier<T>> p_167774_) {
        this.tooltip = p_167774_;
        return this;
    }

    @Override
    public AbstractWidget createButton(int x, int y, int width) {
        CycleButton.TooltipSupplier<T> tooltipsupplier = this.tooltip.apply(Minecraft.getInstance());
        return this.buttonSetup.get().withTooltip(tooltipsupplier).withInitialValue(this.getter.get()).create(x, y, width, 14, this.getCaption(), (cycleButton, value) -> {
            this.setter.accept(value);
            this.dirty.accept(true);
        });
    }

    @Override
    public Component getCaption() {
        return this.caption;
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface OptionSetter<T> {
        public void accept(T var1);
    }
}

