/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.HashSet;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public final class CallbackHandler {
    private static final Queue<DelayedCallback> DELAYED_CALLBACKS = new ConcurrentLinkedQueue<DelayedCallback>();

    public static void addFastCallback(Runnable callback) {
        CallbackHandler.addCallback(0, callback);
    }

    public static void addCallback(int delay, Runnable callback) {
        CallbackHandler.addCallback(delay, callback, null);
    }

    public static void addCallback(int delay, Runnable callback, @Nullable String key) {
        DELAYED_CALLBACKS.add(new DelayedCallback(delay, callback, key));
    }

    public static void cancelCallback(String key) {
        DELAYED_CALLBACKS.removeIf(cb -> key.equals(cb.key));
    }

    public static void flushTasks() {
        for (DelayedCallback cb : DELAYED_CALLBACKS) {
            cb.task.run();
        }
        DELAYED_CALLBACKS.clear();
    }

    public static void tick() {
        if (DELAYED_CALLBACKS.isEmpty()) {
            return;
        }
        HashSet<DelayedCallback> toRemove = new HashSet<DelayedCallback>();
        for (DelayedCallback cb : DELAYED_CALLBACKS) {
            if (cb.delay.getAndDecrement() > 0) continue;
            cb.task.run();
            toRemove.add(cb);
        }
        DELAYED_CALLBACKS.removeAll(toRemove);
    }

    public static class DelayedCallback {
        final AtomicInteger delay;
        final Runnable task;
        @Nullable
        final String key;

        DelayedCallback(int delay, Runnable task, @Nullable String key) {
            this.delay = new AtomicInteger(delay);
            this.task = task;
            this.key = key;
        }
    }
}

