/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.authlib.GameProfile;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.CommandSource;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.Tags;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.capability.ProtectedEntityHandler;
import ovh.corail.tombstone.capability.ServantUndeadHandler;
import ovh.corail.tombstone.capability.TBPlayerCapabilityHandler;
import ovh.corail.tombstone.compatibility.CompatibilityIceberg;
import ovh.corail.tombstone.compatibility.CompatibilityToughAsNails;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.entity.GraveGuardian;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TamableType;
import ovh.corail.tombstone.network.CMessagePlayerCapSetWatcherKnowledge;
import ovh.corail.tombstone.network.CMessagePlayerCapSyncAlignment;
import ovh.corail.tombstone.network.CMessagePlayerCapSyncKnowledge;
import ovh.corail.tombstone.network.CMessagePlayerCapSyncPerks;
import ovh.corail.tombstone.network.CMessagePlayerProtection;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.perk.Perk;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModTags;
import ovh.corail.tombstone.registry.ModTriggers;

public final class EntityHelper {
    private static final String TOMBSTONE_PLAYER_TAG = "tb_player_tag";

    public static boolean isValidPlayer(@Nullable CommandSource sender) {
        Player player;
        return sender instanceof Player && !EntityHelper.isInvalidPlayer(player = (Player)sender);
    }

    public static boolean isValidPlayer(@Nullable Entity entity) {
        Player player;
        return entity instanceof Player && !EntityHelper.isInvalidPlayer(player = (Player)entity);
    }

    public static boolean isValidPlayer(@Nullable Player player) {
        return player != null && !EntityHelper.isInvalidPlayer(player);
    }

    public static boolean isValidServerPlayer(@Nullable Entity entity) {
        ServerPlayer serverPlayer;
        return entity instanceof ServerPlayer && !EntityHelper.isInvalidPlayer((Player)(serverPlayer = (ServerPlayer)entity));
    }

    public static boolean isValidServerPlayer(@Nullable ServerPlayer serverPlayer) {
        return serverPlayer != null && !EntityHelper.isInvalidPlayer((Player)serverPlayer);
    }

    public static boolean isInvalidPlayer(Player player) {
        return player.isFakePlayer() || CompatibilityIceberg.instance.isBrokenCode(player);
    }

    public static boolean checkInvalidPlayerForLoot(@Nullable ServerPlayer player) {
        try {
            if (player == null || EntityHelper.isInvalidPlayer((Player)player) || player.connection.getRemoteAddress() == null) {
                return true;
            }
            ServerPlayer existingPlayer = Optional.ofNullable(Helper.getServer()).map(s -> s.getPlayerList().getPlayer(player.getUUID())).orElse(null);
            return existingPlayer == null || !existingPlayer.position().equals((Object)player.position());
        }
        catch (Throwable t) {
            return true;
        }
    }

    public static boolean isKilledByOtherPlayer(Player player, DamageSource source) {
        return EntityHelper.isValidPlayer(source.getEntity()) && !player.equals((Object)source.getEntity());
    }

    public static void resetNutrition(ServerPlayer player) {
        FoodData foodData = player.getFoodData();
        foodData.setExhaustion(0.0f);
        foodData.setFoodLevel(20);
        if (SupportMods.TAN.isLoaded()) {
            CompatibilityToughAsNails.instance.resetThirst((Player)player);
        }
    }

    public static void setPlayerXp(Player player, int amount) {
        if (amount <= 0) {
            return;
        }
        player.experienceLevel = 0;
        player.totalExperience = 0;
        player.experienceProgress = 0.0f;
        player.experienceProgress += (float)amount / (float)player.getXpNeededForNextLevel();
        player.totalExperience += amount;
        while (player.experienceProgress >= 1.0f) {
            player.experienceProgress = (player.experienceProgress - 1.0f) * (float)player.getXpNeededForNextLevel();
            ++player.experienceLevel;
            player.experienceProgress /= (float)player.getXpNeededForNextLevel();
        }
    }

    public static Pair<Integer, Float> getPlayerXpPair(int experienceTotal) {
        float aExperience;
        if (experienceTotal <= 0) {
            return Pair.of((Object)0, (Object)Float.valueOf(0.0f));
        }
        int aExperienceLevel = 0;
        for (aExperience = (float)experienceTotal / (float)EntityHelper.xpBarCap(aExperienceLevel); aExperience >= 1.0f; aExperience /= (float)EntityHelper.xpBarCap(++aExperienceLevel)) {
            aExperience = (aExperience - 1.0f) * (float)EntityHelper.xpBarCap(aExperienceLevel);
        }
        return Pair.of((Object)aExperienceLevel, (Object)Float.valueOf(aExperience));
    }

    public static int getPlayerTotalXp(Player player) {
        return EntityHelper.getPlayerTotalXp(player.experienceLevel, player.experienceProgress);
    }

    private static int getPlayerTotalXp(int level, float bar) {
        int experienceTotal = level < 17 ? level * (level + 6) : (level < 32 ? level * (5 * level - 81) / 2 + 360 : level * (9 * level - 325) / 2 + 2220);
        return experienceTotal += Mth.floor((float)((float)EntityHelper.xpBarCap(level) * bar));
    }

    private static int xpBarCap(int level) {
        return level >= 30 ? 112 + (level - 30) * 9 : (level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2);
    }

    public static boolean noGlobalItemCooldown(@Nullable Player player, Item item) {
        return !EntityHelper.hasGlobalItemCooldown(player, item);
    }

    public static boolean noGlobalItemCooldown(@Nullable Player player, ItemStack stack) {
        return EntityHelper.noGlobalItemCooldown(player, stack.getItem());
    }

    public static boolean hasGlobalItemCooldown(@Nullable Player player, Item item) {
        return Optional.ofNullable(player).map(p -> p.getCooldowns().isOnCooldown(item)).orElse(true);
    }

    public static boolean hasGlobalItemCooldown(@Nullable Player player, ItemStack stack) {
        return EntityHelper.hasGlobalItemCooldown(player, stack.getItem());
    }

    public static void setGlobalItemCooldown(Player player, Item item, int ticks) {
        player.getCooldowns().addCooldown(item, ticks);
    }

    public static void setGlobalItemCooldown(Player player, ItemStack stack, int ticks) {
        EntityHelper.setGlobalItemCooldown(player, stack.getItem(), ticks);
    }

    public static void removeGlobalItemCooldown(@Nullable Player player, Item item) {
        Optional.ofNullable(player).ifPresent(p -> player.getCooldowns().removeCooldown(item));
    }

    public static void applyKillResult(DamageSource damageSource, LivingEntity killedEntity) {
        if (EntityHelper.isValidServerPlayer((Entity)killedEntity.lastHurtByPlayer)) {
            ServerPlayer player = (ServerPlayer)killedEntity.lastHurtByPlayer;
            assert (player != null);
            if (player.hasEffect(ModEffects.ghostly_shape) || player.hasEffect(ModEffects.diversion)) {
                killedEntity.setLastHurtByPlayer(null);
                return;
            }
            EntityType entityType = killedEntity.getType();
            if (entityType.is(ModTags.EntityTypes.DECREASE_ALIGNMENT)) {
                TBPlayerCapabilityHandler.rewardAlignment(player, (Integer)ConfigTombstone.alignment.pointsKillDecreasingAlignment.get());
                if (entityType == EntityType.VILLAGER) {
                    ModTriggers.killed_enough_villager.trigger(player);
                }
            } else if (entityType.is(ModTags.EntityTypes.INCREASE_ALIGNMENT) || entityType == EntityType.ZOMBIE && killedEntity.getPersistentData().getBoolean("siege")) {
                TBPlayerCapabilityHandler.rewardAlignment(player, (Integer)ConfigTombstone.alignment.pointsKillIncreasingAlignment.get());
                ModTriggers.killed_enough_raider.trigger(player);
            } else if (TamableType.isTamedBy((LivingEntity)player, killedEntity)) {
                TBPlayerCapabilityHandler.rewardAlignment(player, (Integer)ConfigTombstone.alignment.pointsKillTamedCreature.get());
            }
            if (EntityHelper.isUndead(killedEntity)) {
                ModTriggers.killed_enough_undead.trigger(player);
                if (EntityHelper.isBoss(killedEntity)) {
                    ModTriggers.kill_undead_boss.trigger(player);
                }
            }
        }
    }

    public static int getPerkLevelWithBonus(@Nullable Player player, @Nullable Perk perk) {
        return player == null ? 0 : TBPlayerCapabilityHandler.getPerkLevelWithBonus(player, perk);
    }

    public static void syncProtectedPlayerCapability(ServerPlayer player) {
        if (ProtectedEntityHandler.hasCapability((Entity)player)) {
            PacketHandler.sendToPlayer(new CMessagePlayerProtection(ProtectedEntityHandler.isActive((Entity)player)), player);
        }
    }

    public static void syncPlayerCapability(ServerPlayer player) {
        EntityHelper.syncPlayerCapability(player, false);
    }

    public static void syncPlayerCapability(ServerPlayer player, boolean checked) {
        int knowledge = TBPlayerCapabilityHandler.getKnowledge((Player)player);
        int alignment = TBPlayerCapabilityHandler.getAlignmentValue((Player)player);
        Map<Perk, Integer> perks = TBPlayerCapabilityHandler.getPerks((Player)player);
        if (checked) {
            int totalPerkPoints = TBPlayerCapabilityHandler.getTotalPerkPoints((Player)player);
            int spentPerkPoints = 0;
            List<Perk> sortedPerks = perks.keySet().stream().sorted(Comparator.comparingInt(Perk::getBranchTier)).toList();
            block0: for (Perk perk : sortedPerks) {
                if (perk.isDisabled((Player)player)) {
                    perks.remove(perk);
                    continue;
                }
                if (perk.getParent() != null && TBPlayerCapabilityHandler.getPerkLevel((Player)player, perk.getParent()) == 0) {
                    perks.remove(perk);
                    continue;
                }
                if (!EntityHelper.hasPerkBranchTierRequirement(perk, spentPerkPoints)) {
                    perks.remove(perk);
                    continue;
                }
                int perkLevel = TBPlayerCapabilityHandler.getPerkLevel((Player)player, perk);
                if (perkLevel > perk.getLevelMax()) {
                    perkLevel = perk.getLevelMax();
                    TBPlayerCapabilityHandler.setPerk((Player)player, perk, perkLevel);
                }
                for (int i = 1; i <= perkLevel; ++i) {
                    int cost = perk.getCost(i);
                    if (cost <= totalPerkPoints - spentPerkPoints) {
                        spentPerkPoints += cost;
                        continue;
                    }
                    if (i > 1) {
                        TBPlayerCapabilityHandler.setPerk((Player)player, perk, i - 1);
                        continue block0;
                    }
                    perks.remove(perk);
                    continue block0;
                }
            }
        }
        PacketHandler.sendToPlayer(new CMessagePlayerCapSyncKnowledge(knowledge), player);
        PacketHandler.sendToPlayer(new CMessagePlayerCapSyncAlignment(alignment), player);
        PacketHandler.sendToPlayer(new CMessagePlayerCapSyncPerks(perks), player);
        PacketHandler.sendToPlayer(new CMessagePlayerCapSetWatcherKnowledge(TBPlayerCapabilityHandler.getWatcherKnowledge((Player)player)), player);
    }

    public static boolean hasPerkBranchTierRequirement(Perk perk, int usedPerkPoints) {
        return perk.getBranchTier() < 2 || (perk.getBranchTier() - 1) * 5 <= usedPerkPoints;
    }

    public static CompoundTag getPersistentTag(Player player) {
        CompoundTag persistantData = player.getPersistentData();
        if (persistantData.contains("PlayerPersisted", 10)) {
            return persistantData.getCompound("PlayerPersisted");
        }
        CompoundTag persistantTag = new CompoundTag();
        persistantData.put("PlayerPersisted", (Tag)persistantTag);
        return persistantTag;
    }

    public static CompoundTag getTombstoneTag(Player player) {
        CompoundTag persistentTag = EntityHelper.getPersistentTag(player);
        if (persistentTag.contains(TOMBSTONE_PLAYER_TAG, 10)) {
            return persistentTag.getCompound(TOMBSTONE_PLAYER_TAG);
        }
        CompoundTag tombstonePlayerTag = new CompoundTag();
        persistentTag.put(TOMBSTONE_PLAYER_TAG, (Tag)tombstonePlayerTag);
        return tombstonePlayerTag;
    }

    public static void writePlayerData(MinecraftServer server, Player player) {
        server.getPlayerList().playerIo.save(player);
    }

    public static void loadPlayerData(MinecraftServer server, Player player) {
        server.getPlayerList().playerIo.load(player);
    }

    @Nullable
    public static ServerPlayer getOfflinePlayer(MinecraftServer server, UUID id) {
        GameProfile profil = EntityHelper.getGameProfile(server, id);
        if (profil != null) {
            ServerPlayer player = EntityHelper.getPlayerForLogin(server, profil);
            EntityHelper.loadPlayerData(server, (Player)player);
            return player;
        }
        return null;
    }

    @Nullable
    public static ServerPlayer getOfflinePlayer(MinecraftServer server, String playerName) {
        GameProfile profil = EntityHelper.getGameProfile(server, playerName);
        if (profil != null) {
            ServerPlayer player = EntityHelper.getPlayerForLogin(server, profil);
            EntityHelper.loadPlayerData(server, (Player)player);
            return player;
        }
        return null;
    }

    @Nullable
    public static GameProfile getGameProfile(MinecraftServer server, UUID id) {
        return server.getProfileCache().get(id).orElse(null);
    }

    @Nullable
    public static GameProfile getGameProfile(MinecraftServer server, String playerName) {
        GameProfileCache.GameProfileInfo entry = (GameProfileCache.GameProfileInfo)server.getProfileCache().profilesByName.get(playerName.toLowerCase(Locale.ROOT));
        if (entry != null) {
            return entry.getProfile();
        }
        return null;
    }

    public static ServerPlayer getPlayerForLogin(MinecraftServer server, GameProfile profil) {
        return server.getPlayerList().getPlayerForLogin(profil, ClientInformation.createDefault());
    }

    public static boolean isUndead(LivingEntity entity) {
        return entity.getType().is(EntityTypeTags.UNDEAD);
    }

    public static boolean isBoss(LivingEntity entity) {
        return entity.getType().is(Tags.EntityTypes.BOSSES);
    }

    public static boolean targetAnEnemy(LivingEntity entity) {
        Mob mob;
        return entity instanceof Mob && EntityHelper.isEnemy((Entity)(mob = (Mob)entity).getTarget());
    }

    public static void resetAttackAction(LivingEntity entity) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.goalSelector.getAvailableGoals().stream().filter(WrappedGoal::isRunning).forEach(WrappedGoal::stop);
            mob.targetSelector.getAvailableGoals().stream().filter(WrappedGoal::isRunning).forEach(WrappedGoal::stop);
            mob.getNavigation().stop();
            mob.target = null;
        }
        entity.setLastHurtByMob(null);
        entity.setLastHurtByPlayer(null);
        entity.setLastHurtMob(null);
        if (entity.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET)) {
            entity.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, Optional.empty());
        }
    }

    public static boolean areOwnerOrServants(LivingEntity entity1, LivingEntity entity2) {
        return EntityHelper.getOwnerOrSelfId(entity1).equals(EntityHelper.getOwnerOrSelfId(entity2));
    }

    private static UUID getOwnerOrSelfId(LivingEntity entity) {
        return Optional.ofNullable(TamableType.getType(entity)).map(t -> t.getOwnerId(entity)).orElse(entity.getUUID());
    }

    public static boolean isEnemy(@Nullable Entity entity) {
        TamableAnimal tamable;
        return entity instanceof Enemy && !EntityHelper.isServant(entity) && (!(entity instanceof TamableAnimal) || !(tamable = (TamableAnimal)entity).isTame());
    }

    public static boolean isServant(Entity entity) {
        return ServantUndeadHandler.hasCapability(entity) && ServantUndeadHandler.hasOwner(entity);
    }

    public static Optional<UUID> getServantOwnerId(Entity entity) {
        return ServantUndeadHandler.getOwnerId(entity);
    }

    public static Optional<Player> getServantOwner(Entity entity) {
        return EntityHelper.getServantOwnerId(entity).flatMap(ownerId -> Optional.ofNullable(entity.level().getPlayerByUUID(ownerId)));
    }

    public static boolean noGraveGuardianAround(Level level, BlockPos pos) {
        return level.getEntitiesOfClass(GraveGuardian.class, new AABB(pos).inflate((double)((Integer)ConfigTombstone.decorative_grave.distanceBetweenGraveGuardian.get()).intValue(), 20.0, (double)((Integer)ConfigTombstone.decorative_grave.distanceBetweenGraveGuardian.get()).intValue()), entity -> true).isEmpty();
    }

    public static int getCustomStat(ServerPlayer serverPlayer, ResourceLocation statRL) {
        return EntityHelper.getStat(serverPlayer, Stats.CUSTOM.get((Object)statRL));
    }

    public static int getStat(ServerPlayer serverPlayer, Stat<?> stat) {
        return serverPlayer.getStats().getValue(stat);
    }

    public static void increaseCustomStat(ServerPlayer serverPlayer, ResourceLocation statRL, int count) {
        EntityHelper.increaseStat(serverPlayer, Stats.CUSTOM.get((Object)statRL), count);
    }

    public static void setCustomStat(ServerPlayer serverPlayer, ResourceLocation statRL, int count) {
        EntityHelper.setStat(serverPlayer, Stats.CUSTOM.get((Object)statRL), count);
    }

    public static void increaseStat(ServerPlayer serverPlayer, Stat<?> stat, int count) {
        EntityHelper.setStat(serverPlayer, stat, EntityHelper.getStat(serverPlayer, stat) + count);
    }

    public static void setStat(ServerPlayer serverPlayer, Stat<?> stat, int count) {
        serverPlayer.getStats().setValue((Player)serverPlayer, stat, count);
    }
}

