/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.serialization.DynamicOps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.perk.Perk;
import ovh.corail.tombstone.perk.PerkRegistry;

public final class NBTStackHelper {
    public static String getString(@Nullable CompoundTag tag, String keyName) {
        return Optional.ofNullable(tag).filter(t -> t.contains(keyName, 8)).map(t -> t.getString(keyName)).orElse("");
    }

    public static boolean getBoolean(@Nullable CompoundTag tag, String keyName) {
        return Optional.ofNullable(tag).filter(t -> t.contains(keyName, 1)).map(t -> t.getBoolean(keyName)).orElse(false);
    }

    public static void setUUID(CompoundTag tag, String keyName, @Nullable UUID uuid) {
        if (uuid != null) {
            tag.putUUID(keyName, uuid);
        }
    }

    public static Optional<UUID> getUUID(CompoundTag tag, String keyName) {
        return Optional.of(tag).filter(t -> t.hasUUID(keyName)).map(t -> t.getUUID(keyName));
    }

    public static void setBlockPos(CompoundTag tag, String keyName, BlockPos keyValue) {
        tag.putInt(keyName + "_x", keyValue.getX());
        tag.putInt(keyName + "_y", keyValue.getY());
        tag.putInt(keyName + "_z", keyValue.getZ());
    }

    public static Optional<BlockPos> getBlockPos(@Nullable CompoundTag tag, String keyName) {
        if (tag != null && tag.contains(keyName + "_x", 3) && tag.contains(keyName + "_y", 3) && tag.contains(keyName + "_z", 3)) {
            return Optional.of(new BlockPos(tag.getInt(keyName + "_x"), tag.getInt(keyName + "_y"), tag.getInt(keyName + "_z")));
        }
        return Optional.empty();
    }

    public static CompoundTag setLocation(CompoundTag tag, String keyName, Location location) {
        NBTStackHelper.setBlockPos(tag, keyName, location.getPos());
        NBTStackHelper.setWorldKey(tag, keyName + "_dim", location.dim);
        return tag;
    }

    public static Location getLocation(@Nullable CompoundTag tag, String keyName) {
        ResourceKey<Level> worldKey;
        BlockPos pos;
        if (tag != null && (pos = (BlockPos)NBTStackHelper.getBlockPos(tag, keyName).orElse(null)) != null && (worldKey = NBTStackHelper.getWorldKey(tag, keyName + "_dim")) != null) {
            return new Location(pos, worldKey);
        }
        return Location.ORIGIN;
    }

    public static CompoundTag setGlobalPos(CompoundTag tag, String keyName, GlobalPos globalPos) {
        GlobalPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)globalPos).result().ifPresent(pos -> tag.put(keyName, pos));
        return tag;
    }

    @Nullable
    public static GlobalPos getGlobalPos(@Nullable CompoundTag tag, String keyName) {
        if (tag != null && tag.contains(keyName)) {
            return GlobalPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(keyName)).result().orElse(null);
        }
        return null;
    }

    public static CompoundTag setWorldKey(CompoundTag tag, String keyName, ResourceKey<Level> worldKey) {
        Level.RESOURCE_KEY_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, worldKey).result().ifPresent(rl -> tag.put(keyName, rl));
        return tag;
    }

    @Nullable
    public static ResourceKey<Level> getWorldKey(@Nullable CompoundTag tag, String keyName) {
        if (tag != null && tag.contains(keyName)) {
            return Level.RESOURCE_KEY_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(keyName)).result().orElse(null);
        }
        return null;
    }

    public static List<MobEffectInstance> getEffectList(CompoundTag tag, String keyName, Predicate<MobEffect> predic) {
        return NBTStackHelper.getListOrEmpty(tag, keyName).map(effectList -> IntStream.range(0, effectList.size()).mapToObj(arg_0 -> ((ListTag)effectList).getCompound(arg_0)).map(nbt -> NBTStackHelper.getEffect(nbt, predic)).filter(Objects::nonNull).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public static void setEffectlist(CompoundTag tag, String keyName, Stream<MobEffectInstance> effectInstances) {
        ListTag effectList = new ListTag();
        effectInstances.forEach(effectInstance -> effectList.add((Object)effectInstance.save()));
        tag.put(keyName, (Tag)effectList);
    }

    @Nullable
    private static MobEffectInstance getEffect(CompoundTag tag, Predicate<MobEffect> predic) {
        return Optional.ofNullable(MobEffectInstance.load((CompoundTag)tag)).filter(e -> predic.test((MobEffect)e.getEffect().value())).orElse(null);
    }

    public static Optional<MobEffectInstance> getEffect(@Nullable CompoundTag tag, String keyName) {
        return tag != null ? MobEffectInstance.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(keyName)).result() : Optional.empty();
    }

    public static void setEffect(CompoundTag tag, String keyName, MobEffectInstance mobEffectInstance) {
        MobEffectInstance.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)mobEffectInstance).result().ifPresent(rl -> tag.put(keyName, rl));
    }

    public static ListTag getListOrCreate(CompoundTag tag, String keyName) {
        ListTag tagList;
        if (tag.contains(keyName, 9) && !(tagList = tag.getList(keyName, 10)).isEmpty()) {
            return tagList;
        }
        ListTag list = new ListTag();
        tag.put(keyName, (Tag)list);
        return list;
    }

    public static Optional<ListTag> getListOrEmpty(CompoundTag tag, String keyName) {
        return Optional.of(tag).filter(t -> t.contains(keyName, 9)).map(t -> t.getList(keyName, 10)).filter(t -> !t.isEmpty());
    }

    public static void readPerks(Map<Perk, Integer> perks, CompoundTag tag) {
        NBTStackHelper.getListOrEmpty(tag, "perks").ifPresent(tagPerks -> {
            for (int i = 0; i < tagPerks.size(); ++i) {
                int perkLevel;
                Perk perk;
                CompoundTag tagPerk = tagPerks.getCompound(i);
                if (!tagPerk.contains("id", 8) || !tagPerk.contains("level", 1) || (perk = PerkRegistry.getValue(tagPerk.getString("id"))) == null || perk.isDisabled(null) || (perkLevel = tagPerk.getByte("level") & 0xFF) <= 0) continue;
                perks.put(perk, Math.min(perk.getLevelMax(), perkLevel));
            }
        });
    }

    public static void writePerks(Map<Perk, Integer> perks, CompoundTag tag) {
        ListTag tagPerks = new ListTag();
        tag.put("perks", (Tag)tagPerks);
        perks.forEach((perk, perklevel) -> {
            if (perk != null && perklevel > 0 && !perk.isDisabled(null)) {
                CompoundTag tagPerk = new CompoundTag();
                tagPerk.putString("id", PerkRegistry.getStringKey(perk));
                tagPerk.putByte("level", (byte)Math.min(perk.getLevelMax(), perklevel));
                tagPerks.add((Object)tagPerk);
            }
        });
    }
}

