/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.mojang.serialization.MapCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.registry.ModLootConditions;

public class CheckPlayerCondition
implements LootItemCondition {
    public static final ResourceLocation RL = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"check_player");
    private static final CheckPlayerCondition INSTANCE = new CheckPlayerCondition();
    public static final MapCodec<CheckPlayerCondition> CODEC = MapCodec.unit((Object)INSTANCE);

    private CheckPlayerCondition() {
    }

    public LootItemConditionType getType() {
        return ModLootConditions.CHECK_PLAYER;
    }

    public boolean test(LootContext context) {
        Object object;
        if (context.hasParam(LootContextParams.THIS_ENTITY) && (object = context.getParam(LootContextParams.THIS_ENTITY)) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)object;
            return !EntityHelper.checkInvalidPlayerForLoot(serverPlayer);
        }
        if (context.hasParam(LootContextParams.ATTACKING_ENTITY) && (object = context.getParam(LootContextParams.ATTACKING_ENTITY)) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)object;
            return !EntityHelper.checkInvalidPlayerForLoot(serverPlayer);
        }
        return false;
    }

    public static LootItemCondition.Builder builder() {
        return () -> INSTANCE;
    }
}

