/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.mixin;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LootHelper;
import ovh.corail.tombstone.helper.UpdaterHandler;

@Mixin(value={BrushableBlockEntity.class})
public abstract class BrushableBlockEntityMixin
extends BlockEntity {
    @Shadow
    ResourceKey<LootTable> lootTable;
    @Shadow
    ItemStack item;
    @Shadow
    long lootTableSeed;

    private BrushableBlockEntityMixin(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    @Inject(method={"unpackLootTable"}, at={@At(value="RETURN")}, cancellable=true)
    private void methodUnpackLootTable(Player player, CallbackInfo callbackInfo) {
        if (this.lootTable != null && this.level != null && !this.level.isClientSide() && this.level.getServer() != null && Helper.RANDOM.nextBoolean()) {
            LootParams lootParams = new LootParams.Builder((ServerLevel)this.level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)this.worldPosition)).withLuck(player.getLuck()).withParameter(LootContextParams.THIS_ENTITY, (Object)player).create(LootContextParamSets.CHEST);
            this.item = LootHelper.getLootTable(UpdaterHandler.PoolType.ARCHAEOLOGY).getRandomItems(lootParams).stream().findFirst().orElse(ItemStack.EMPTY);
            if (!this.item.isEmpty()) {
                if (EntityHelper.isValidServerPlayer((Entity)player)) {
                    CriteriaTriggers.GENERATE_LOOT.trigger((ServerPlayer)player, this.lootTable);
                }
                this.lootTable = null;
                this.setChanged();
                callbackInfo.cancel();
            }
        }
    }
}

