/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.mixin;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModDamages;

@Mixin(value={DamageSources.class}, priority=1031)
public class DamageSourcesMixin {
    @Inject(method={"arrow"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodArrow(AbstractArrow arrow, @Nullable Entity shooter, CallbackInfoReturnable<DamageSource> callbackInfoReturnable) {
        LivingEntity livingEntity;
        if (shooter instanceof LivingEntity && Helper.hasSanctifiedEnchantment(livingEntity = (LivingEntity)shooter)) {
            callbackInfoReturnable.setReturnValue((Object)ModDamages.sourceHoly((Entity)livingEntity));
        }
    }

    @Inject(method={"trident"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodTrident(Entity trident, @Nullable Entity thrower, CallbackInfoReturnable<DamageSource> callbackInfoReturnable) {
        LivingEntity livingEntity;
        if (thrower instanceof LivingEntity && Helper.hasSanctifiedEnchantment(livingEntity = (LivingEntity)thrower)) {
            callbackInfoReturnable.setReturnValue((Object)ModDamages.sourceHoly((Entity)livingEntity));
        }
    }

    @Inject(method={"playerAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodPlayerAttack(Player player, CallbackInfoReturnable<DamageSource> callbackInfoReturnable) {
        if (EntityHelper.isValidPlayer(player) && Helper.hasSanctifiedEnchantment((LivingEntity)player)) {
            callbackInfoReturnable.setReturnValue((Object)ModDamages.sourceHoly((Entity)player));
        }
    }

    @Inject(method={"mobAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodMobAttack(LivingEntity livingEntity, CallbackInfoReturnable<DamageSource> callbackInfoReturnable) {
        if (livingEntity != null && Helper.hasSanctifiedEnchantment(livingEntity)) {
            callbackInfoReturnable.setReturnValue((Object)ModDamages.sourceHoly((Entity)livingEntity));
        }
    }
}

