/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.capability.TBPlayerCapabilityHandler;
import ovh.corail.tombstone.gui.ScreenKnowledge;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.perk.Perk;
import ovh.corail.tombstone.perk.PerkRegistry;

public record CMessagePlayerCapRemovePerk(@Nullable Perk perk) implements CustomPacketPayload
{
    static final StreamCodec<RegistryFriendlyByteBuf, CMessagePlayerCapRemovePerk> STREAM_CODEC = StreamCodec.ofMember(CMessagePlayerCapRemovePerk::encode, CMessagePlayerCapRemovePerk::decode);
    static final CustomPacketPayload.Type<CMessagePlayerCapRemovePerk> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"player_cap_remove_perk"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static CMessagePlayerCapRemovePerk decode(RegistryFriendlyByteBuf buf) {
        return new CMessagePlayerCapRemovePerk(PerkRegistry.getValue(buf.readUtf()));
    }

    static void encode(CMessagePlayerCapRemovePerk msg, RegistryFriendlyByteBuf buf) {
        buf.writeUtf(PerkRegistry.getStringKey(msg.perk));
    }

    static void handle(CMessagePlayerCapRemovePerk msg, IPayloadContext ctx) {
        if (msg.perk != null) {
            ProxyHelper.getClientPlayer().ifPresent(player -> {
                TBPlayerCapabilityHandler.removePerk(player, msg.perk);
                Minecraft mc = Minecraft.getInstance();
                Screen patt0$temp = mc.screen;
                if (patt0$temp instanceof ScreenKnowledge) {
                    ScreenKnowledge screen = (ScreenKnowledge)patt0$temp;
                    screen.updatePerkIcons();
                }
            });
        }
    }
}

