/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import ovh.corail.tombstone.capability.FriendlyAnimalHandler;
import ovh.corail.tombstone.capability.ServantUndeadHandler;
import ovh.corail.tombstone.helper.ProxyHelper;

public record CMessageServant(int entityId, UUID uuid, boolean isServant) implements CustomPacketPayload
{
    static final StreamCodec<RegistryFriendlyByteBuf, CMessageServant> STREAM_CODEC = StreamCodec.ofMember(CMessageServant::encode, CMessageServant::decode);
    static final CustomPacketPayload.Type<CMessageServant> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"servant"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static CMessageServant decode(RegistryFriendlyByteBuf buf) {
        return new CMessageServant(buf.readVarInt(), buf.readUUID(), buf.readBoolean());
    }

    static void encode(CMessageServant msg, RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(msg.entityId);
        buf.writeUUID(msg.uuid);
        buf.writeBoolean(msg.isServant);
    }

    static void handle(CMessageServant msg, IPayloadContext ctx) {
        ProxyHelper.getClientWorld().map(level -> level.getEntity(msg.entityId)).ifPresent(entity -> {
            if (msg.isServant) {
                if (ServantUndeadHandler.hasCapability(entity)) {
                    ServantUndeadHandler.setOwnerId(entity, msg.uuid);
                }
            } else if (FriendlyAnimalHandler.hasCapability(entity)) {
                FriendlyAnimalHandler.setOwnerId(entity, msg.uuid);
            }
        });
    }
}

