/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.particle.CustomParticle;
import ovh.corail.tombstone.particle.ParticleRenderTypes;

@OnlyIn(value=Dist.CLIENT)
public final class ParticleMagicCircle
extends CustomParticle {
    private static final Quaternionf QUATERNION_ONE = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
    private static final double HEIGHT = 0.13;
    private final WeakReference<LivingEntity> entityWeakReference;
    private final Predicate<LivingEntity> requireRemoval;

    public ParticleMagicCircle(ClientLevel level, CastingType castingType, LivingEntity entity, Predicate<LivingEntity> requireRemoval) {
        super(level, entity.getX(), entity.getY() + 0.13, entity.getZ());
        this.entityWeakReference = new WeakReference<LivingEntity>(entity);
        this.requireRemoval = requireRemoval;
        this.scale((float)(castingType.radius * 5.0));
        this.setRolling(0.0f, 0.009738938f);
        this.setColor(castingType.r, castingType.g, castingType.b);
        this.setAlpha(0.5f);
    }

    @Override
    protected void updatePosition() {
        Optional.ofNullable((LivingEntity)this.entityWeakReference.get()).ifPresent(e -> this.setPos(e.getX(), e.getY() + 0.13, e.getZ()));
    }

    @Override
    protected boolean requireRemoval() {
        return Optional.ofNullable((LivingEntity)this.entityWeakReference.get()).map(this.requireRemoval::test).orElse(true);
    }

    @Override
    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        if (this.age > 1) {
            super.render(buffer, renderInfo, partialTicks);
        }
    }

    @Override
    protected Quaternionf getRollQuaternion(Camera renderInfo, float partialTicks) {
        if (this.roll == 0.0f) {
            return QUATERNION_ONE;
        }
        Quaternionf rollTransform = new Quaternionf((Quaternionfc)QUATERNION_ONE);
        rollTransform.mul((Quaternionfc)Axis.YP.rotation(Mth.lerp((float)partialTicks, (float)this.oRoll, (float)this.roll)));
        return rollTransform;
    }

    @Override
    protected Vector3f[] getFaceQuad() {
        return new Vector3f[]{new Vector3f(1.0f, 0.0f, -1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(-1.0f, 0.0f, 1.0f), new Vector3f(-1.0f, 0.0f, -1.0f)};
    }

    @Override
    protected void addQuad(VertexConsumer buffer, Vector3f[] points, int light) {
        super.addQuad(buffer, points, light);
        super.addQuad(buffer, new Vector3f[]{points[3], points[2], points[1], points[0]}, light);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderTypes.AURA;
    }
}

