/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import ovh.corail.tombstone.capability.TBPlayerCapabilityHandler;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.perk.Perk;
import ovh.corail.tombstone.perk.PerkBranch;

public final class PerkNecromancer
extends Perk {
    public PerkNecromancer(String name, PerkBranch branch, int branchTier, Supplier<ItemStack> icon) {
        super(name, branch, branchTier, icon);
    }

    @Override
    public int getLevelMax() {
        return 5;
    }

    @Override
    protected boolean hasRequiredAlignment(@Nullable Player player) {
        return player == null || TBPlayerCapabilityHandler.getAlignmentLevel(player) < 0;
    }

    @Override
    public int getCost(int level) {
        return Math.max((int)1, (int)(level - 2));
    }

    @Override
    public Component getCurrentBonusInfo(int level) {
        return Component.literal((String)("+" + level * 20 + "% ")).append((Component)Component.translatable((String)(this.getTranslationKey() + ".bonus")));
    }

    @Override
    public int getLevelBonus(Player player) {
        return TimeHelper.isDateAroundHalloween() ? 5 : 0;
    }
}

