/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.summon;

import alexthw.ars_elemental.registry.ModEntities;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.SummonHorse;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SummonCamel
extends Camel
implements ISummon {
    public int ticksLeft;

    public SummonCamel(SummonHorse oldHorse, Player summoner) {
        this(summoner.level());
        BlockPos position = oldHorse.blockPosition();
        this.setPos(position.getX(), position.getY(), position.getZ());
        this.ticksLeft = oldHorse.getTicksLeft();
        this.tameWithName(summoner);
        this.getHorseInventory().setItem(0, new ItemStack((ItemLike)Items.SADDLE));
        this.setOwnerID(summoner.getUUID());
        this.setDropChance(EquipmentSlot.CHEST, 0.0f);
        oldHorse.getActiveEffects().stream().filter(e -> ((MobEffect)e.getEffect().value()).isBeneficial()).forEach(arg_0 -> ((SummonCamel)this).addEffect(arg_0));
    }

    public SummonCamel(Level level) {
        super((EntityType)ModEntities.CAMEL_SUMMON.get(), level);
    }

    public SummonCamel(EntityType<? extends Camel> type, Level worldIn) {
        super(type, worldIn);
    }

    @NotNull
    public EntityType<?> getType() {
        return (EntityType)ModEntities.CAMEL_SUMMON.get();
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            --this.ticksLeft;
            if (this.ticksLeft <= 0) {
                ParticleUtil.spawnPoof((ServerLevel)((ServerLevel)this.level()), (BlockPos)this.blockPosition());
                this.remove(Entity.RemovalReason.DISCARDED);
                this.onSummonDeath(this.level(), null, true);
            }
        }
    }

    public void die(@NotNull DamageSource cause) {
        super.die(cause);
        this.onSummonDeath(this.level(), cause, false);
    }

    public boolean canTakeItem(@NotNull ItemStack itemstackIn) {
        return false;
    }

    protected void dropEquipment() {
    }

    public int getBaseExperienceReward() {
        return 0;
    }

    public SimpleContainer getHorseInventory() {
        return this.inventory;
    }

    public void openCustomInventoryScreen(@NotNull Player playerEntity) {
    }

    public boolean canMate(@NotNull Animal otherAnimal) {
        return false;
    }

    public boolean canBreed() {
        return false;
    }

    public boolean isFood(@NotNull ItemStack stack) {
        return false;
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.ticksLeft = compound.getInt("left");
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("left", this.ticksLeft);
        this.writeOwner(compound);
    }

    public int getTicksLeft() {
        return this.ticksLeft;
    }

    public void setTicksLeft(int ticks) {
        this.ticksLeft = ticks;
    }

    public void setOwnerID(UUID uuid) {
        this.setOwnerUUID(uuid);
    }
}

