/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.items.foci;

import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.common.glyphs.EffectPhantom;
import alexthw.ars_elemental.common.glyphs.MethodHomingProjectile;
import alexthw.ars_elemental.common.items.ElementalCurio;
import com.alexthw.sauce.api.IUndeadSummon;
import com.alexthw.sauce.api.item.ISchoolFocus;
import com.alexthw.sauce.util.ParticleUtil;
import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHeal;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSummonUndead;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="ars_elemental")
public class NecroticFocus
extends ElementalCurio
implements ISchoolFocus {
    public NecroticFocus(Item.Properties properties) {
        super(properties);
    }

    public double getDiscount() {
        return (Double)ConfigHandler.COMMON.MajorFocusDiscount.get();
    }

    public SpellSchool getSchool() {
        return SpellSchools.NECROMANCY;
    }

    public static void spawnDeathPoof(ServerLevel world, BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            double d0 = (double)pos.getX() + 0.5;
            double d1 = (double)pos.getY() + 1.2;
            double d2 = (double)pos.getZ() + 0.5;
            world.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, d0, d1, d2, 2, ((double)world.random.nextFloat() - 0.5) / 3.0, ((double)world.random.nextFloat() - 0.5) / 3.0, ((double)world.random.nextFloat() - 0.5) / 3.0, (double)0.1f);
        }
    }

    public static boolean hasFocus(Level level, Entity entity) {
        IItemHandlerModifiable curios;
        if (!level.isClientSide && entity instanceof Player && (curios = CuriosUtil.getAllWornItems((LivingEntity)((LivingEntity)entity))) != null) {
            return IntStream.range(0, curios.getSlots()).anyMatch(i -> curios.getStackInSlot(i).getItem() instanceof NecroticFocus);
        }
        return false;
    }

    public SpellStats.Builder applyItemModifiers(ItemStack stack, SpellStats.Builder builder, AbstractSpellPart spellPart, HitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellContext spellContext) {
        builder.addDamageModifier(1.0);
        if (SpellSchools.NECROMANCY.isPartOfSchool(spellPart)) {
            builder.addDurationModifier(2.0);
            if (spellPart == EffectHeal.INSTANCE || spellPart == EffectPhantom.INSTANCE || spellPart == EffectSummonUndead.INSTANCE) {
                builder.addAmplification(2.0);
            }
        }
        return builder;
    }

    @SubscribeEvent
    public static void lifeSteal(LivingDeathEvent event) {
        IUndeadSummon risen;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof IUndeadSummon && (risen = (IUndeadSummon)entity).getOwnerUUID() != null && (entity = event.getEntity().level()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)entity;
            Player player = event.getEntity().level().getPlayerByUUID(risen.getOwnerUUID());
            if (player != null) {
                player.heal(2.0f);
                level.addFreshEntity((Entity)new EntityFollowProjectile((Level)level, risen.getLivingEntity().blockPosition(), player.blockPosition(), ParticleUtil.soulColor.toWrapper()));
            }
        }
    }

    @SubscribeEvent
    public static void castSpell(SpellCastEvent event) {
        Object object = event.getWorld();
        if (object instanceof ServerLevel) {
            Player player;
            ServerLevel world = (ServerLevel)object;
            object = event.getEntity();
            if (object instanceof Player && NecroticFocus.hasFocus((Level)world, (Entity)(player = (Player)object)) && event.spell.getCastMethod() == MethodHomingProjectile.INSTANCE) {
                for (Mob i : world.getEntitiesOfClass(Mob.class, new AABB(event.getEntity().blockPosition()).inflate(30.0), l -> {
                    if (!(l instanceof IUndeadSummon)) return false;
                    IUndeadSummon summon = (IUndeadSummon)l;
                    if (!player.getUUID().equals(summon.getOwnerUUID())) return false;
                    return true;
                })) {
                    LivingEntity target = i.getTarget();
                    if (target == null) {
                        target = player.getLastHurtMob();
                    }
                    if (target != null && target.isAlive()) {
                        i.getLookControl().setLookAt((Entity)target);
                    } else {
                        i.getLookControl().setLookAt(player.getViewVector(1.0f));
                    }
                    EntitySpellResolver spellResolver = new EntitySpellResolver(event.context.clone().withWrappedCaster((IWrappedCaster)new LivingCaster((LivingEntity)i)));
                    spellResolver.onCast(ItemStack.EMPTY, (Level)world);
                }
            }
        }
    }

    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext context, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.appendHoverText(pStack, context, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.translatable((String)"tooltip.ars_elemental.focus_boost", (Object[])new Object[]{SpellSchools.NECROMANCY.getTextComponent()}));
        pTooltipComponents.add((Component)Component.translatable((String)"tooltip.ars_elemental.focus_anima"));
    }
}

