/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.network;

import alexthw.ars_elemental.registry.ModParticles;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.client.particle.ColoredDynamicTypeData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import com.hollingsworth.arsnouveau.common.network.Networking;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class DischargeEffectPacket
extends AbstractPacket {
    public Vec3 from;
    public Vec3 to;
    public ParticleColor color;
    public static final CustomPacketPayload.Type<DischargeEffectPacket> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix((String)"discharge_effect"));
    public static final StreamCodec<RegistryFriendlyByteBuf, DischargeEffectPacket> CODEC = StreamCodec.ofMember(DischargeEffectPacket::encode, DischargeEffectPacket::decode);

    public DischargeEffectPacket(Vec3 from, Vec3 to, ParticleColor colors) {
        this.from = from;
        this.to = to;
        this.color = colors;
    }

    public static void encode(DischargeEffectPacket msg, FriendlyByteBuf buf) {
        DischargeEffectPacket.encodePos(buf, msg.from);
        DischargeEffectPacket.encodePos(buf, msg.to);
        buf.writeInt(msg.color.getColor());
    }

    public static void encodePos(@Nonnull FriendlyByteBuf buf, @Nonnull Vec3 item) {
        buf.writeDouble(item.x);
        buf.writeDouble(item.y);
        buf.writeDouble(item.z);
    }

    public static DischargeEffectPacket decode(FriendlyByteBuf buf) {
        Vec3 from = DischargeEffectPacket.decodeVector3d(buf);
        Vec3 to = DischargeEffectPacket.decodeVector3d(buf);
        int colors = buf.readInt();
        return new DischargeEffectPacket(from, to, ParticleColor.fromInt((int)colors));
    }

    public static Vec3 decodeVector3d(@Nonnull FriendlyByteBuf buf) {
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        return new Vec3(x, y, z);
    }

    public static void send(@Nonnull Level level, @Nonnull ParticleColor spellColor, @Nonnull Vec3 fromPoint, @Nonnull Vec3 hitPoint) {
        Vec3 midpoint = fromPoint.add(hitPoint).scale(0.5);
        double radius = 64.0 + fromPoint.distanceTo(midpoint);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            DischargeEffectPacket fx = new DischargeEffectPacket(fromPoint, hitPoint, spellColor);
            Networking.sendToNearbyClient((Level)serverLevel, (BlockPos)BlockPos.containing((Position)hitPoint), (CustomPacketPayload)fx);
        }
    }

    public void onClientReceived(Minecraft minecraft, Player player) {
        if (player != null) {
            Level level = player.level();
            double distance = this.from.distanceTo(this.to);
            double start = 0.0;
            double increment = 0.25;
            if (player.position().distanceToSqr(this.from) < 4.0 && this.to.subtract(this.from).normalize().dot(player.getViewVector(1.0f)) > (double)(Mth.SQRT_OF_TWO / 2.0f)) {
                start = Math.min(2.0, distance / 2.0);
                increment = 0.125;
            }
            for (double d = start; d < distance; d += increment) {
                double fractionalDistance = d / distance;
                double speedCoefficient = Mth.lerp((double)fractionalDistance, (double)0.2, (double)0.001);
                level.addParticle((ParticleOptions)new ColoredDynamicTypeData((ParticleType)com.hollingsworth.arsnouveau.client.registry.ModParticles.SPARKLE_TYPE.get(), this.color, 0.5f, 10), Mth.lerp((double)fractionalDistance, (double)this.from.x, (double)this.to.x), Mth.lerp((double)fractionalDistance, (double)this.from.y, (double)this.to.y) + 0.5, Mth.lerp((double)fractionalDistance, (double)this.from.z, (double)this.to.z), ((double)level.random.nextFloat() - 0.25) * speedCoefficient, ((double)level.random.nextFloat() - 0.25) * speedCoefficient, ((double)level.random.nextFloat() - 0.25) * speedCoefficient);
                level.addParticle((ParticleOptions)ModParticles.SPARK.get(), Mth.lerp((double)fractionalDistance, (double)this.from.x, (double)this.to.x), Mth.lerp((double)fractionalDistance, (double)this.from.y, (double)this.to.y) + 0.5, Mth.lerp((double)fractionalDistance, (double)this.from.z, (double)this.to.z), ((double)level.random.nextFloat() - 0.5) * speedCoefficient, ((double)level.random.nextFloat() - 0.5) * speedCoefficient, ((double)level.random.nextFloat() - 0.5) * speedCoefficient);
            }
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

