/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.registry;

import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.client.PrismRenderer;
import alexthw.ars_elemental.common.blocks.EverfullUrnBlock;
import alexthw.ars_elemental.common.blocks.SporeBlossomGround;
import alexthw.ars_elemental.common.blocks.mermaid_block.MermaidRock;
import alexthw.ars_elemental.common.blocks.prism.AccelerationPrismLens;
import alexthw.ars_elemental.common.blocks.prism.AdvancedPrism;
import alexthw.ars_elemental.common.blocks.prism.ArcPrismLens;
import alexthw.ars_elemental.common.blocks.prism.ChainingPrismLens;
import alexthw.ars_elemental.common.blocks.prism.DecelerationPrismLens;
import alexthw.ars_elemental.common.blocks.prism.HomingPrismLens;
import alexthw.ars_elemental.common.blocks.prism.PiercingPrismLens;
import alexthw.ars_elemental.common.blocks.prism.RainbowPrismLens;
import alexthw.ars_elemental.common.blocks.prism.SpellMirror;
import alexthw.ars_elemental.common.blocks.upstream.AirUpstreamTile;
import alexthw.ars_elemental.common.blocks.upstream.MagmaUpstreamTile;
import alexthw.ars_elemental.common.blocks.upstream.UpstreamBlock;
import alexthw.ars_elemental.common.blocks.upstream.WaterUpstreamTile;
import alexthw.ars_elemental.common.items.CasterHolder;
import alexthw.ars_elemental.common.items.CurioHolder;
import alexthw.ars_elemental.common.items.Debugger;
import alexthw.ars_elemental.common.items.FirenandoCharm;
import alexthw.ars_elemental.common.items.FlashjackCharm;
import alexthw.ars_elemental.common.items.SirenCharm;
import alexthw.ars_elemental.common.items.armor.ArmorSet;
import alexthw.ars_elemental.common.items.bangles.AirBangles;
import alexthw.ars_elemental.common.items.bangles.AnimaBangles;
import alexthw.ars_elemental.common.items.bangles.BaseBangle;
import alexthw.ars_elemental.common.items.bangles.EarthBangles;
import alexthw.ars_elemental.common.items.bangles.FireBangles;
import alexthw.ars_elemental.common.items.bangles.SummonBangles;
import alexthw.ars_elemental.common.items.bangles.WaterBangles;
import alexthw.ars_elemental.common.items.caster_tools.SpellHorn;
import alexthw.ars_elemental.common.items.foci.ElementalFocus;
import alexthw.ars_elemental.common.items.foci.GreaterElementalFocus;
import alexthw.ars_elemental.common.items.foci.NecroticFocus;
import alexthw.ars_elemental.datagen.AETagsProvider;
import alexthw.ars_elemental.registry.ModPotions;
import alexthw.ars_elemental.world.ModWorldgen;
import com.alexthw.sauce.client.FocusTurretRenderer;
import com.alexthw.sauce.common.block.FocusEnhancedSpellTurret;
import com.alexthw.sauce.common.item.NecroEssence;
import com.alexthw.sauce.common.item.SchoolCasterTome;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.common.block.ArchfruitPod;
import com.hollingsworth.arsnouveau.common.block.MagicLeaves;
import com.hollingsworth.arsnouveau.common.block.SourceBerryBush;
import com.hollingsworth.arsnouveau.common.block.StrippableLog;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.RendererBlockItem;
import com.hollingsworth.arsnouveau.common.items.data.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.common.world.tree.MagicTree;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.CaveVinesBlock;
import net.minecraft.world.level.block.CaveVinesPlantBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.createItems((String)"ars_elemental");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.createBlocks((String)"ars_elemental");
    public static final DeferredHolder<Block, ? extends Block> MERMAID_ROCK;
    public static final DeferredHolder<Block, ? extends Block> WATER_URN;
    public static final DeferredHolder<Block, ? extends Block> FLASHING_ARCHWOOD_LOG;
    public static final DeferredHolder<Block, ? extends Block> FLASHING_ARCHWOOD_LOG_STRIPPED;
    public static final DeferredHolder<Block, ? extends Block> FLASHING_ARCHWOOD_STRIPPED;
    public static final DeferredHolder<Block, ? extends Block> FLASHING_ARCHWOOD;
    public static final DeferredHolder<Block, ? extends Block> FLASHING_SAPLING;
    public static final DeferredHolder<Block, ? extends Block> FLASHING_LEAVES;
    public static final DeferredHolder<Block, ArchfruitPod> FLASHING_POD;
    public static final DeferredHolder<Block, FlowerPotBlock> POT_FLASHING_SAPLING;
    public static final DeferredHolder<Block, ? extends Block> SPARKFLOWER;
    public static final DeferredHolder<Block, FlowerPotBlock> POT_SPARKFLOWER;
    public static final DeferredHolder<Block, ? extends Block> GROUND_BLOSSOM;
    public static final DeferredHolder<Block, CaveVinesBlock> SOURCE_VINES;
    public static final DeferredHolder<Block, CaveVinesPlantBlock> SOURCE_VINES_PLANT;
    public static final DeferredHolder<Block, ? extends Block> WATER_UPSTREAM_BLOCK;
    public static final DeferredHolder<Block, ? extends Block> LAVA_UPSTREAM_BLOCK;
    public static final DeferredHolder<Block, ? extends Block> AIR_UPSTREAM_BLOCK;
    public static final DeferredHolder<Block, ? extends Block> FIRE_TURRET;
    public static final DeferredHolder<Block, ? extends Block> WATER_TURRET;
    public static final DeferredHolder<Block, ? extends Block> AIR_TURRET;
    public static final DeferredHolder<Block, ? extends Block> EARTH_TURRET;
    public static final DeferredHolder<Block, ? extends Block> SHAPING_TURRET;
    public static final DeferredHolder<Block, AdvancedPrism> ADVANCED_PRISM;
    public static final DeferredHolder<Block, ? extends Block> SPELL_MIRROR;
    public static final DeferredHolder<Item, GreaterElementalFocus> FIRE_FOCUS;
    public static final DeferredHolder<Item, GreaterElementalFocus> AIR_FOCUS;
    public static final DeferredHolder<Item, GreaterElementalFocus> WATER_FOCUS;
    public static final DeferredHolder<Item, GreaterElementalFocus> EARTH_FOCUS;
    public static final DeferredHolder<Item, NecroticFocus> NECRO_FOCUS;
    public static final DeferredHolder<Item, ElementalFocus> LESSER_FIRE_FOCUS;
    public static final DeferredHolder<Item, ElementalFocus> LESSER_AIR_FOCUS;
    public static final DeferredHolder<Item, ElementalFocus> LESSER_WATER_FOCUS;
    public static final DeferredHolder<Item, ElementalFocus> LESSER_EARTH_FOCUS;
    public static final ArmorSet FIRE_ARMOR;
    public static final ArmorSet AIR_ARMOR;
    public static final ArmorSet EARTH_ARMOR;
    public static final ArmorSet WATER_ARMOR;
    public static final ArmorSet FIRE_ARMOR_L;
    public static final ArmorSet AIR_ARMOR_L;
    public static final ArmorSet EARTH_ARMOR_L;
    public static final ArmorSet WATER_ARMOR_L;
    public static final ArmorSet FIRE_ARMOR_H;
    public static final ArmorSet AIR_ARMOR_H;
    public static final ArmorSet EARTH_ARMOR_H;
    public static final ArmorSet WATER_ARMOR_H;
    public static final DeferredHolder<Item, SchoolCasterTome> FIRE_CTOME;
    public static final DeferredHolder<Item, SchoolCasterTome> AIR_CTOME;
    public static final DeferredHolder<Item, SchoolCasterTome> WATER_CTOME;
    public static final DeferredHolder<Item, SchoolCasterTome> EARTH_CTOME;
    public static final DeferredHolder<Item, SchoolCasterTome> NECRO_CTOME;
    public static final DeferredHolder<Item, SchoolCasterTome> SHAPERS_CTOME;
    public static final DeferredHolder<Item, BaseBangle> ENCHANTER_BANGLE;
    public static final DeferredHolder<Item, FireBangles> FIRE_BANGLE;
    public static final DeferredHolder<Item, WaterBangles> WATER_BANGLE;
    public static final DeferredHolder<Item, AirBangles> AIR_BANGLE;
    public static final DeferredHolder<Item, EarthBangles> EARTH_BANGLE;
    public static final DeferredHolder<Item, SummonBangles> SUMMON_BANGLE;
    public static final DeferredHolder<Item, AnimaBangles> ANIMA_BANGLE;
    public static final DeferredHolder<Item, CurioHolder> CURIO_BAG;
    public static final DeferredHolder<Item, CasterHolder> CASTER_BAG;
    public static final DeferredHolder<Item, Debugger> DEBUG_ICON;
    public static final DeferredItem<Item> MARK_OF_MASTERY;
    public static final DeferredHolder<Item, HomingPrismLens> HOMING_LENS;
    public static final DeferredHolder<Item, ArcPrismLens> ARC_LENS;
    public static final DeferredHolder<Item, AccelerationPrismLens> ACC_LENS;
    public static final DeferredHolder<Item, DecelerationPrismLens> DEC_LENS;
    public static final DeferredHolder<Item, PiercingPrismLens> PIERCE_LENS;
    public static final DeferredHolder<Item, RainbowPrismLens> RGB_LENS;
    public static final DeferredHolder<Item, ChainingPrismLens> CHAIN_LENS;
    public static final DeferredHolder<Item, NecroEssence> ANIMA_ESSENCE;
    public static final DeferredHolder<Item, ModItem> SIREN_SHARDS;
    public static final DeferredHolder<Item, SirenCharm> SIREN_CHARM;
    public static final DeferredHolder<Item, FirenandoCharm> FIRENANDO_CHARM;
    public static final DeferredHolder<Item, ModItem> FLASHJACK_SHARDS;
    public static final DeferredHolder<Item, FlashjackCharm> FLASHJACK_CHARM;
    public static final DeferredHolder<Item, SpellHorn> SPELL_HORN;
    public static FoodProperties FLASHPINE_FOOD;

    static InteractionResult harvestBerry(@Nullable Entity entity, BlockState state, Level level, BlockPos pos) {
        if (((Boolean)state.getValue((Property)CaveVines.BERRIES)).booleanValue()) {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)((SourceBerryBush)BlockRegistry.SOURCEBERRY_BUSH.get()).asItem().getDefaultInstance());
            float f = Mth.randomBetween((RandomSource)level.random, (float)0.8f, (float)1.2f);
            level.playSound(null, pos, SoundEvents.CAVE_VINES_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, f);
            BlockState blockstate = (BlockState)state.setValue((Property)CaveVines.BERRIES, (Comparable)Boolean.FALSE);
            level.setBlock(pos, blockstate, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)blockstate));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    static Item.Properties itemProps() {
        return new Item.Properties();
    }

    static Item.Properties FocusProp() {
        return ModItems.itemProps().stacksTo(1).fireResistant().rarity(Rarity.EPIC);
    }

    static Item.Properties UncommonProp() {
        return ModItems.itemProps().stacksTo(1).rarity(Rarity.UNCOMMON);
    }

    public static Item.Properties ArmorProp() {
        return ModItems.itemProps().stacksTo(1).rarity(Rarity.EPIC).component((Supplier)DataComponentRegistry.ARMOR_PERKS, (Object)new ArmorPerkHolder());
    }

    static DeferredHolder<Block, ? extends Block> addBlock(String name, Supplier<Block> blockSupp) {
        DeferredHolder block = BLOCKS.register(name, blockSupp);
        ITEMS.register(name, () -> new BlockItem((Block)block.get(), ModItems.itemProps()));
        return block;
    }

    static DeferredHolder<Block, ? extends Block> addGeckoBlock(String name, Supplier<Block> blockSupp, final String model) {
        DeferredHolder block = BLOCKS.register(name, blockSupp);
        ITEMS.register(name, () -> new RendererBlockItem((Block)block.get(), ModItems.itemProps()){

            @OnlyIn(value=Dist.CLIENT)
            public Supplier<BlockEntityWithoutLevelRenderer> getRenderer() {
                return () -> FocusTurretRenderer.getISTER((String)model);
            }
        });
        return block;
    }

    static BlockBehaviour.Properties blockProps(Block copyFrom, MapColor color) {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)copyFrom).mapColor(color);
    }

    private static Boolean allowsSpawnOnLeaves(BlockState state, BlockGetter reader, BlockPos pos, EntityType<?> entity) {
        return entity == EntityType.OCELOT || entity == EntityType.PARROT;
    }

    static {
        FIRE_ARMOR = new ArmorSet.Medium("fire", SpellSchools.ELEMENTAL_FIRE);
        AIR_ARMOR = new ArmorSet.Medium("air", SpellSchools.ELEMENTAL_AIR);
        EARTH_ARMOR = new ArmorSet.Medium("earth", SpellSchools.ELEMENTAL_EARTH);
        WATER_ARMOR = new ArmorSet.Medium("aqua", SpellSchools.ELEMENTAL_WATER);
        FLASHPINE_FOOD = new FoodProperties.Builder().nutrition(4).saturationModifier(0.6f).effect(() -> new MobEffectInstance(MobEffects.NIGHT_VISION, 600), 0.4f).effect(() -> new MobEffectInstance(MobEffects.GLOWING, 600), 0.4f).effect(() -> new MobEffectInstance((Holder)com.hollingsworth.arsnouveau.setup.registry.ModPotions.SHOCKED_EFFECT, 600, 0), 0.8f).effect(() -> new MobEffectInstance(ModPotions.LIGHTNING_LURE, 600, 0), 0.2f).alwaysEdible().build();
        WATER_ARMOR_H = new ArmorSet.Heavy("aqua", SpellSchools.ELEMENTAL_WATER);
        EARTH_ARMOR_H = new ArmorSet.Heavy("earth", SpellSchools.ELEMENTAL_EARTH);
        AIR_ARMOR_H = new ArmorSet.Heavy("air", SpellSchools.ELEMENTAL_AIR);
        WATER_ARMOR_L = new ArmorSet.Light("aqua", SpellSchools.ELEMENTAL_WATER);
        EARTH_ARMOR_L = new ArmorSet.Light("earth", SpellSchools.ELEMENTAL_EARTH);
        AIR_ARMOR_L = new ArmorSet.Light("air", SpellSchools.ELEMENTAL_AIR);
        FIRE_ARMOR_L = new ArmorSet.Light("fire", SpellSchools.ELEMENTAL_FIRE);
        FIRE_ARMOR_H = new ArmorSet.Heavy("fire", SpellSchools.ELEMENTAL_FIRE);
        SIREN_SHARDS = ITEMS.register("siren_shards", () -> new ModItem(ModItems.itemProps()).withTooltip((Component)Component.translatable((String)"tooltip.siren_shards")));
        FLASHJACK_SHARDS = ITEMS.register("flashjack_shards", () -> new ModItem(ModItems.itemProps()).withTooltip((Component)Component.translatable((String)"tooltip.flashjack_shards")));
        SIREN_CHARM = ITEMS.register("siren_charm", () -> new SirenCharm(ModItems.itemProps()));
        FIRENANDO_CHARM = ITEMS.register("firenando_charm", () -> new FirenandoCharm(ModItems.itemProps()));
        FLASHJACK_CHARM = ITEMS.register("flashjack_charm", () -> new FlashjackCharm(ModItems.itemProps()));
        DEBUG_ICON = ITEMS.register("debug", () -> new Debugger(new Item.Properties()));
        MARK_OF_MASTERY = (DeferredItem)ITEMS.register("mark_of_mastery", () -> new Item(ModItems.itemProps()));
        ANIMA_ESSENCE = ITEMS.register("anima_essence", () -> new NecroEssence(ModItems.itemProps()));
        SPELL_HORN = ITEMS.register("spell_horn", () -> new SpellHorn(ModItems.itemProps()));
        HOMING_LENS = ITEMS.register("homing_prism_lens", () -> new HomingPrismLens(ModItems.itemProps()));
        ARC_LENS = ITEMS.register("arc_prism_lens", () -> new ArcPrismLens(ModItems.itemProps()));
        RGB_LENS = ITEMS.register("rainbow_prism_lens", () -> new RainbowPrismLens(ModItems.itemProps()));
        ACC_LENS = ITEMS.register("acceleration_prism_lens", () -> new AccelerationPrismLens(ModItems.itemProps()));
        DEC_LENS = ITEMS.register("deceleration_prism_lens", () -> new DecelerationPrismLens(ModItems.itemProps()));
        PIERCE_LENS = ITEMS.register("piercing_prism_lens", () -> new PiercingPrismLens(ModItems.itemProps()));
        CHAIN_LENS = ITEMS.register("chaining_prism_lens", () -> new ChainingPrismLens(ModItems.itemProps()));
        CURIO_BAG = ITEMS.register("curio_bag", () -> new CurioHolder(ModItems.itemProps().fireResistant().stacksTo(1)));
        CASTER_BAG = ITEMS.register("caster_bag", () -> new CasterHolder(ModItems.itemProps().fireResistant().stacksTo(1).component(DataComponents.BASE_COLOR, (Object)DyeColor.RED)));
        FIRE_FOCUS = ITEMS.register("fire_focus", () -> new GreaterElementalFocus(ModItems.FocusProp(), SpellSchools.ELEMENTAL_FIRE));
        WATER_FOCUS = ITEMS.register("water_focus", () -> new GreaterElementalFocus(ModItems.FocusProp(), SpellSchools.ELEMENTAL_WATER));
        AIR_FOCUS = ITEMS.register("air_focus", () -> new GreaterElementalFocus(ModItems.FocusProp(), SpellSchools.ELEMENTAL_AIR));
        EARTH_FOCUS = ITEMS.register("earth_focus", () -> new GreaterElementalFocus(ModItems.FocusProp(), SpellSchools.ELEMENTAL_EARTH));
        NECRO_FOCUS = ITEMS.register("necrotic_focus", () -> new NecroticFocus(ModItems.FocusProp()));
        LESSER_FIRE_FOCUS = ITEMS.register("lesser_fire_focus", () -> new ElementalFocus(ModItems.UncommonProp(), SpellSchools.ELEMENTAL_FIRE));
        LESSER_WATER_FOCUS = ITEMS.register("lesser_water_focus", () -> new ElementalFocus(ModItems.UncommonProp(), SpellSchools.ELEMENTAL_WATER));
        LESSER_AIR_FOCUS = ITEMS.register("lesser_air_focus", () -> new ElementalFocus(ModItems.UncommonProp(), SpellSchools.ELEMENTAL_AIR));
        LESSER_EARTH_FOCUS = ITEMS.register("lesser_earth_focus", () -> new ElementalFocus(ModItems.UncommonProp(), SpellSchools.ELEMENTAL_EARTH));
        ENCHANTER_BANGLE = ITEMS.register("base_bangle", () -> new BaseBangle(ModItems.itemProps().stacksTo(1)));
        FIRE_BANGLE = ITEMS.register("fire_bangle", () -> new FireBangles(ModItems.UncommonProp()));
        WATER_BANGLE = ITEMS.register("water_bangle", () -> new WaterBangles(ModItems.UncommonProp()));
        AIR_BANGLE = ITEMS.register("air_bangle", () -> new AirBangles(ModItems.UncommonProp()));
        EARTH_BANGLE = ITEMS.register("earth_bangle", () -> new EarthBangles(ModItems.UncommonProp()));
        SUMMON_BANGLE = ITEMS.register("summon_bangle", () -> new SummonBangles(ModItems.UncommonProp()));
        ANIMA_BANGLE = ITEMS.register("anima_bangle", () -> new AnimaBangles(ModItems.UncommonProp()));
        FIRE_CTOME = ITEMS.register("fire_caster_tome", () -> new SchoolCasterTome(ModItems.itemProps(), SpellSchools.ELEMENTAL_FIRE));
        WATER_CTOME = ITEMS.register("water_caster_tome", () -> new SchoolCasterTome(ModItems.itemProps(), SpellSchools.ELEMENTAL_WATER));
        AIR_CTOME = ITEMS.register("air_caster_tome", () -> new SchoolCasterTome(ModItems.itemProps(), SpellSchools.ELEMENTAL_AIR));
        EARTH_CTOME = ITEMS.register("earth_caster_tome", () -> new SchoolCasterTome(ModItems.itemProps(), SpellSchools.ELEMENTAL_EARTH));
        NECRO_CTOME = ITEMS.register("anima_caster_tome", () -> new SchoolCasterTome(ModItems.itemProps(), SpellSchools.NECROMANCY));
        SHAPERS_CTOME = ITEMS.register("manipulation_caster_tome", () -> new SchoolCasterTome(ModItems.itemProps(), SpellSchools.MANIPULATION));
        WATER_URN = ModItems.addBlock("everfull_urn", () -> new EverfullUrnBlock(ModItems.blockProps(Blocks.CLAY, MapColor.COLOR_BROWN).sound(SoundType.PACKED_MUD).noOcclusion()));
        MERMAID_ROCK = ModItems.addBlock("mermaid_rock", () -> new MermaidRock(ModItems.blockProps(Blocks.STONE, MapColor.COLOR_LIGHT_BLUE).sound(SoundType.CORAL_BLOCK).strength(2.0f, 6.0f).noOcclusion().lightLevel(b -> 10)));
        GROUND_BLOSSOM = ModItems.addBlock("spore_blossom_up", () -> new SporeBlossomGround(ModItems.blockProps(Blocks.SPORE_BLOSSOM, MapColor.COLOR_PINK).sound(SoundType.SPORE_BLOSSOM).noOcclusion()));
        WATER_UPSTREAM_BLOCK = ModItems.addBlock("water_upstream", () -> new UpstreamBlock(ModItems.blockProps(Blocks.STONE, MapColor.COLOR_LIGHT_BLUE).sound(SoundType.STONE).strength(2.0f, 6.0f)){

            @NotNull
            public BlockEntity newBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pState) {
                return new WaterUpstreamTile(pPos, pState);
            }
        });
        LAVA_UPSTREAM_BLOCK = ModItems.addBlock("magma_upstream", () -> new UpstreamBlock(ModItems.blockProps(Blocks.STONE, MapColor.COLOR_RED).sound(SoundType.STONE).strength(2.0f, 6.0f)){

            public BlockEntity newBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pState) {
                return new MagmaUpstreamTile(pPos, pState);
            }
        });
        AIR_UPSTREAM_BLOCK = ModItems.addBlock("air_upstream", () -> new UpstreamBlock(ModItems.blockProps(Blocks.STONE, MapColor.COLOR_YELLOW).sound(SoundType.STONE).strength(2.0f, 6.0f)){

            public BlockEntity newBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pState) {
                return new AirUpstreamTile(pPos, pState);
            }
        });
        FIRE_TURRET = ModItems.addGeckoBlock("fire_turret", () -> new FocusEnhancedSpellTurret(ModItems.blockProps(Blocks.GOLD_BLOCK, MapColor.COLOR_RED).sound(SoundType.STONE).strength(2.0f, 6.0f), SpellSchools.ELEMENTAL_FIRE), "fire");
        WATER_TURRET = ModItems.addGeckoBlock("water_turret", () -> new FocusEnhancedSpellTurret(ModItems.blockProps(Blocks.GOLD_BLOCK, MapColor.COLOR_LIGHT_BLUE).sound(SoundType.STONE).strength(2.0f, 6.0f), SpellSchools.ELEMENTAL_WATER), "water");
        AIR_TURRET = ModItems.addGeckoBlock("air_turret", () -> new FocusEnhancedSpellTurret(ModItems.blockProps(Blocks.GOLD_BLOCK, MapColor.COLOR_YELLOW).sound(SoundType.STONE).strength(2.0f, 6.0f), SpellSchools.ELEMENTAL_AIR), "air");
        EARTH_TURRET = ModItems.addGeckoBlock("earth_turret", () -> new FocusEnhancedSpellTurret(ModItems.blockProps(Blocks.GOLD_BLOCK, MapColor.COLOR_GREEN).sound(SoundType.STONE).strength(2.0f, 6.0f), SpellSchools.ELEMENTAL_EARTH), "earth");
        SHAPING_TURRET = ModItems.addGeckoBlock("manipulation_turret", () -> new FocusEnhancedSpellTurret(ModItems.blockProps(Blocks.GOLD_BLOCK, MapColor.COLOR_ORANGE).sound(SoundType.STONE).strength(2.0f, 6.0f), SpellSchools.MANIPULATION), "manipulation");
        ADVANCED_PRISM = BLOCKS.register("advanced_prism", () -> new AdvancedPrism(ModItems.blockProps(Blocks.STONE, MapColor.TERRACOTTA_WHITE)));
        ITEMS.register("advanced_prism", () -> new RendererBlockItem((Block)ADVANCED_PRISM.get(), ModItems.itemProps()){

            @OnlyIn(value=Dist.CLIENT)
            public Supplier<BlockEntityWithoutLevelRenderer> getRenderer() {
                return PrismRenderer::getISTER;
            }
        });
        SPELL_MIRROR = ModItems.addBlock("spell_mirror", () -> new SpellMirror(ModItems.blockProps(Blocks.STONE, MapColor.TERRACOTTA_WHITE)));
        FLASHING_SAPLING = ModItems.addBlock("yellow_archwood_sapling", () -> new SaplingBlock(MagicTree.getGrower((String)"flashing_tree", ModWorldgen.FLASHING_TREE_SAPLING), BlockRegistry.SAP_PROP));
        FLASHING_LEAVES = ModItems.addBlock("yellow_archwood_leaves", () -> new MagicLeaves(ModItems.blockProps(Blocks.OAK_LEAVES, MapColor.COLOR_YELLOW).lightLevel(b -> (Integer)ConfigHandler.Startup.FLASHING_LEAVES_LIGHT.get()).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(ModItems::allowsSpawnOnLeaves).isSuffocating((state1, reader1, pos1) -> false).isViewBlocking((state, reader, pos) -> false)));
        FLASHING_ARCHWOOD_LOG_STRIPPED = ModItems.addBlock("stripped_yellow_archwood_log", () -> new RotatedPillarBlock(BlockRegistry.LOG_PROP.mapColor(MapColor.COLOR_YELLOW).lightLevel(b -> (Integer)ConfigHandler.Startup.FLASHING_WOOD_STRIP_LIGHT.get())));
        FLASHING_ARCHWOOD_STRIPPED = ModItems.addBlock("stripped_yellow_archwood", () -> new RotatedPillarBlock(BlockRegistry.LOG_PROP.mapColor(MapColor.COLOR_YELLOW).lightLevel(b -> (Integer)ConfigHandler.Startup.FLASHING_WOOD_STRIP_LIGHT.get())));
        FLASHING_ARCHWOOD_LOG = ModItems.addBlock("yellow_archwood_log", () -> new StrippableLog(BlockRegistry.LOG_PROP.mapColor(MapColor.COLOR_YELLOW).lightLevel(b -> (Integer)ConfigHandler.Startup.FLASHING_WOOD_LIGHT.get()), () -> FLASHING_ARCHWOOD_LOG_STRIPPED.get()));
        FLASHING_ARCHWOOD = ModItems.addBlock("yellow_archwood", () -> new StrippableLog(BlockRegistry.LOG_PROP.mapColor(MapColor.COLOR_YELLOW).lightLevel(b -> (Integer)ConfigHandler.Startup.FLASHING_WOOD_LIGHT.get()), () -> FLASHING_ARCHWOOD_STRIPPED.get()));
        FLASHING_POD = BLOCKS.register("flashpine_pod", () -> new ArchfruitPod(AETagsProvider.AEBlockTagsProvider.FLASHING_LOGS));
        ITEMS.register("flashpine_pod", () -> new ItemNameBlockItem((Block)FLASHING_POD.get(), ModItems.itemProps().food(FLASHPINE_FOOD)));
        POT_FLASHING_SAPLING = BLOCKS.register("potted_yellow_archwood_sapling", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, FLASHING_SAPLING, ModItems.blockProps(Blocks.FLOWER_POT, MapColor.COLOR_YELLOW).instabreak().noOcclusion()));
        SPARKFLOWER = ModItems.addBlock("sparkflower", () -> new FlowerBlock((Holder)com.hollingsworth.arsnouveau.setup.registry.ModPotions.SHOCKED_EFFECT, 200.0f, ModItems.blockProps(Blocks.POPPY, MapColor.COLOR_YELLOW).lightLevel(b -> 8).sound(SoundType.GRASS).noOcclusion()));
        POT_SPARKFLOWER = BLOCKS.register("potted_sparkflower", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, SPARKFLOWER, ModItems.blockProps(Blocks.FLOWER_POT, MapColor.COLOR_YELLOW).instabreak().noOcclusion()));
        SOURCE_VINES = BLOCKS.register("source_vines", () -> new CaveVinesBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).randomTicks().noCollission().lightLevel(CaveVines.emission((int)14)).instabreak().sound(SoundType.CAVE_VINES).pushReaction(PushReaction.DESTROY)){

            @NotNull
            protected Block getBodyBlock() {
                return (Block)SOURCE_VINES_PLANT.get();
            }

            @NotNull
            public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader level, @NotNull BlockPos pos, @NotNull Player player) {
                return ((SourceBerryBush)BlockRegistry.SOURCEBERRY_BUSH.get()).asItem().getDefaultInstance();
            }

            @NotNull
            protected InteractionResult useWithoutItem(@NotNull BlockState p_152980_, @NotNull Level p_152981_, @NotNull BlockPos p_152982_, @NotNull Player p_152983_, @NotNull BlockHitResult p_152985_) {
                return ModItems.harvestBerry((Entity)p_152983_, p_152980_, p_152981_, p_152982_);
            }
        });
        SOURCE_VINES_PLANT = BLOCKS.register("source_vines_plant", () -> new CaveVinesPlantBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().lightLevel(CaveVines.emission((int)14)).instabreak().sound(SoundType.CAVE_VINES).pushReaction(PushReaction.DESTROY)){

            @NotNull
            protected GrowingPlantHeadBlock getHeadBlock() {
                return (GrowingPlantHeadBlock)SOURCE_VINES.get();
            }

            @NotNull
            public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader level, @NotNull BlockPos pos, @NotNull Player player) {
                return ((SourceBerryBush)BlockRegistry.SOURCEBERRY_BUSH.get()).asItem().getDefaultInstance();
            }

            @NotNull
            protected InteractionResult useWithoutItem(@NotNull BlockState p_152980_, @NotNull Level p_152981_, @NotNull BlockPos p_152982_, @NotNull Player p_152983_, @NotNull BlockHitResult p_152985_) {
                return ModItems.harvestBerry((Entity)p_152983_, p_152980_, p_152981_, p_152982_);
            }
        });
    }
}

