/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.client.CustomRenderTypes;
import mcjty.lib.client.RenderSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class RenderHelper {
    public static float rot = 0.0f;
    public static final int MAX_BRIGHTNESS = 0xF000F0;
    public static final RenderSettings DEFAULT_SETTINGS = RenderSettings.builder().color(255, 255, 255).alpha(128).build();
    public static final RenderSettings FULLBRIGHT_SETTINGS = RenderSettings.builder().color(255, 255, 255).alpha(0xF000F0).build();

    public static void renderItemGround(PoseStack matrixStack, MultiBufferSource buffer, ItemStack stack, int brightness, int combinedOverlay) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        BakedModel ibakedmodel = itemRenderer.getModel(stack, (Level)Minecraft.getInstance().level, null, 0);
        itemRenderer.render(stack, ItemDisplayContext.GROUND, false, matrixStack, buffer, brightness, combinedOverlay, ibakedmodel);
    }

    public static void renderItemGround(@Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, @Nonnull RenderType renderType, ItemStack stack, int lightmap, int overlay) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        BakedModel ibakedmodel = itemRenderer.getModel(stack, (Level)Minecraft.getInstance().level, null, 0);
        itemRenderer.render(stack, ItemDisplayContext.GROUND, false, poseStack, type -> buffer.getBuffer(renderType), lightmap, overlay, ibakedmodel);
    }

    public static void renderItemGui(PoseStack matrixStack, MultiBufferSource buffer, RenderType renderType, ItemStack stack, int brightness, int combinedOverlay) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        BakedModel ibakedmodel = itemRenderer.getModel(stack, (Level)Minecraft.getInstance().level, null, 0);
        itemRenderer.render(stack, ItemDisplayContext.GUI, false, matrixStack, type -> buffer.getBuffer(renderType), brightness, combinedOverlay, ibakedmodel);
    }

    public static void renderItemGui(PoseStack matrixStack, MultiBufferSource buffer, ItemStack stack, int brightness, int combinedOverlay) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        BakedModel ibakedmodel = itemRenderer.getModel(stack, (Level)Minecraft.getInstance().level, null, 0);
        itemRenderer.render(stack, ItemDisplayContext.GUI, false, matrixStack, buffer, brightness, combinedOverlay, ibakedmodel);
    }

    public static void renderAndDecorateItem(GuiGraphics graphics, ItemStack stack, int x, int y) {
        graphics.renderItem(stack, x, y, x * y * 31);
        graphics.renderItemDecorations(Minecraft.getInstance().font, stack, x, y, null);
    }

    public static void renderStaticFixed(PoseStack matrixStack, MultiBufferSource buffer, ItemStack stack, int brightness, int combinedOverlay) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, 0xF000F0, combinedOverlay, matrixStack, buffer, null, 0);
    }

    public static void renderText(Font font, String text, int x, int y, int color, PoseStack poseStack, MultiBufferSource buffer, int lightmapValue) {
        font.drawInBatch(text, (float)x, (float)y, color, false, poseStack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, lightmapValue);
    }

    public static void renderModel(BlockRenderDispatcher renderer, PoseStack stack, VertexConsumer buffer, BlockState state, BakedModel model, float r, float g, float b, int combinedLight, int combinedOverlay, ModelData modelData, RenderType renderType) {
        renderer.getModelRenderer().renderModel(stack.last(), buffer, state, model, r, g, b, combinedLight, combinedOverlay, modelData, renderType);
    }

    public static void line(VertexConsumer builder, PoseStack matrixStack, float x1, float y1, float z1, float x2, float y2, float z2, float red, float green, float blue, float alpha) {
        builder.addVertex(matrixStack.last().pose(), x1, y1, 0.0f).setColor(red, green, blue, alpha);
        builder.addVertex(matrixStack.last().pose(), x2, y2, 0.0f).setColor(red, green, blue, alpha);
    }

    public static void adjustTransformToDirection(PoseStack matrixStack, Direction facing) {
        matrixStack.translate(0.5f, 0.5f, 0.5f);
        switch (facing) {
            case DOWN: {
                matrixStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case UP: {
                matrixStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                break;
            }
            case NORTH: {
                matrixStack.mulPose(Axis.YP.rotationDegrees(-180.0f));
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                matrixStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                break;
            }
            case EAST: {
                matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            }
        }
        matrixStack.translate(-0.5f, -0.5f, -0.5f);
    }

    public static void renderNorthSouthQuad(PoseStack poseStack, VertexConsumer builder, TextureAtlasSprite sprite, ModelBuilder.FaceRotation rotation, float offset) {
        Matrix4f matrix = poseStack.last().pose();
        switch (rotation) {
            case ZERO: {
                RenderHelper.vt(builder, matrix, 0.0f, 1.0f, 0.73f, sprite.getU0(), sprite.getV1());
                RenderHelper.vt(builder, matrix, 1.0f, 1.0f, 0.73f, sprite.getU1(), sprite.getV1());
                RenderHelper.vt(builder, matrix, 1.0f, 0.0f, 0.73f, sprite.getU1(), sprite.getV0());
                RenderHelper.vt(builder, matrix, 0.0f, 0.0f, 0.73f, sprite.getU0(), sprite.getV0());
                break;
            }
            case CLOCKWISE_90: {
                RenderHelper.vt(builder, matrix, 0.0f, 1.0f, 0.73f, sprite.getU1(), sprite.getV0());
                RenderHelper.vt(builder, matrix, 1.0f, 1.0f, 0.73f, sprite.getU0(), sprite.getV0());
                RenderHelper.vt(builder, matrix, 1.0f, 0.0f, 0.73f, sprite.getU0(), sprite.getV1());
                RenderHelper.vt(builder, matrix, 0.0f, 0.0f, 0.73f, sprite.getU1(), sprite.getV1());
                break;
            }
            case UPSIDE_DOWN: {
                RenderHelper.vt(builder, matrix, 0.0f, 1.0f, 0.73f, sprite.getU0(), sprite.getV0());
                RenderHelper.vt(builder, matrix, 1.0f, 1.0f, 0.73f, sprite.getU0(), sprite.getV1());
                RenderHelper.vt(builder, matrix, 1.0f, 0.0f, 0.73f, sprite.getU1(), sprite.getV1());
                RenderHelper.vt(builder, matrix, 0.0f, 0.0f, 0.73f, sprite.getU1(), sprite.getV0());
                break;
            }
            case COUNTERCLOCKWISE_90: {
                RenderHelper.vt(builder, matrix, 0.0f, 1.0f, 0.73f, sprite.getU1(), sprite.getV1());
                RenderHelper.vt(builder, matrix, 1.0f, 1.0f, 0.73f, sprite.getU1(), sprite.getV0());
                RenderHelper.vt(builder, matrix, 1.0f, 0.0f, 0.73f, sprite.getU0(), sprite.getV0());
                RenderHelper.vt(builder, matrix, 0.0f, 0.0f, 0.73f, sprite.getU0(), sprite.getV1());
            }
        }
    }

    private static void renderEntity(GuiGraphics graphics, Entity entity, int xPos, int yPos, float scale) {
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.pushPose();
        matrixStack.translate((float)(xPos + 8), (float)(yPos + 16), 50.0f);
        matrixStack.scale(-scale, scale, scale);
        matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        matrixStack.mulPose(Axis.YP.rotationDegrees(135.0f));
        matrixStack.mulPose(Axis.YN.rotationDegrees(135.0f));
        matrixStack.mulPose(Axis.YP.rotationDegrees(rot));
        entity.setXRot(0.0f);
        Vec3 rp = entity.getPassengerRidingPosition(entity.getFirstPassenger());
        matrixStack.translate(rp.x, rp.y, rp.z);
        matrixStack.popPose();
        matrixStack.translate(0.0f, 0.0f, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i1 = 240;
        int k1 = 240;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager._disableDepthTest();
        matrixStack.popPose();
    }

    public static boolean renderObject(GuiGraphics graphics, int x, int y, Object itm, boolean highlight) {
        if (itm instanceof Entity) {
            RenderHelper.renderEntity(graphics, (Entity)itm, x, y, 10.0f);
            return true;
        }
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        return RenderHelper.renderObject(graphics, itemRenderer, x, y, itm, highlight, 100.0f);
    }

    public static boolean renderObject(GuiGraphics graphics, ItemRenderer itemRender, int x, int y, Object itm, boolean highlight, float lvl) {
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        matrixStack.translate(0.0f, 0.0f, lvl);
        boolean b = RenderHelper.renderObjectInternal(graphics, itemRender, x, y, itm, highlight, lvl);
        matrixStack.popPose();
        return b;
    }

    private static boolean renderObjectInternal(GuiGraphics graphics, ItemRenderer itemRender, int x, int y, Object itm, boolean highlight, float lvl) {
        if (itm == null) {
            return RenderHelper.renderItemStack(graphics, itemRender, ItemStack.EMPTY, x, y, "", highlight);
        }
        if (itm instanceof Item) {
            return RenderHelper.renderItemStack(graphics, itemRender, new ItemStack((ItemLike)((Item)itm), 1), x, y, "", highlight);
        }
        if (itm instanceof Block) {
            return RenderHelper.renderItemStack(graphics, itemRender, new ItemStack((ItemLike)((Block)itm), 1), x, y, "", highlight);
        }
        if (itm instanceof ItemStack) {
            return RenderHelper.renderItemStackWithCount(graphics, itemRender, (ItemStack)itm, x, y, highlight);
        }
        if (itm instanceof FluidStack) {
            return RenderHelper.renderFluidStack((FluidStack)itm, x, y, highlight);
        }
        if (itm instanceof TextureAtlasSprite) {
            return RenderHelper.renderIcon(graphics, itemRender, (TextureAtlasSprite)itm, x, y, highlight);
        }
        return RenderHelper.renderItemStack(graphics, itemRender, ItemStack.EMPTY, x, y, "", highlight);
    }

    private static boolean renderIcon(GuiGraphics graphics, ItemRenderer itemRender, TextureAtlasSprite itm, int xo, int yo, boolean highlight) {
        return true;
    }

    public static boolean renderFluidStack(FluidStack fluidStack, int x, int y, boolean highlight) {
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return false;
        }
        IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        ResourceLocation fluidStill = attributes.getStillTexture(fluidStack);
        TextureAtlasSprite fluidStillSprite = null;
        if (fluidStill != null) {
            fluidStillSprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(fluidStill);
        }
        if (fluidStillSprite == null) {
            return false;
        }
        int fluidColor = attributes.getTintColor(fluidStack);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        RenderHelper.setGLColorFromInt(fluidColor);
        RenderHelper.drawFluidTexture(x, y, fluidStillSprite, 100.0);
        return true;
    }

    private static void drawFluidTexture(double xCoord, double yCoord, TextureAtlasSprite textureSprite, double zLevel) {
        float uMin = textureSprite.getU0();
        float uMax = textureSprite.getU1();
        float vMin = textureSprite.getV0();
        float vMax = textureSprite.getV1();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder vertexBuffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        vertexBuffer.addVertex((float)xCoord, (float)(yCoord + 16.0), (float)zLevel).setUv(uMin, vMax);
        vertexBuffer.addVertex((float)(xCoord + 16.0), (float)(yCoord + 16.0), (float)zLevel).setUv(uMax, vMax);
        vertexBuffer.addVertex((float)(xCoord + 16.0), (float)yCoord, (float)zLevel).setUv(uMax, vMin);
        vertexBuffer.addVertex((float)xCoord, (float)yCoord, (float)zLevel).setUv(uMin, vMin);
        BufferUploader.drawWithShader((MeshData)vertexBuffer.buildOrThrow());
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public static boolean renderItemStackWithCount(GuiGraphics graphics, ItemRenderer itemRender, ItemStack itm, int xo, int yo, boolean highlight) {
        int size = itm.getCount();
        Object amount = size <= 1 ? "" : (size < 100000 ? String.valueOf(size) : (size < 1000000 ? size / 1000 + "k" : (size < 1000000000 ? size / 1000000 + "m" : size / 1000000000 + "g")));
        return RenderHelper.renderItemStack(graphics, itemRender, itm, xo, yo, (String)amount, highlight);
    }

    public static boolean renderItemStack(GuiGraphics graphics, ItemRenderer itemRender, ItemStack itm, int x, int y, String txt, boolean highlight) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean rc = false;
        if (highlight) {
            RenderHelper.drawVerticalGradientRect(x, y, x + 16, y + 16, -2130706433, -1);
        }
        PoseStack matrixStack = graphics.pose();
        if (!itm.isEmpty() && itm.getItem() != null) {
            rc = true;
            matrixStack.pushPose();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.renderItem(itm, x, y, x * y * 31);
            RenderHelper.renderGuiItemDecorations(itemRender, Minecraft.getInstance().font, itm, x, y, txt, txt.length() - 2);
            matrixStack.popPose();
        }
        return rc;
    }

    private static void renderGuiItemDecorations(ItemRenderer itemRender, Font font, ItemStack stack, int x, int y, @Nullable String text, int scaled) {
        if (!stack.isEmpty()) {
            LocalPlayer localplayer;
            float f;
            PoseStack posestack = new PoseStack();
            if (stack.getCount() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.getCount()) : text;
                posestack.translate(0.0, 0.0, 380.0);
                MultiBufferSource.BufferSource source = Minecraft.getInstance().renderBuffers().bufferSource();
                if (scaled >= 2) {
                    posestack.pushPose();
                    posestack.scale(0.5f, 0.5f, 0.5f);
                    font.drawInBatch(s, (float)((x + 19 - 2) * 2 - 1 - font.width(s)), (float)(y * 2 + 24), 0xFFFFFF, true, posestack.last().pose(), (MultiBufferSource)source, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                    posestack.popPose();
                } else if (scaled == 1) {
                    posestack.pushPose();
                    posestack.scale(0.75f, 0.75f, 0.75f);
                    font.drawInBatch(s, (float)(x - 2) * 1.34f + 24.0f - (float)font.width(s), (float)y * 1.34f + 14.0f, 0xFFFFFF, true, posestack.last().pose(), (MultiBufferSource)source, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                    posestack.popPose();
                } else {
                    font.drawInBatch(s, (float)(x + 19 - 2 - font.width(s)), (float)(y + 6 + 3), 0xFFFFFF, true, posestack.last().pose(), (MultiBufferSource)source, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                }
                source.endBatch();
            }
            if (stack.isBarVisible()) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableBlend();
                Tesselator tesselator = Tesselator.getInstance();
                int i = stack.getBarWidth();
                int j = stack.getBarColor();
                RenderHelper.fillRect(x + 2, y + 13, 13, 2, 0, 0, 0, 255);
                RenderHelper.fillRect(x + 2, y + 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableDepthTest();
            }
            float f2 = f = (localplayer = Minecraft.getInstance().player) == null ? 0.0f : localplayer.getCooldowns().getCooldownPercent(stack.getItem(), Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false));
            if (f > 0.0f) {
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderHelper.fillRect(x, y + Mth.floor((float)(16.0f * (1.0f - f))), 16, Mth.ceil((float)(16.0f * f)), 255, 255, 255, 127);
                RenderSystem.enableDepthTest();
            }
        }
    }

    private static void fillRect(int pX, int pY, int pWidth, int pHeight, int pRed, int pGreen, int pBlue, int pAlpha) {
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        builder.addVertex((float)(pX + 0), (float)(pY + 0), 0.0f).setColor(pRed, pGreen, pBlue, pAlpha);
        builder.addVertex((float)(pX + 0), (float)(pY + pHeight), 0.0f).setColor(pRed, pGreen, pBlue, pAlpha);
        builder.addVertex((float)(pX + pWidth), (float)(pY + pHeight), 0.0f).setColor(pRed, pGreen, pBlue, pAlpha);
        builder.addVertex((float)(pX + pWidth), (float)(pY + 0), 0.0f).setColor(pRed, pGreen, pBlue, pAlpha);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    private static void draw(int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        BufferBuilder renderer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        renderer.addVertex((float)(x + 0), (float)(y + 0), 0.0f).setColor(red, green, blue, alpha);
        renderer.addVertex((float)(x + 0), (float)(y + height), 0.0f).setColor(red, green, blue, alpha);
        renderer.addVertex((float)(x + width), (float)(y + height), 0.0f).setColor(red, green, blue, alpha);
        renderer.addVertex((float)(x + width), (float)(y + 0), 0.0f).setColor(red, green, blue, alpha);
        BufferUploader.drawWithShader((MeshData)renderer.buildOrThrow());
    }

    public static void drawVerticalGradientRect(int x1, int y1, int x2, int y2, int color1, int color2) {
        float zLevel = 0.0f;
        float f = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color1 & 0xFF) / 255.0f;
        float f4 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(color2 & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.value, (int)GlStateManager.SourceFactor.ONE.value, (int)GlStateManager.DestFactor.ZERO.value);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex((float)x2, (float)y1, zLevel).setColor(f1, f2, f3, f);
        buffer.addVertex((float)x1, (float)y1, zLevel).setColor(f1, f2, f3, f);
        buffer.addVertex((float)x1, (float)y2, zLevel).setColor(f5, f6, f7, f4);
        buffer.addVertex((float)x2, (float)y2, zLevel).setColor(f5, f6, f7, f4);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void drawHorizontalGradientRect(int x1, int y1, int x2, int y2, int color1, int color2) {
        float zLevel = 0.0f;
        float f = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color1 & 0xFF) / 255.0f;
        float f4 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(color2 & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.value, (int)GlStateManager.SourceFactor.ONE.value, (int)GlStateManager.DestFactor.ZERO.value);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex((float)x1, (float)y1, zLevel).setColor(f1, f2, f3, f);
        buffer.addVertex((float)x1, (float)y2, zLevel).setColor(f1, f2, f3, f);
        buffer.addVertex((float)x2, (float)y2, zLevel).setColor(f5, f6, f7, f4);
        buffer.addVertex((float)x2, (float)y1, zLevel).setColor(f5, f6, f7, f4);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void drawHorizontalGradientRect(GuiGraphics graphics, MultiBufferSource buffer, int x1, int y1, int x2, int y2, int color1, int color2, int lightmap) {
        float zLevel = -0.5f;
        float f = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color1 & 0xFF) / 255.0f;
        float f4 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(color2 & 0xFF) / 255.0f;
        VertexConsumer builder = buffer.getBuffer(CustomRenderTypes.QUADS_NOTEXTURE);
        Matrix4f positionMatrix = graphics.pose().last().pose();
        builder.addVertex(positionMatrix, (float)x1, (float)y1, zLevel).setColor(f1, f2, f3, f).setLight(lightmap);
        builder.addVertex(positionMatrix, (float)x1, (float)y2, zLevel).setColor(f1, f2, f3, f).setLight(lightmap);
        builder.addVertex(positionMatrix, (float)x2, (float)y2, zLevel).setColor(f5, f6, f7, f4).setLight(lightmap);
        builder.addVertex(positionMatrix, (float)x2, (float)y1, zLevel).setColor(f5, f6, f7, f4).setLight(lightmap);
    }

    public static void drawHorizontalLine(GuiGraphics graphics, int x1, int y1, int x2, int color) {
        graphics.fill(x1, y1, x2, y1 + 1, color);
    }

    public static void drawVerticalLine(GuiGraphics graphics, int x1, int y1, int y2, int color) {
        graphics.fill(x1, y1, x1 + 1, y2, color);
    }

    public static void drawLeftTriangle(GuiGraphics graphics, int x, int y, int color) {
        RenderHelper.drawVerticalLine(graphics, x, y, y, color);
        RenderHelper.drawVerticalLine(graphics, x + 1, y - 1, y + 1, color);
        RenderHelper.drawVerticalLine(graphics, x + 2, y - 2, y + 2, color);
    }

    public static void drawRightTriangle(GuiGraphics graphics, int x, int y, int color) {
        RenderHelper.drawVerticalLine(graphics, x, y, y, color);
        RenderHelper.drawVerticalLine(graphics, x - 1, y - 1, y + 1, color);
        RenderHelper.drawVerticalLine(graphics, x - 2, y - 2, y + 2, color);
    }

    public static void drawUpTriangle(GuiGraphics graphics, int x, int y, int color) {
        RenderHelper.drawHorizontalLine(graphics, x, y, x, color);
        RenderHelper.drawHorizontalLine(graphics, x - 1, y + 1, x + 1, color);
        RenderHelper.drawHorizontalLine(graphics, x - 2, y + 2, x + 2, color);
    }

    public static void drawDownTriangle(GuiGraphics graphics, int x, int y, int color) {
        RenderHelper.drawHorizontalLine(graphics, x, y, x, color);
        RenderHelper.drawHorizontalLine(graphics, x - 1, y - 1, x + 1, color);
        RenderHelper.drawHorizontalLine(graphics, x - 2, y - 2, x + 2, color);
    }

    public static void drawColorLogic(int x, int y, int width, int height, int red, int green, int blue, GlStateManager.LogicOp colorLogic) {
        GlStateManager._enableColorLogicOp();
        GlStateManager._logicOp((int)colorLogic.value);
        RenderHelper.draw(x, y, width, height, red, green, blue, 255);
        GlStateManager._disableColorLogicOp();
    }

    public static void drawThickButtonBox(GuiGraphics graphics, int x1, int y1, int x2, int y2, int bright, int average, int dark) {
        graphics.fill(x1 + 2, y1 + 2, x2 - 2, y2 - 2, average);
        RenderHelper.drawHorizontalLine(graphics, x1 + 1, y1, x2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawHorizontalLine(graphics, x1 + 1, y2 - 1, x2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawVerticalLine(graphics, x1, y1 + 1, y2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawVerticalLine(graphics, x2 - 1, y1 + 1, y2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawHorizontalLine(graphics, x1 + 1, y1 + 1, x2 - 1, bright);
        RenderHelper.drawHorizontalLine(graphics, x1 + 2, y1 + 2, x2 - 2, bright);
        RenderHelper.drawVerticalLine(graphics, x1 + 1, y1 + 2, y2 - 2, bright);
        RenderHelper.drawVerticalLine(graphics, x1 + 2, y1 + 3, y2 - 3, bright);
        RenderHelper.drawHorizontalLine(graphics, x1 + 3, y2 - 3, x2 - 2, dark);
        RenderHelper.drawHorizontalLine(graphics, x1 + 2, y2 - 2, x2 - 1, dark);
        RenderHelper.drawVerticalLine(graphics, x2 - 2, y1 + 2, y2 - 2, dark);
        RenderHelper.drawVerticalLine(graphics, x2 - 3, y1 + 3, y2 - 3, dark);
    }

    public static void drawThinButtonBox(GuiGraphics graphics, int x1, int y1, int x2, int y2, int bright, int average, int dark) {
        graphics.fill(x1 + 1, y1 + 1, x2 - 1, y2 - 1, average);
        RenderHelper.drawHorizontalLine(graphics, x1 + 1, y1, x2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawHorizontalLine(graphics, x1 + 1, y2 - 1, x2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawVerticalLine(graphics, x1, y1 + 1, y2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawVerticalLine(graphics, x2 - 1, y1 + 1, y2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawHorizontalLine(graphics, x1 + 1, y1 + 1, x2 - 2, bright);
        RenderHelper.drawVerticalLine(graphics, x1 + 1, y1 + 2, y2 - 3, bright);
        RenderHelper.drawHorizontalLine(graphics, x1 + 1, y2 - 2, x2 - 1, dark);
        RenderHelper.drawVerticalLine(graphics, x2 - 2, y1 + 1, y2 - 2, dark);
    }

    public static void drawThinButtonBoxGradient(GuiGraphics graphics, int x1, int y1, int x2, int y2, int bright, int average1, int average2, int dark) {
        RenderHelper.drawVerticalGradientRect(x1 + 1, y1 + 1, x2 - 1, y2 - 1, average2, average1);
        RenderHelper.drawHorizontalLine(graphics, x1 + 1, y1, x2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawHorizontalLine(graphics, x1 + 1, y2 - 1, x2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawVerticalLine(graphics, x1, y1 + 1, y2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawVerticalLine(graphics, x2 - 1, y1 + 1, y2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawHorizontalLine(graphics, x1 + 1, y1 + 1, x2 - 2, bright);
        RenderHelper.drawVerticalLine(graphics, x1 + 1, y1 + 2, y2 - 3, bright);
        RenderHelper.drawHorizontalLine(graphics, x1 + 1, y2 - 2, x2 - 1, dark);
        RenderHelper.drawVerticalLine(graphics, x2 - 2, y1 + 1, y2 - 2, dark);
    }

    public static void drawFlatButtonBox(GuiGraphics graphics, int x1, int y1, int x2, int y2, int bright, int average, int dark) {
        RenderHelper.drawBeveledBox(graphics, x1, y1, x2, y2, bright, dark, average);
    }

    public static void drawFlatButtonBox(GuiGraphics graphics, MultiBufferSource buffer, int x1, int y1, int x2, int y2, int bright, int average, int dark, int lightmap) {
        RenderHelper.drawBeveledBox(graphics, buffer, x1, y1, x2, y2, bright, dark, average, lightmap);
    }

    public static void drawFlatButtonBoxGradient(GuiGraphics graphics, int x1, int y1, int x2, int y2, int bright, int average1, int average2, int dark) {
        RenderHelper.drawVerticalGradientRect(x1 + 1, y1 + 1, x2 - 1, y2 - 1, average2, average1);
        RenderHelper.drawHorizontalLine(graphics, x1, y1, x2 - 1, bright);
        RenderHelper.drawVerticalLine(graphics, x1, y1, y2 - 1, bright);
        RenderHelper.drawVerticalLine(graphics, x2 - 1, y1, y2 - 1, dark);
        RenderHelper.drawHorizontalLine(graphics, x1, y2 - 1, x2, dark);
    }

    public static void drawBeveledBox(GuiGraphics graphics, int x1, int y1, int x2, int y2, int topleftcolor, int botrightcolor, int fillcolor) {
        if (fillcolor != -1) {
            graphics.fill(x1 + 1, y1 + 1, x2 - 1, y2 - 1, fillcolor);
        }
        RenderHelper.drawHorizontalLine(graphics, x1, y1, x2 - 1, topleftcolor);
        RenderHelper.drawVerticalLine(graphics, x1, y1, y2 - 1, topleftcolor);
        RenderHelper.drawVerticalLine(graphics, x2 - 1, y1, y2 - 1, botrightcolor);
        RenderHelper.drawHorizontalLine(graphics, x1, y2 - 1, x2, botrightcolor);
    }

    public static void drawBeveledBox(GuiGraphics graphics, MultiBufferSource buffer, int x1, int y1, int x2, int y2, int topleftcolor, int botrightcolor, int fillcolor, int lightmap) {
        if (fillcolor != -1) {
            RenderHelper.fill(graphics, buffer, x1 + 1, y1 + 1, x2 - 1, y2 - 1, fillcolor, lightmap);
        }
        RenderHelper.fill(graphics, buffer, x1, y1, x2 - 1, y1 + 1, topleftcolor, lightmap);
        RenderHelper.fill(graphics, buffer, x1, y1, x1 + 1, y2 - 1, topleftcolor, lightmap);
        RenderHelper.fill(graphics, buffer, x2 - 1, y1, x2 - 1 + 1, y2 - 1, botrightcolor, lightmap);
        RenderHelper.fill(graphics, buffer, x1, y2 - 1, x2, y2 - 1 + 1, botrightcolor, lightmap);
    }

    public static void drawThickBeveledBox(GuiGraphics graphics, int x1, int y1, int x2, int y2, int thickness, int topleftcolor, int botrightcolor, int fillcolor) {
        if (fillcolor != -1) {
            graphics.fill(x1 + 1, y1 + 1, x2 - 1, y2 - 1, fillcolor);
        }
        graphics.fill(x1, y1, x2 - 1, y1 + thickness, topleftcolor);
        graphics.fill(x1, y1, x1 + thickness, y2 - 1, topleftcolor);
        graphics.fill(x2 - thickness, y1, x2, y2 - 1, botrightcolor);
        graphics.fill(x1, y2 - thickness, x2, y2, botrightcolor);
    }

    public static void drawFlatBox(GuiGraphics graphics, int x1, int y1, int x2, int y2, int border, int fill) {
        if (fill != -1) {
            graphics.fill(x1 + 1, y1 + 1, x2 - 1, y2 - 1, fill);
        }
        RenderHelper.drawHorizontalLine(graphics, x1, y1, x2 - 1, border);
        RenderHelper.drawVerticalLine(graphics, x1, y1, y2 - 1, border);
        RenderHelper.drawVerticalLine(graphics, x2 - 1, y1, y2 - 1, border);
        RenderHelper.drawHorizontalLine(graphics, x1, y2 - 1, x2, border);
    }

    public static void drawTexturedModalRect(PoseStack poseStack, VertexConsumer builder, int x, int y, int textureX, int textureY, int width, int height, int totw, int toth, float parentU, float parentV) {
        Matrix4f matrix = poseStack.last().pose();
        float f = 1.0f / (float)totw;
        float f1 = 1.0f / (float)toth;
        float zLevel = 50.0f;
        builder.addVertex(matrix, (float)(x + 0), (float)(y + height), zLevel).setUv(parentU + (float)(textureX + 0) * f, parentV + (float)(textureY + height) * f1);
        builder.addVertex(matrix, (float)(x + width), (float)(y + height), zLevel).setUv(parentU + (float)(textureX + width) * f, parentV + (float)(textureY + height) * f1);
        builder.addVertex(matrix, (float)(x + width), (float)(y + 0), zLevel).setUv(parentU + (float)(textureX + width) * f, parentV + (float)(textureY + 0) * f1);
        builder.addVertex(matrix, (float)(x + 0), (float)(y + 0), zLevel).setUv(parentU + (float)(textureX + 0) * f, parentV + (float)(textureY + 0) * f1);
    }

    public static void drawTexturedModalRect(PoseStack poseStack, int x, int y, int u, int v, int width, int height) {
        Matrix4f matrix = poseStack.last().pose();
        float zLevel = 0.01f;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(matrix, (float)(x + 0), (float)(y + height), zLevel).setUv((float)(u + 0) * f, (float)(v + height) * f1);
        buffer.addVertex(matrix, (float)(x + width), (float)(y + height), zLevel).setUv((float)(u + width) * f, (float)(v + height) * f1);
        buffer.addVertex(matrix, (float)(x + width), (float)(y + 0), zLevel).setUv((float)(u + width) * f, (float)(v + 0) * f1);
        buffer.addVertex(matrix, (float)(x + 0), (float)(y + 0), zLevel).setUv((float)(u + 0) * f, (float)(v + 0) * f1);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public static void renderSplitBillboard(PoseStack matrixStack, VertexConsumer buffer, float scale, Vec3 offset, ResourceLocation texture) {
        int b1 = 0xF00000;
        int b2 = 240;
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(texture);
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.5 + offset.y, 0.5);
        RenderHelper.rotateToPlayer(matrixStack);
        Matrix4f matrix = matrixStack.last().pose();
        float u0 = sprite.getU0();
        float v0 = sprite.getV0();
        float u1 = sprite.getU1();
        float v1 = sprite.getV1();
        float um = (u0 + u1) / 2.0f;
        float vm = (v0 + v1) / 2.0f;
        buffer.addVertex(matrix, -scale, -scale, 0.0f).setColor(255, 255, 255, 255).setUv(u0, v0).setUv2(b1, b2).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, -scale, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(u0, vm).setUv2(b1, b2).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(um, vm).setUv2(b1, b2).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, -scale, 0.0f).setColor(255, 255, 255, 255).setUv(um, v0).setUv2(b1, b2).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(um, vm).setUv2(b1, b2).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, scale, 0.0f).setColor(255, 255, 255, 255).setUv(um, v1).setUv2(b1, b2).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, scale, scale, 0.0f).setColor(255, 255, 255, 255).setUv(u1, v1).setUv2(b1, b2).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, scale, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(u1, vm).setUv2(b1, b2).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, -scale, 0.0f).setColor(255, 255, 255, 255).setUv(um, v0).setUv2(b1, b2).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(um, vm).setUv2(b1, b2).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, scale, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(u1, vm).setUv2(b1, b2).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, scale, -scale, 0.0f).setColor(255, 255, 255, 255).setUv(u1, v0).setUv2(b1, b2).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, -scale, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(u0, vm).setUv2(b1, b2).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, -scale, scale, 0.0f).setColor(255, 255, 255, 255).setUv(u0, v1).setUv2(b1, b2).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, scale, 0.0f).setColor(255, 255, 255, 255).setUv(um, v1).setUv2(b1, b2).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(um, vm).setUv2(b1, b2).setNormal(1.0f, 0.0f, 0.0f);
        matrixStack.popPose();
    }

    public static void renderBillboardQuadBright(PoseStack matrixStack, MultiBufferSource buffer, float scale, ResourceLocation texture) {
        RenderHelper.renderBillboardQuadBright(matrixStack, buffer, scale, texture, DEFAULT_SETTINGS);
    }

    public static void renderBillboardQuadBright(PoseStack matrixStack, VertexConsumer builder, float scale, ResourceLocation texture, RenderSettings settings) {
        int b1 = settings.brightness() >> 16 & 0xFFFF;
        int b2 = settings.brightness() & 0xFFFF;
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(texture);
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.5, 0.5);
        RenderHelper.rotateToPlayer(matrixStack);
        Matrix4f matrix = matrixStack.last().pose();
        builder.addVertex(matrix, -scale, -scale, 0.0f).setColor(settings.r(), settings.g(), settings.b(), settings.a()).setUv(sprite.getU0(), sprite.getV0()).setUv2(b1, b2).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix, -scale, scale, 0.0f).setColor(settings.r(), settings.g(), settings.b(), settings.a()).setUv(sprite.getU0(), sprite.getV1()).setUv2(b1, b2).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix, scale, scale, 0.0f).setColor(settings.r(), settings.g(), settings.b(), settings.a()).setUv(sprite.getU1(), sprite.getV1()).setUv2(b1, b2).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix, scale, -scale, 0.0f).setColor(settings.r(), settings.g(), settings.b(), settings.a()).setUv(sprite.getU1(), sprite.getV0()).setUv2(b1, b2).setNormal(1.0f, 0.0f, 0.0f);
        matrixStack.popPose();
    }

    public static void renderBillboardQuadBright(PoseStack poseStack, MultiBufferSource buffer, float scale, ResourceLocation texture, RenderSettings settings) {
        RenderHelper.renderBillboardQuadBright(poseStack, buffer.getBuffer(settings.renderType()), scale, texture, settings);
    }

    public static void rotateToPlayer(PoseStack poseStack) {
        Quaternionf cameraRotation = Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation();
        poseStack.mulPose(cameraRotation);
        poseStack.mulPose(new Quaternionf().rotateY((float)Math.PI));
    }

    public static int renderText(GuiGraphics graphics, int x, int y, String txt) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        matrixStack.translate(0.0f, 0.0f, 32.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager._disableDepthTest();
        GlStateManager._disableBlend();
        Minecraft mc = Minecraft.getInstance();
        int width = mc.font.width(txt);
        mc.font.drawInBatch(txt, (float)x, (float)y, 0xFFFFFF, true, matrixStack.last().pose(), (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        GlStateManager._enableDepthTest();
        GlStateManager._enableBlend();
        matrixStack.popPose();
        return width;
    }

    public static int renderText(GuiGraphics graphics, int x, int y, String txt, int color) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        matrixStack.translate(0.0f, 0.0f, 32.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager._disableDepthTest();
        GlStateManager._disableBlend();
        Minecraft mc = Minecraft.getInstance();
        int width = mc.font.width(txt);
        graphics.drawString(mc.font, txt, x, y, color, false);
        GlStateManager._enableDepthTest();
        GlStateManager._enableBlend();
        matrixStack.popPose();
        return width;
    }

    public static void drawBeam(PoseStack matrix, VertexConsumer builder, TextureAtlasSprite sprite, Vec3 S, Vec3 E, Vec3 P, float width) {
        Vec3 PS = S.subtract(P);
        Vec3 SE = E.subtract(S);
        Vec3 normal = PS.cross(SE).normalize();
        Vec3 half = normal.multiply((double)width, (double)width, (double)width);
        Vec3 p1 = S.add(half);
        Vec3 p2 = S.subtract(half);
        Vec3 p3 = E.add(half);
        Vec3 p4 = E.subtract(half);
        RenderHelper.drawQuad(matrix.last().pose(), builder, sprite, p1, p3, p4, p2, DEFAULT_SETTINGS);
    }

    public static void drawBeam(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, Vec3 S, Vec3 E, Vec3 P, RenderSettings settings) {
        Vec3 PS = S.subtract(P);
        Vec3 SE = E.subtract(S);
        Vec3 normal = PS.cross(SE).normalize();
        Vec3 half = normal.multiply((double)settings.width(), (double)settings.width(), (double)settings.width());
        Vec3 p1 = S.add(half);
        Vec3 p2 = S.subtract(half);
        Vec3 p3 = E.add(half);
        Vec3 p4 = E.subtract(half);
        RenderHelper.drawQuad(poseStack.last().pose(), buffer, sprite, p1, p3, p4, p2, settings);
    }

    public static void renderQuadGui(PoseStack matrixStack, TextureAtlasSprite sprite, int packedLight, VertexConsumer builder, float zfront, float size) {
        float u0 = sprite.getU0();
        float v0 = sprite.getV0();
        float u1 = sprite.getU1();
        float v1 = sprite.getV1();
        Matrix4f matrix = matrixStack.last().pose();
        RenderHelper.vt(builder, matrix, -size, size, zfront, u0, v0, packedLight);
        RenderHelper.vt(builder, matrix, size, size, zfront, u1, v0, packedLight);
        RenderHelper.vt(builder, matrix, size, -size, zfront, u1, v1, packedLight);
        RenderHelper.vt(builder, matrix, -size, -size, zfront, u0, v1, packedLight);
    }

    public static void drawQuadGui(PoseStack poseStack, VertexConsumer builder, float x1, float x2, float y1, float y2, float z, int color, int packedLightIn) {
        Matrix4f matrix = poseStack.last().pose();
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        builder.addVertex(matrix, x1, y2, z).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x2, y2, z).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x2, y1, z).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x1, y1, z).setColor(r, g, b, a).setLight(packedLightIn);
    }

    private static void drawQuad(Matrix4f matrix, VertexConsumer buffer, TextureAtlasSprite sprite, Vec3 p1, Vec3 p2, Vec3 p3, Vec3 p4, RenderSettings settings) {
        int b1 = settings.brightness() >> 16 & 0xFFFF;
        int b2 = settings.brightness() & 0xFFFF;
        RenderHelper.vt(buffer, matrix, (float)p1.x(), (float)p1.y(), (float)p1.z(), sprite.getU0(), sprite.getV0(), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
        RenderHelper.vt(buffer, matrix, (float)p2.x(), (float)p2.y(), (float)p2.z(), sprite.getU1(), sprite.getV0(), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
        RenderHelper.vt(buffer, matrix, (float)p3.x(), (float)p3.y(), (float)p3.z(), sprite.getU1(), sprite.getV1(), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
        RenderHelper.vt(buffer, matrix, (float)p4.x(), (float)p4.y(), (float)p4.z(), sprite.getU0(), sprite.getV1(), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
    }

    private static void drawQuadUnit(Matrix4f matrix, VertexConsumer buffer, TextureAtlasSprite sprite, Vec3 p1, Vec3 p2, Vec3 p3, Vec3 p4, double u0Par, double u1Par, double v0Par, double v1Par, RenderSettings settings) {
        int b1 = settings.brightness() >> 16 & 0xFFFF;
        int b2 = settings.brightness() & 0xFFFF;
        u0Par = u0Par < 0.0 ? 1.0 + u0Par % 1.0 : u0Par % 1.0;
        u1Par = u1Par < 0.0 ? -(u1Par % 1.0) : 1.0 - u1Par % 1.0;
        v0Par = v0Par < 0.0 ? 1.0 + v0Par % 1.0 : v0Par % 1.0;
        v1Par = v1Par < 0.0 ? -(v1Par % 1.0) : 1.0 - v1Par % 1.0;
        float du = sprite.getU1() - sprite.getU0();
        float dv = sprite.getV1() - sprite.getV0();
        RenderHelper.vt(buffer, matrix, (float)p1.x(), (float)p1.y(), (float)p1.z(), sprite.getU0() + (float)((double)du * u0Par), sprite.getV0() + (float)((double)dv * v0Par), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
        RenderHelper.vt(buffer, matrix, (float)p2.x(), (float)p2.y(), (float)p2.z(), sprite.getU1() - (float)((double)du * u1Par), sprite.getV0() + (float)((double)dv * v0Par), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
        RenderHelper.vt(buffer, matrix, (float)p3.x(), (float)p3.y(), (float)p3.z(), sprite.getU1() - (float)((double)du * u1Par), sprite.getV1() - (float)((double)dv * v1Par), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
        RenderHelper.vt(buffer, matrix, (float)p4.x(), (float)p4.y(), (float)p4.z(), sprite.getU0() + (float)((double)du * u0Par), sprite.getV1() - (float)((double)dv * v1Par), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
    }

    private static void drawQuad(Matrix4f matrix, VertexConsumer buffer, TextureAtlasSprite sprite, Vec3 p1, Vec3 p2, Vec3 p3, Vec3 p4, boolean opposite, RenderSettings settings) {
        int b1 = settings.brightness() >> 16 & 0xFFFF;
        int b2 = settings.brightness() & 0xFFFF;
        if (opposite) {
            RenderHelper.vt(buffer, matrix, (float)p1.x(), (float)p1.y(), (float)p1.z(), sprite.getU0(), sprite.getV0(), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
            RenderHelper.vt(buffer, matrix, (float)p2.x(), (float)p2.y(), (float)p2.z(), sprite.getU1(), sprite.getV0(), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
            RenderHelper.vt(buffer, matrix, (float)p3.x(), (float)p3.y(), (float)p3.z(), sprite.getU1(), sprite.getV1(), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
            RenderHelper.vt(buffer, matrix, (float)p4.x(), (float)p4.y(), (float)p4.z(), sprite.getU0(), sprite.getV1(), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
        } else {
            RenderHelper.vt(buffer, matrix, (float)p4.x(), (float)p4.y(), (float)p4.z(), sprite.getU0(), sprite.getV1(), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
            RenderHelper.vt(buffer, matrix, (float)p3.x(), (float)p3.y(), (float)p3.z(), sprite.getU1(), sprite.getV1(), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
            RenderHelper.vt(buffer, matrix, (float)p2.x(), (float)p2.y(), (float)p2.z(), sprite.getU1(), sprite.getV0(), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
            RenderHelper.vt(buffer, matrix, (float)p1.x(), (float)p1.y(), (float)p1.z(), sprite.getU0(), sprite.getV0(), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
        }
    }

    public static void renderRect(PoseStack poseStack, VertexConsumer buffer, Rect rect, BlockPos p, float r, float g, float b, float a) {
        Matrix4f matrix = poseStack.last().pose();
        buffer.addVertex(matrix, (float)((double)p.getX() + rect.v1.x), (float)((double)p.getY() + rect.v1.y), (float)((double)p.getZ() + rect.v1.z)).setColor(r, g, b, a);
        buffer.addVertex(matrix, (float)((double)p.getX() + rect.v2.x), (float)((double)p.getY() + rect.v2.y), (float)((double)p.getZ() + rect.v2.z)).setColor(r, g, b, a);
        buffer.addVertex(matrix, (float)((double)p.getX() + rect.v2.x), (float)((double)p.getY() + rect.v2.y), (float)((double)p.getZ() + rect.v2.z)).setColor(r, g, b, a);
        buffer.addVertex(matrix, (float)((double)p.getX() + rect.v3.x), (float)((double)p.getY() + rect.v3.y), (float)((double)p.getZ() + rect.v3.z)).setColor(r, g, b, a);
        buffer.addVertex(matrix, (float)((double)p.getX() + rect.v3.x), (float)((double)p.getY() + rect.v3.y), (float)((double)p.getZ() + rect.v3.z)).setColor(r, g, b, a);
        buffer.addVertex(matrix, (float)((double)p.getX() + rect.v4.x), (float)((double)p.getY() + rect.v4.y), (float)((double)p.getZ() + rect.v4.z)).setColor(r, g, b, a);
        buffer.addVertex(matrix, (float)((double)p.getX() + rect.v4.x), (float)((double)p.getY() + rect.v4.y), (float)((double)p.getZ() + rect.v4.z)).setColor(r, g, b, a);
        buffer.addVertex(matrix, (float)((double)p.getX() + rect.v1.x), (float)((double)p.getY() + rect.v1.y), (float)((double)p.getZ() + rect.v1.z)).setColor(r, g, b, a);
    }

    public static void drawBox(PoseStack matrixStack, VertexConsumer builder, float x1, float x2, float y1, float y2, float z1, float z2, float r, float g, float b, int packedLightIn) {
        RenderHelper.drawBox(matrixStack, builder, x1, x2, y1, y2, z1, z2, r, g, b, 1.0f, packedLightIn);
    }

    public static void drawBox(PoseStack matrixStack, VertexConsumer builder, float x1, float x2, float y1, float y2, float z1, float z2, float r, float g, float b, float a, int packedLightIn) {
        Matrix4f matrix = matrixStack.last().pose();
        builder.addVertex(matrix, x1, y1, z2).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x2, y1, z2).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x2, y2, z2).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x1, y2, z2).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x1, y2, z1).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x2, y2, z1).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x2, y1, z1).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x1, y1, z1).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x1, y2, z2).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x2, y2, z2).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x2, y2, z1).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x1, y2, z1).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x1, y1, z1).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x2, y1, z1).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x2, y1, z2).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x1, y1, z2).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x1, y1, z1).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x1, y1, z2).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x1, y2, z2).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x1, y2, z1).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x2, y2, z1).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x2, y2, z2).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x2, y1, z2).setColor(r, g, b, a).setLight(packedLightIn);
        builder.addVertex(matrix, x2, y1, z1).setColor(r, g, b, a).setLight(packedLightIn);
    }

    public static void drawBox(PoseStack matrixStack, VertexConsumer builder, TextureAtlasSprite sprite, boolean down, boolean up, boolean north, boolean south, boolean west, boolean east, float x1, float x2, float y1, float y2, float z1, float z2, RenderSettings settings) {
        Matrix4f matrix = matrixStack.last().pose();
        Vec3 c111 = new Vec3((double)x1, (double)y1, (double)z1);
        Vec3 c112 = new Vec3((double)x1, (double)y1, (double)z2);
        Vec3 c121 = new Vec3((double)x1, (double)y2, (double)z1);
        Vec3 c122 = new Vec3((double)x1, (double)y2, (double)z2);
        Vec3 c211 = new Vec3((double)x2, (double)y1, (double)z1);
        Vec3 c212 = new Vec3((double)x2, (double)y1, (double)z2);
        Vec3 c221 = new Vec3((double)x2, (double)y2, (double)z1);
        Vec3 c222 = new Vec3((double)x2, (double)y2, (double)z2);
        if (down) {
            RenderHelper.drawQuad(matrix, builder, sprite, c211, c212, c112, c111, settings);
        }
        if (up) {
            RenderHelper.drawQuad(matrix, builder, sprite, c121, c122, c222, c221, settings);
        }
        if (north) {
            RenderHelper.drawQuad(matrix, builder, sprite, c121, c221, c211, c111, settings);
        }
        if (south) {
            RenderHelper.drawQuad(matrix, builder, sprite, c112, c212, c222, c122, settings);
        }
        if (west) {
            RenderHelper.drawQuad(matrix, builder, sprite, c112, c122, c121, c111, settings);
        }
        if (east) {
            RenderHelper.drawQuad(matrix, builder, sprite, c211, c221, c222, c212, settings);
        }
    }

    public static void drawBox(PoseStack matrixStack, VertexConsumer builder, TextureAtlasSprite sprite, float x1, float x2, float y1, float y2, float z1, float z2, RenderSettings settings) {
        Matrix4f matrix = matrixStack.last().pose();
        Vec3 c111 = new Vec3((double)x1, (double)y1, (double)z1);
        Vec3 c112 = new Vec3((double)x1, (double)y1, (double)z2);
        Vec3 c121 = new Vec3((double)x1, (double)y2, (double)z1);
        Vec3 c122 = new Vec3((double)x1, (double)y2, (double)z2);
        Vec3 c211 = new Vec3((double)x2, (double)y1, (double)z1);
        Vec3 c212 = new Vec3((double)x2, (double)y1, (double)z2);
        Vec3 c221 = new Vec3((double)x2, (double)y2, (double)z1);
        Vec3 c222 = new Vec3((double)x2, (double)y2, (double)z2);
        RenderHelper.drawQuad(matrix, builder, sprite, c211, c212, c112, c111, settings);
        RenderHelper.drawQuad(matrix, builder, sprite, c121, c122, c222, c221, settings);
        RenderHelper.drawQuad(matrix, builder, sprite, c121, c221, c211, c111, settings);
        RenderHelper.drawQuad(matrix, builder, sprite, c112, c212, c222, c122, settings);
        RenderHelper.drawQuad(matrix, builder, sprite, c112, c122, c121, c111, settings);
        RenderHelper.drawQuad(matrix, builder, sprite, c211, c221, c222, c212, settings);
    }

    public static void drawBoxInside(PoseStack matrixStack, VertexConsumer builder, TextureAtlasSprite sprite, float x1, float x2, float y1, float y2, float z1, float z2, RenderSettings settings) {
        Matrix4f matrix = matrixStack.last().pose();
        Vec3 c111 = new Vec3((double)x1, (double)y1, (double)z1);
        Vec3 c112 = new Vec3((double)x1, (double)y1, (double)z2);
        Vec3 c121 = new Vec3((double)x1, (double)y2, (double)z1);
        Vec3 c122 = new Vec3((double)x1, (double)y2, (double)z2);
        Vec3 c211 = new Vec3((double)x2, (double)y1, (double)z1);
        Vec3 c212 = new Vec3((double)x2, (double)y1, (double)z2);
        Vec3 c221 = new Vec3((double)x2, (double)y2, (double)z1);
        Vec3 c222 = new Vec3((double)x2, (double)y2, (double)z2);
        RenderHelper.drawQuad(matrix, builder, sprite, c111, c112, c212, c211, settings);
        RenderHelper.drawQuad(matrix, builder, sprite, c221, c222, c122, c121, settings);
        RenderHelper.drawQuad(matrix, builder, sprite, c111, c211, c221, c121, settings);
        RenderHelper.drawQuad(matrix, builder, sprite, c122, c222, c212, c112, settings);
        RenderHelper.drawQuad(matrix, builder, sprite, c111, c121, c122, c112, settings);
        RenderHelper.drawQuad(matrix, builder, sprite, c212, c222, c221, c211, settings);
    }

    public static void drawBoxUnit(PoseStack matrixStack, VertexConsumer builder, TextureAtlasSprite sprite, boolean down, boolean up, boolean north, boolean south, boolean west, boolean east, float x1, float x2, float y1, float y2, float z1, float z2, RenderSettings settings) {
        Matrix4f matrix = matrixStack.last().pose();
        Vec3 c111 = new Vec3((double)x1, (double)y1, (double)z1);
        Vec3 c112 = new Vec3((double)x1, (double)y1, (double)z2);
        Vec3 c121 = new Vec3((double)x1, (double)y2, (double)z1);
        Vec3 c122 = new Vec3((double)x1, (double)y2, (double)z2);
        Vec3 c211 = new Vec3((double)x2, (double)y1, (double)z1);
        Vec3 c212 = new Vec3((double)x2, (double)y1, (double)z2);
        Vec3 c221 = new Vec3((double)x2, (double)y2, (double)z1);
        Vec3 c222 = new Vec3((double)x2, (double)y2, (double)z2);
        if (down) {
            RenderHelper.drawQuadUnit(matrix, builder, sprite, c211, c212, c112, c111, x1, x2, z1, z2, settings);
        }
        if (up) {
            RenderHelper.drawQuadUnit(matrix, builder, sprite, c121, c122, c222, c221, x1, x2, z1, z2, settings);
        }
        if (north) {
            RenderHelper.drawQuadUnit(matrix, builder, sprite, c121, c221, c211, c111, x1, x2, y1, y2, settings);
        }
        if (south) {
            RenderHelper.drawQuadUnit(matrix, builder, sprite, c112, c212, c222, c122, x1, x2, y1, y2, settings);
        }
        if (west) {
            RenderHelper.drawQuadUnit(matrix, builder, sprite, c112, c122, c121, c111, y1, y2, z1, z2, settings);
        }
        if (east) {
            RenderHelper.drawQuadUnit(matrix, builder, sprite, c211, c221, c222, c212, y1, y2, z1, z2, settings);
        }
    }

    public static void drawQuad(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, Direction side, boolean opposite, float offset, RenderSettings settings) {
        Matrix4f matrix = poseStack.last().pose();
        switch (side) {
            case DOWN: {
                RenderHelper.drawQuad(matrix, buffer, sprite, new Vec3(0.0, (double)offset, 1.0), new Vec3(1.0, (double)offset, 1.0), new Vec3(1.0, (double)offset, 0.0), new Vec3(0.0, (double)offset, 0.0), opposite, settings);
                break;
            }
            case UP: {
                RenderHelper.drawQuad(matrix, buffer, sprite, new Vec3(1.0, (double)(1.0f - offset), 1.0), new Vec3(0.0, (double)(1.0f - offset), 1.0), new Vec3(0.0, (double)(1.0f - offset), 0.0), new Vec3(1.0, (double)(1.0f - offset), 0.0), opposite, settings);
                break;
            }
            case NORTH: {
                RenderHelper.drawQuad(matrix, buffer, sprite, new Vec3(0.0, 0.0, (double)offset), new Vec3(1.0, 0.0, (double)offset), new Vec3(1.0, 1.0, (double)offset), new Vec3(0.0, 1.0, (double)offset), opposite, settings);
                break;
            }
            case SOUTH: {
                RenderHelper.drawQuad(matrix, buffer, sprite, new Vec3(0.0, 1.0, (double)(1.0f - offset)), new Vec3(1.0, 1.0, (double)(1.0f - offset)), new Vec3(1.0, 0.0, (double)(1.0f - offset)), new Vec3(0.0, 0.0, (double)(1.0f - offset)), opposite, settings);
                break;
            }
            case WEST: {
                RenderHelper.drawQuad(matrix, buffer, sprite, new Vec3((double)offset, 0.0, 0.0), new Vec3((double)offset, 1.0, 0.0), new Vec3((double)offset, 1.0, 1.0), new Vec3((double)offset, 0.0, 1.0), opposite, settings);
                break;
            }
            case EAST: {
                RenderHelper.drawQuad(matrix, buffer, sprite, new Vec3((double)(1.0f - offset), 0.0, 1.0), new Vec3((double)(1.0f - offset), 1.0, 1.0), new Vec3((double)(1.0f - offset), 1.0, 0.0), new Vec3((double)(1.0f - offset), 0.0, 0.0), opposite, settings);
            }
        }
    }

    public static void vt(VertexConsumer renderer, PoseStack stack, float x, float y, float z, float r, float g, float b, int packedLight) {
        renderer.addVertex(stack.last().pose(), x, y, z).setColor(r, g, b, 1.0f).setLight(packedLight).setNormal(1.0f, 0.0f, 0.0f);
    }

    public static void vt(VertexConsumer renderer, PoseStack stack, float x, float y, float z, float u, float v, int packedLight) {
        renderer.addVertex(stack.last().pose(), x, y, z).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(u, v).setLight(packedLight).setNormal(1.0f, 0.0f, 0.0f);
    }

    private static void vt(VertexConsumer renderer, Matrix4f matrix, float x, float y, float z, float u, float v, int packedLight) {
        renderer.addVertex(matrix, x, y, z).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(u, v).setLight(packedLight).setNormal(1.0f, 0.0f, 0.0f);
    }

    public static void vt(VertexConsumer renderer, PoseStack matrix, float x, float y, float z, float u, float v, int lu, int lv, int r, int g, int b, int a) {
        renderer.addVertex(matrix.last().pose(), x, y, z).setColor(r, g, b, a).setUv(u, v).setUv2(lu, lv).setNormal(1.0f, 0.0f, 0.0f);
    }

    private static void vt(VertexConsumer renderer, Matrix4f matrix, float x, float y, float z, float u, float v) {
        renderer.addVertex(matrix, x, y, z).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(u, v).setLight(0xF000F0).setNormal(1.0f, 0.0f, 0.0f);
    }

    private static void vt(VertexConsumer renderer, Matrix4f matrix, float x, float y, float z, float u, float v, int lu, int lv, int r, int g, int b, int a) {
        renderer.addVertex(matrix, x, y, z).setColor(r, g, b, a).setUv(u, v).setUv2(lu, lv).setNormal(1.0f, 0.0f, 0.0f);
    }

    public static void putVertex(VertexConsumer builder, Position normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float r, float g, float b, float a) {
        float iu = sprite.getU(u);
        float iv = sprite.getV(v);
        builder.addVertex((float)x, (float)y, (float)z).setUv(iu, iv).setUv2(0, 0).setColor(r, g, b, a).setNormal((float)normal.x(), (float)normal.y(), (float)normal.z());
    }

    public static void renderHighLightedBlocksOutline(PoseStack poseStack, VertexConsumer buffer, float mx, float my, float mz, float r, float g, float b, float a) {
        Matrix4f matrix = poseStack.last().pose();
        buffer.addVertex(matrix, mx, my, mz).setColor(r, g, b, a);
        buffer.addVertex(matrix, mx + 1.0f, my, mz).setColor(r, g, b, a);
        buffer.addVertex(matrix, mx, my, mz).setColor(r, g, b, a);
        buffer.addVertex(matrix, mx, my + 1.0f, mz).setColor(r, g, b, a);
        buffer.addVertex(matrix, mx, my, mz).setColor(r, g, b, a);
        buffer.addVertex(matrix, mx, my, mz + 1.0f).setColor(r, g, b, a);
        buffer.addVertex(matrix, mx + 1.0f, my + 1.0f, mz + 1.0f).setColor(r, g, b, a);
        buffer.addVertex(matrix, mx, my + 1.0f, mz + 1.0f).setColor(r, g, b, a);
        buffer.addVertex(matrix, mx + 1.0f, my + 1.0f, mz + 1.0f).setColor(r, g, b, a);
        buffer.addVertex(matrix, mx + 1.0f, my, mz + 1.0f).setColor(r, g, b, a);
        buffer.addVertex(matrix, mx + 1.0f, my + 1.0f, mz + 1.0f).setColor(r, g, b, a);
        buffer.addVertex(matrix, mx + 1.0f, my + 1.0f, mz).setColor(r, g, b, a);
        buffer.addVertex(matrix, mx, my + 1.0f, mz).setColor(r, g, b, a);
        buffer.addVertex(matrix, mx, my + 1.0f, mz + 1.0f).setColor(r, g, b, a);
        buffer.addVertex(matrix, mx, my + 1.0f, mz).setColor(r, g, b, a);
        buffer.addVertex(matrix, mx + 1.0f, my + 1.0f, mz).setColor(r, g, b, a);
        buffer.addVertex(matrix, mx + 1.0f, my, mz).setColor(r, g, b, a);
        buffer.addVertex(matrix, mx + 1.0f, my, mz + 1.0f).setColor(r, g, b, a);
        buffer.addVertex(matrix, mx + 1.0f, my, mz).setColor(r, g, b, a);
        buffer.addVertex(matrix, mx + 1.0f, my + 1.0f, mz).setColor(r, g, b, a);
        buffer.addVertex(matrix, mx, my, mz + 1.0f).setColor(r, g, b, a);
        buffer.addVertex(matrix, mx + 1.0f, my, mz + 1.0f).setColor(r, g, b, a);
        buffer.addVertex(matrix, mx, my, mz + 1.0f).setColor(r, g, b, a);
        buffer.addVertex(matrix, mx, my + 1.0f, mz + 1.0f).setColor(r, g, b, a);
    }

    public static void fill(GuiGraphics graphics, MultiBufferSource buffer, int x1, int y1, int x2, int y2, int color, int lightmap) {
        int swapper;
        Matrix4f positionMatrix = graphics.pose().last().pose();
        if (x1 < x2) {
            swapper = x1;
            x1 = x2;
            x2 = swapper;
        }
        if (y1 < y2) {
            swapper = y1;
            y1 = y2;
            y2 = swapper;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        VertexConsumer builder = buffer.getBuffer(CustomRenderTypes.QUADS_NOTEXTURE);
        builder.addVertex(positionMatrix, (float)x1, (float)y2, -1.0f).setColor(r, g, b, a).setLight(lightmap);
        builder.addVertex(positionMatrix, (float)x2, (float)y2, -1.0f).setColor(r, g, b, a).setLight(lightmap);
        builder.addVertex(positionMatrix, (float)x2, (float)y1, -1.0f).setColor(r, g, b, a).setLight(lightmap);
        builder.addVertex(positionMatrix, (float)x1, (float)y1, -1.0f).setColor(r, g, b, a).setLight(lightmap);
    }

    public static void rotateXP(PoseStack stack, float degrees) {
        stack.mulPose(Axis.XP.rotationDegrees(degrees));
    }

    public static void rotateYP(PoseStack stack, float degrees) {
        stack.mulPose(Axis.YP.rotationDegrees(degrees));
    }

    public static void rotateZP(PoseStack stack, float degrees) {
        stack.mulPose(Axis.ZP.rotationDegrees(degrees));
    }

    public record Rect(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4) {
    }
}

