/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import mcjty.lib.gui.GuiParser;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class WindowTools {
    public static void parseAndHandleClient(ResourceLocation guiDescription, Consumer<GuiParser.GuiCommand> consumer) {
        try {
            Optional res = Minecraft.getInstance().getResourceManager().getResource(guiDescription);
            res.ifPresent(resource -> {
                try {
                    BufferedReader br = resource.openAsReader();
                    GuiParser.parse(br).forEach(consumer);
                }
                catch (IOException | GuiParser.ParserException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Object> parseString(String s, List<ItemStack> items) {
        ArrayList<Object> l = new ArrayList<Object>();
        Object current = "";
        for (int i = 0; i < s.length(); ++i) {
            String c = s.substring(i, i + 1);
            if ("@".equals(c)) {
                ItemStack e;
                int itemIdx;
                if ((itemIdx = s.charAt(++i) - 48) == 16) {
                    current = (String)current + "@";
                    continue;
                }
                if (itemIdx < 0 || itemIdx > 9) {
                    throw new IllegalArgumentException(s);
                }
                if (!((String)current).isEmpty()) {
                    l.add(current);
                    current = "";
                }
                if ((e = items.get(itemIdx)).isEmpty()) continue;
                l.add(e);
                continue;
            }
            current = (String)current + c;
        }
        if (!((String)current).isEmpty()) {
            l.add(current);
        }
        return l;
    }
}

