/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui;

import appeng.api.stacks.AEKey;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.Scrollbar;
import appeng.core.AppEng;
import appeng.menu.AEBaseMenu;
import appeng.menu.slot.FakeSlot;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.client.AAEHotkeys;
import net.pedroksl.advanced_ae.client.gui.widgets.DirectionInputButton;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.gui.AdvPatternEncoderMenu;
import net.pedroksl.advanced_ae.network.packet.AdvPatternEncoderChangeDirectionPacket;
import net.pedroksl.ae2addonlib.client.Hotkeys;

public class AdvPatternEncoderScreen
extends AEBaseScreen<AdvPatternEncoderMenu> {
    private static final int ROW_HEIGHT = 18;
    private static final int SLOT_SIZE = 18;
    private static final int ROW_SPACING = 2;
    private static final int VISIBLE_ROWS = 3;
    private static final int LIST_ANCHOR_X = 18;
    private static final int LIST_ANCHOR_Y = 22;
    private static final int DIRECTION_BUTTONS_OFFSET_X = 1;
    private static final int DIRECTION_BUTTONS_WIDTH = 12;
    private static final int DIRECTION_BUTTONS_HEIGHT = 14;
    private static final Rect2i SLOT_BBOX = new Rect2i(146, 16, 18, 18);
    private final ResourceLocation DEFAULT_TEXTURE = AppEng.makeId((String)"textures/guis/adv_pattern_encoder.png");
    private final Scrollbar scrollbar;
    private LinkedHashMap<AEKey, Direction> inputList = new LinkedHashMap();
    private final HashMap<AEKey, DirectionInputButton[]> directionButtons = new HashMap();
    private final ArrayList<InputRow> rows = new ArrayList();

    public AdvPatternEncoderScreen(AdvPatternEncoderMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((AEBaseMenu)menu, playerInventory, title, style);
        this.scrollbar = this.widgets.addScrollBar("scrollbar", Scrollbar.SMALL);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.isCloseHotkey(keyCode, scanCode)) {
            this.getPlayer().closeContainer();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private boolean isCloseHotkey(int keyCode, int scanCode) {
        Hotkeys.AddonHotkey hotkey;
        String hotkeyId = ((AdvPatternEncoderMenu)this.getMenu()).getHost().getCloseHotkey();
        if (hotkeyId != null && (hotkey = AAEHotkeys.INSTANCE.getHotkeyMapping(hotkeyId)) != null) {
            return hotkey.mapping().matches(keyCode, scanCode);
        }
        return false;
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        int currentRow;
        ((AdvPatternEncoderMenu)this.menu).slots.removeIf(slot -> slot instanceof FakeSlot);
        this.directionButtons.forEach((key, value) -> {
            for (int x = 0; x < 7; ++x) {
                value[x].visible = false;
            }
        });
        int scrollLevel = this.scrollbar.getCurrentScroll();
        int visibleRows = Math.min(3, this.inputList.size());
        for (int i = 0; i < visibleRows && (currentRow = scrollLevel + i) < this.inputList.size(); ++i) {
            InputRow row = this.rows.get(currentRow);
            guiGraphics.renderItem(row.key().wrapForDisplayOrFilter(), 19, 23 + i * 20);
            DirectionInputButton[] buttons = this.directionButtons.get(row.key);
            int highlight = this.getSelectedDirButton(row.dir);
            for (int col = 0; col < 7; ++col) {
                DirectionInputButton button = buttons[col];
                button.setPosition(this.leftPos + 18 + 2 + 18 + (col + 1) * 1 + col * 12, this.topPos + 22 + 1 + i * 20);
                button.setHighlighted(col == highlight);
                button.visible = true;
            }
        }
    }

    public void drawBG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        super.drawBG(guiGraphics, offsetX, offsetY, mouseX, mouseY, partialTicks);
        int currentX = offsetX + 18;
        int currentY = offsetY + 22;
        int visibleRows = Math.min(3, this.inputList.size());
        for (int i = 0; i < visibleRows; ++i) {
            guiGraphics.blit(this.DEFAULT_TEXTURE, currentX, currentY, SLOT_BBOX.getX(), SLOT_BBOX.getY(), SLOT_BBOX.getWidth(), SLOT_BBOX.getHeight());
            currentY += 20;
        }
    }

    public void init() {
        super.init();
        this.refreshList();
        ((AdvPatternEncoderMenu)this.getMenu()).onUpdateRequested();
    }

    public void update(LinkedHashMap<AEKey, Direction> inputList) {
        this.inputList.clear();
        this.directionButtons.forEach((k, v) -> {
            for (DirectionInputButton btn : v) {
                this.removeWidget((GuiEventListener)btn);
            }
        });
        this.directionButtons.clear();
        this.rows.clear();
        this.inputList = inputList;
        this.refreshList();
    }

    private void refreshList() {
        for (AEKey key : this.inputList.keySet()) {
            this.rows.add(new InputRow(key, this.inputList.get(key)));
            DirectionInputButton[] buttons = new DirectionInputButton[7];
            for (int x = 0; x < 7; ++x) {
                DirectionInputButton button = new DirectionInputButton(0, 0, 12, 14, this.getDirButtonTextures(x), this::directionButtonPressed);
                button.setTooltip(Tooltip.create((Component)this.getDirButtonText(x)));
                button.setKey(key);
                button.setIndex(x);
                button.visible = false;
                buttons[x] = (DirectionInputButton)this.addRenderableWidget((GuiEventListener)button);
            }
            this.directionButtons.put(key, buttons);
        }
        this.resetScrollbar();
    }

    private void directionButtonPressed(Button b) {
        DirectionInputButton button = (DirectionInputButton)b;
        PacketDistributor.sendToServer((CustomPacketPayload)new AdvPatternEncoderChangeDirectionPacket(button.getKey(), button.getDirection()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private int getSelectedDirButton(@Nullable Direction dir) {
        if (dir == null) {
            return 0;
        }
        return switch (dir) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> 1;
            case Direction.EAST -> 2;
            case Direction.SOUTH -> 3;
            case Direction.WEST -> 4;
            case Direction.UP -> 5;
            case Direction.DOWN -> 6;
        };
    }

    private Pair<ResourceLocation, ResourceLocation> getDirButtonTextures(int index) {
        return switch (index) {
            case 1 -> new Pair((Object)AdvancedAE.makeId("textures/guis/north_button.png"), (Object)AdvancedAE.makeId("textures/guis/north_button_selected.png"));
            case 2 -> new Pair((Object)AdvancedAE.makeId("textures/guis/east_button.png"), (Object)AdvancedAE.makeId("textures/guis/east_button_selected.png"));
            case 3 -> new Pair((Object)AdvancedAE.makeId("textures/guis/south_button.png"), (Object)AdvancedAE.makeId("textures/guis/south_button_selected.png"));
            case 4 -> new Pair((Object)AdvancedAE.makeId("textures/guis/west_button.png"), (Object)AdvancedAE.makeId("textures/guis/west_button_selected.png"));
            case 5 -> new Pair((Object)AdvancedAE.makeId("textures/guis/up_button.png"), (Object)AdvancedAE.makeId("textures/guis/up_button_selected.png"));
            case 6 -> new Pair((Object)AdvancedAE.makeId("textures/guis/down_button.png"), (Object)AdvancedAE.makeId("textures/guis/down_button_selected.png"));
            default -> new Pair((Object)AdvancedAE.makeId("textures/guis/any_button.png"), (Object)AdvancedAE.makeId("textures/guis/any_button_selected.png"));
        };
    }

    private Component getDirButtonText(int index) {
        return switch (index) {
            case 1 -> Component.translatable((String)AAEText.NorthButton.getTranslationKey());
            case 2 -> Component.translatable((String)AAEText.EastButton.getTranslationKey());
            case 3 -> Component.translatable((String)AAEText.SouthButton.getTranslationKey());
            case 4 -> Component.translatable((String)AAEText.WestButton.getTranslationKey());
            case 5 -> Component.translatable((String)AAEText.UpButton.getTranslationKey());
            case 6 -> Component.translatable((String)AAEText.DownButton.getTranslationKey());
            default -> Component.translatable((String)AAEText.AnyButton.getTranslationKey());
        };
    }

    private void resetScrollbar() {
        this.scrollbar.setHeight(56);
        this.scrollbar.setRange(0, this.inputList.size() - 3, 2);
    }

    public record InputRow(AEKey key, @Nullable Direction dir) {
    }
}

