/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.beestinger;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.telepathicgrunt.the_bumblezone.client.rendering.beestinger.BeeStingerModel;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.BeeStingerEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class BeeStingerRenderer
extends EntityRenderer<BeeStingerEntity> {
    public static final ResourceLocation BEE_STINGER_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/entity/bee_stinger.png");
    private final BeeStingerModel model;

    public BeeStingerRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new BeeStingerModel(context.bakeLayer(BeeStingerModel.LAYER_LOCATION));
    }

    public void render(BeeStingerEntity beeStingerEntity, float float1, float float2, PoseStack poseStack, MultiBufferSource multiBufferSource, int int1) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)float2, (float)beeStingerEntity.yRotO, (float)beeStingerEntity.getYRot()) - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)float2, (float)beeStingerEntity.xRotO, (float)beeStingerEntity.getXRot()) + 90.0f));
        VertexConsumer vertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)multiBufferSource, (RenderType)this.model.renderType(this.getTextureLocation(beeStingerEntity)), (boolean)false, (boolean)false);
        this.model.renderToBuffer(poseStack, vertexconsumer, int1, OverlayTexture.NO_OVERLAY, -1);
        poseStack.popPose();
        super.render((Entity)beeStingerEntity, float1, float2, poseStack, multiBufferSource, int1);
    }

    public ResourceLocation getTextureLocation(BeeStingerEntity beeStingerEntity) {
        return BEE_STINGER_LOCATION;
    }
}

