/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.neoforge;

import com.telepathicgrunt.the_bumblezone.entities.teleportation.EntityTeleportationHookup;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import java.util.EnumSet;
import mekanism.api.MekanismAPI;
import mekanism.api.event.MekanismTeleportEvent;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.ModuleData;
import mekanism.api.providers.IModuleDataProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.DeferredHolder;

public class MekanismCompat
implements ModCompat {
    final DeferredHolder<ModuleData<?>, ModuleData<?>> JETPACK_UNIT = DeferredHolder.create((ResourceKey)MekanismAPI.MODULE_REGISTRY_NAME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"jetpack_unit"));
    final DeferredHolder<ModuleData<?>, ModuleData<?>> GRAV_UNIT = DeferredHolder.create((ResourceKey)MekanismAPI.MODULE_REGISTRY_NAME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"gravitational_modulating_unit"));
    public static Item JETPACK;
    public static Item JETPACK_ARMORED;

    public MekanismCompat() {
        JETPACK = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"jetpack"));
        JETPACK_ARMORED = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"jetpack_armored"));
        IEventBus forgeBus = NeoForge.EVENT_BUS;
        forgeBus.addListener(MekanismCompat::isMekaToolTeleporting);
        ModChecker.mekanismPresent = true;
    }

    @Override
    public EnumSet<ModCompat.Type> compatTypes() {
        return EnumSet.of(ModCompat.Type.HEAVY_AIR_RESTRICTED);
    }

    @Override
    public void restrictFlight(Entity entity, double extraGravity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack chestplate = player.getItemBySlot(EquipmentSlot.CHEST);
            if (JETPACK_ARMORED != null && chestplate.is(JETPACK_ARMORED) || JETPACK != null && chestplate.is(JETPACK)) {
                if (!player.getCooldowns().isOnCooldown(chestplate.getItem()) && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.displayClientMessage((Component)Component.translatable((String)"system.the_bumblezone.denied_jetpack").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.RED), true);
                }
                player.getCooldowns().addCooldown(chestplate.getItem(), 40);
            }
            if (player instanceof ServerPlayer) {
                IModule gravUnit;
                IModule jetpackUnit = IModuleHelper.INSTANCE.getModule(chestplate, (IModuleDataProvider)this.JETPACK_UNIT.get());
                if (jetpackUnit != null && jetpackUnit.isEnabled()) {
                    jetpackUnit.toggleEnabled(IModuleHelper.INSTANCE.getModuleContainer(chestplate), chestplate, player, (Component)Component.translatable((String)"system.the_bumblezone.denied_mek_jetpack_module").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.RED));
                }
                if ((gravUnit = IModuleHelper.INSTANCE.getModule(chestplate, (IModuleDataProvider)this.GRAV_UNIT.get())) != null && gravUnit.isEnabled()) {
                    gravUnit.toggleEnabled(IModuleHelper.INSTANCE.getModuleContainer(chestplate), chestplate, player, (Component)Component.translatable((String)"system.the_bumblezone.denied_mek_grav_module").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.RED));
                }
            }
        }
    }

    private static void isMekaToolTeleporting(MekanismTeleportEvent.MekaTool event) {
        Player player = event.getEntity();
        BlockHitResult blockHitResult = event.getTargetBlock();
        if (blockHitResult != null && EntityTeleportationHookup.runGenericTeleport(player, blockHitResult.getBlockPos())) {
            event.setCanceled(true);
        }
    }
}

