/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.packets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.ClientboundPacketType;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.telepathicgrunt.the_bumblezone.menus.EnchantmentSkeleton;
import com.telepathicgrunt.the_bumblezone.packets.MessageHandler;
import com.telepathicgrunt.the_bumblezone.packets.handlers.CrystallineFlowerEnchantmentPacketHandleBody;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record CrystallineFlowerEnchantmentPacket(int containerId, List<EnchantmentSkeleton> enchantmentSkeletons, ResourceLocation selectedResourceLocation) implements Packet<CrystallineFlowerEnchantmentPacket>
{
    public static final Gson GSON = new GsonBuilder().create();
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"crystalline_flower_enchantment");
    public static final ClientboundPacketType<CrystallineFlowerEnchantmentPacket> TYPE = new Handler();

    public static void sendToClient(ServerPlayer player, int containerId, List<EnchantmentSkeleton> enchantmentSkeletons, ResourceLocation selectedResourceLocation) {
        MessageHandler.DEFAULT_CHANNEL.sendToPlayer((Packet)new CrystallineFlowerEnchantmentPacket(containerId, enchantmentSkeletons, selectedResourceLocation), player);
    }

    public PacketType<CrystallineFlowerEnchantmentPacket> type() {
        return TYPE;
    }

    private static final class Handler
    implements ClientboundPacketType<CrystallineFlowerEnchantmentPacket> {
        private Handler() {
        }

        public void encode(CrystallineFlowerEnchantmentPacket message, RegistryFriendlyByteBuf buffer) {
            buffer.writeInt(message.containerId());
            buffer.writeCollection(message.enchantmentSkeletons(), (buf, enchantmentSkeleton) -> buf.writeUtf(GSON.toJson(enchantmentSkeleton)));
            buffer.writeResourceLocation(message.selectedResourceLocation);
        }

        public CrystallineFlowerEnchantmentPacket decode(RegistryFriendlyByteBuf buffer) {
            return new CrystallineFlowerEnchantmentPacket(buffer.readInt(), buffer.readList(buf -> (EnchantmentSkeleton)GSON.fromJson(buf.readUtf(), EnchantmentSkeleton.class)), buffer.readResourceLocation());
        }

        public Runnable handle(CrystallineFlowerEnchantmentPacket message) {
            return () -> CrystallineFlowerEnchantmentPacketHandleBody.handle(message);
        }

        public Class<CrystallineFlowerEnchantmentPacket> type() {
            return CrystallineFlowerEnchantmentPacket.class;
        }

        public ResourceLocation id() {
            return ID;
        }
    }
}

