/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.packets;

import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.ClientboundPacketType;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.telepathicgrunt.the_bumblezone.packets.MessageHandler;
import com.telepathicgrunt.the_bumblezone.packets.handlers.MusicPacketFromServerHandleBody;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record MusicPacketFromServer(ResourceLocation musicRL, boolean play) implements Packet<MusicPacketFromServer>
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"music_packet_from_server");
    public static final ClientboundPacketType<MusicPacketFromServer> TYPE = new Handler();

    public static void sendToClient(Player player, ResourceLocation musicRL, boolean play) {
        MessageHandler.DEFAULT_CHANNEL.sendToPlayer((Packet)new MusicPacketFromServer(musicRL, play), player);
    }

    public PacketType<MusicPacketFromServer> type() {
        return TYPE;
    }

    private static final class Handler
    implements ClientboundPacketType<MusicPacketFromServer> {
        private Handler() {
        }

        public void encode(MusicPacketFromServer message, RegistryFriendlyByteBuf buffer) {
            buffer.writeResourceLocation(message.musicRL());
            buffer.writeBoolean(message.play());
        }

        public MusicPacketFromServer decode(RegistryFriendlyByteBuf buffer) {
            return new MusicPacketFromServer(buffer.readResourceLocation(), buffer.readBoolean());
        }

        public Runnable handle(MusicPacketFromServer message) {
            return () -> MusicPacketFromServerHandleBody.handle(message);
        }

        public Class<MusicPacketFromServer> type() {
            return MusicPacketFromServer.class;
        }

        public ResourceLocation id() {
            return ID;
        }
    }
}

