/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.client.model.logic;

import com.google.common.collect.Maps;
import com.google.gson.JsonParseException;
import com.mojang.math.Transformation;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeColor;
import net.neoforged.neoforge.client.NeoForgeRenderTypes;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.CompositeModel;
import net.neoforged.neoforge.client.model.ExtraFaceData;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRClientRenderTypes;
import net.swedz.little_big_redstone.client.model.logic.LogicBakedModel;
import net.swedz.little_big_redstone.client.model.logic.LogicBakingModelData;
import net.swedz.little_big_redstone.client.model.logic.LogicModelColorSet;

public final class LogicUnbakedModel
implements IUnbakedGeometry<LogicUnbakedModel> {
    public static final ResourceLocation ID = LBR.id("logic");
    public static final IGeometryLoader<LogicUnbakedModel> LOADER = (json, context) -> new LogicUnbakedModel((LogicBakingModelData)LogicBakingModelData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(JsonParseException::new));
    private static final RenderTypeGroup NORMAL_RENDER_TYPES = new RenderTypeGroup(RenderType.translucent(), NeoForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
    private static final RenderTypeGroup SCANLINE_RENDER_TYPES = new RenderTypeGroup(RenderType.translucent(), LBRClientRenderTypes.logicScanline());
    private final LogicBakingModelData bakingModelData;

    private LogicUnbakedModel(LogicBakingModelData bakingModelData) {
        this.bakingModelData = bakingModelData;
    }

    private void bakeLayer(IGeometryBakingContext context, TextureAtlasSprite particle, ItemOverrides overrides, CompositeModel.Baked.Builder builder, int index, String texture, ExtraFaceData faceData, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState) {
        CompositeModel.Baked.Builder innerBuilder = CompositeModel.Baked.builder((IGeometryBakingContext)context, (TextureAtlasSprite)particle, (ItemOverrides)overrides, (ItemTransforms)context.getTransforms());
        TextureAtlasSprite sprite = spriteGetter.apply(new Material(InventoryMenu.BLOCK_ATLAS, this.bakingModelData.getItemTexture(texture)));
        List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)index, (TextureAtlasSprite)sprite, (ExtraFaceData)faceData);
        List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, __ -> sprite, (ModelState)modelState);
        innerBuilder.addQuads(NORMAL_RENDER_TYPES, (Collection)quads);
        builder.addLayer(innerBuilder.build());
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        try {
            TextureAtlasSprite particle = spriteGetter.apply(new Material(InventoryMenu.BLOCK_ATLAS, MissingTextureAtlasSprite.getLocation()));
            Transformation rootTransform = context.getRootTransform();
            if (!rootTransform.isIdentity()) {
                modelState = UnbakedGeometryHelper.composeRootTransformIntoModelState((ModelState)modelState, (Transformation)rootTransform);
            }
            HashMap itemModels = Maps.newHashMap();
            for (DyeColor dyeColor : DyeColor.values()) {
                LogicModelColorSet colorSet = this.bakingModelData.getColorSet(dyeColor);
                CompositeModel.Baked.Builder builder = CompositeModel.Baked.builder((IGeometryBakingContext)context, (TextureAtlasSprite)particle, (ItemOverrides)overrides, (ItemTransforms)context.getTransforms());
                this.bakeLayer(context, particle, overrides, builder, 0, "background", colorSet.backgroundFaceData(), spriteGetter, modelState);
                this.bakeLayer(context, particle, overrides, builder, 1, "border", colorSet.foregroundFaceData(), spriteGetter, modelState);
                this.bakeLayer(context, particle, overrides, builder, 2, "icon", colorSet.foregroundFaceData(), spriteGetter, modelState);
                itemModels.put(dyeColor, builder.build());
            }
            return new LogicBakedModel(this.bakingModelData, itemModels);
        }
        catch (Exception ex) {
            LBR.LOGGER.error("Failed to bake logic model {}", (Object)context.getModelName(), (Object)ex);
            throw ex;
        }
    }
}

