/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.microchip.object.MicrochipObject;
import net.swedz.tesseract.neoforge.api.Bounds;

public abstract class MicrochipObjectContainer<T extends MicrochipObject, S extends MicrochipObjectContainer<T, S>>
implements Iterable<T> {
    protected final Microchip microchip;
    protected Map<Integer, T> objects = Maps.newHashMap();

    protected MicrochipObjectContainer(Microchip microchip, List<T> objects) {
        this.microchip = microchip;
        for (MicrochipObject value : objects) {
            int slot = value.slot();
            if (this.objects.containsKey(slot)) {
                LBR.LOGGER.warn("Duplicate slot id ({}) present in {}, skipping!", (Object)slot, (Object)this.getClass().getSimpleName());
                return;
            }
            this.objects.put(slot, value);
        }
    }

    protected MicrochipObjectContainer(List<T> objects) {
        this(null, objects);
    }

    public MicrochipObjectContainer(Microchip microchip) {
        this(microchip, Lists.newArrayList());
    }

    public final List<T> values() {
        return List.copyOf(this.objects.values());
    }

    @Override
    public final Iterator<T> iterator() {
        return this.values().iterator();
    }

    public final T get(int slot) {
        return (T)((MicrochipObject)this.objects.get(slot));
    }

    public final boolean has(int slot) {
        return this.objects.containsKey(slot);
    }

    public final boolean canFit(Bounds bounds) {
        for (MicrochipObject value : this.objects.values()) {
            if (!value.overlaps(bounds)) continue;
            return false;
        }
        return true;
    }

    public final T findAt(int x, int y) {
        for (MicrochipObject value : this.objects.values()) {
            if (!value.contains(x, y)) continue;
            return (T)value;
        }
        return null;
    }

    protected final int pickAvailableSlot() {
        int slot = 0;
        while (this.objects.containsKey(slot)) {
            ++slot;
        }
        return slot;
    }

    public abstract S with(Microchip var1);

    public abstract void loadFrom(S var1);

    public void clear() {
        this.objects.clear();
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);
}

